---
generated_at: 2026-01-21 10:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：14-ALTER_TABLE処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **DROP COLUMN処理の詳細**：alter.c内の別関数の解析が必要
  2. **RENAME COLUMN処理の詳細**：alter.c内の別関数の解析が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/alter.c` 124-287行目 sqlite3AlterRenameTable()関数
- E-02: `src/alter.c` 313-466行目 sqlite3AlterFinishAddColumn()関数
- E-03: `src/alter.c` 483-500行目 sqlite3AlterBeginAddColumn()関数
- E-04: `src/alter.c` 31-44行目 isAlterableTable()関数
- E-05: `src/alter.c` 53-81行目 renameTestSchema()関数
- E-06: `src/alter.c` 111-118行目 renameReloadSchema()関数
- E-07: `src/alter.c` 11-14行目 ファイルヘッダーコメント
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.14の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ALTER TABLEはalter.cで実装される | E-07 | ○ |
| C-02 | sqlite3AlterRenameTable()がRENAME TOのエントリー | E-01 | ○ |
| C-03 | sqlite3AlterFinishAddColumn()がADD COLUMNの完了処理 | E-02 | ○ |
| C-04 | isAlterableTable()でシステムテーブルチェック | E-04 | ○ |
| C-05 | sqlite_*テーブルは変更不可 | E-04 (32行目) | ○ |
| C-06 | エポニマステーブルは変更不可 | E-04 (34行目) | ○ |
| C-07 | シャドウテーブルはDefensiveモードで変更不可 | E-04 (35-37行目) | ○ |
| C-08 | VIEWはRENAME不可 | E-01 (175-178行目) | ○ |
| C-09 | 認証チェックはSQLITE_ALTER_TABLE | E-01 (183行目) | ○ |
| C-10 | 仮想テーブルはxRename()を呼び出し | E-01 (274-278行目) | ○ |
| C-11 | OP_VRenameが生成される | E-01 (277行目) | ○ |
| C-12 | sqlite_rename_table()でSQL文更新 | E-01 (216-222行目) | ○ |
| C-13 | sqlite_sequence更新はAUTOINCREMENT時のみ | E-01 (246-250行目) | ○ |
| C-14 | renameReloadSchema()でスキーマリロード | E-01 (281行目), E-06 | ○ |
| C-15 | renameTestSchema()でスキーマ検証 | E-01 (282行目), E-05 | ○ |
| C-16 | PRIMARY KEY列は追加不可 | E-02 (354-357行目) | ○ |
| C-17 | UNIQUE列は追加不可 | E-02 (358-362行目) | ○ |
| C-18 | NOT NULL列はデフォルト値必須 | E-02 (377-380行目) | ○ |
| C-19 | REFERENCES列はデフォルト値NULL必須 | E-02 (373-376行目) | ○ |
| C-20 | デフォルト値は定数式のみ | E-02 (386-400行目) | ○ |
| C-21 | sqlite3ValueFromExpr()で定数評価 | E-02 (389行目) | ○ |
| C-22 | STORED列は追加不可 | E-02 (401-403行目) | ○ |
| C-23 | 仮想テーブルはADD COLUMN不可 | E-03 (499-500行目) | ○ |
| C-24 | pragma_quick_checkで制約検証 | E-02 (451-463行目) | ○ |
| C-25 | スキーマファイルフォーマット3以上に更新 | E-02 (430-441行目) | ○ |
| C-26 | 機能No.14として定義 | E-08 | ○ |
| C-27 | DROP COLUMN処理の詳細 | **根拠なし** | △ |
| C-28 | RENAME COLUMN処理の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- DROP COLUMN処理の詳細実装
  - 候補：alter.c内のsqlite3AlterDropColumn()関数
- RENAME COLUMN処理の詳細実装
  - 候補：alter.c内のsqlite3AlterRenameColumn()関数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - RENAME TO、ADD COLUMNの基本動作（コードから確認済み）
- 1: 中リスク - DROP COLUMN、RENAME COLUMNの詳細（詳細解析未実施）
- 0: 低リスク - 制約検証ロジック（コードから確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] DROP COLUMN処理（sqlite3AlterDropColumn）の実装を確認
- [ ] RENAME COLUMN処理（sqlite3AlterRenameColumn）の実装を確認
- [ ] sqlite_rename_table() SQL関数の動作を確認
- [ ] 仮想テーブルのxRename()呼び出しタイミングを検証
- [ ] CHECK制約違反時のエラーメッセージを実機確認
