---
generated_at: 2026-01-21 10:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：16-WHERE句最適化

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **wherePathSolver()の動的計画法アルゴリズム**：詳細解析が必要
  2. **コスト計算式の詳細**：具体的な計算式の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/where.c` 1-18行目 ファイルヘッダーコメント
- E-02: `src/where.c` 54-56行目 sqlite3WhereOutputRowCount()
- E-03: `src/where.c` 62-64行目 sqlite3WhereIsDistinct()
- E-04: `src/where.c` 74-76行目 sqlite3WhereIsOrdered()
- E-05: `src/where.c` 245-259行目 sqlite3WhereGetMask()
- E-06: `src/whereInt.h` 構造体定義（WhereInfo, WhereClause, WhereTerm, WhereLoop）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.16の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WHERE句最適化はwhere.cで実装 | E-01 | ○ |
| C-02 | クエリオプティマイザとしても機能 | E-01 (17行目) | ○ |
| C-03 | WhereInfo構造体が最適化情報を保持 | E-06 | ○ |
| C-04 | nRowOutで推定出力行数を返却 | E-02 | ○ |
| C-05 | eDistinctでDISTINCT処理方法を返却 | E-03 | ○ |
| C-06 | nOBSatでORDER BY充足項数を返却 | E-04 | ○ |
| C-07 | WhereClauseがWHERE句の項を保持 | E-06 | ○ |
| C-08 | WhereTermが個々の条件項を表現 | E-06 | ○ |
| C-09 | WhereLoopがアクセス方法を表現 | E-06 | ○ |
| C-10 | テーブルマスクはビット割り当て | E-05 | ○ |
| C-11 | HiddenIndexInfo構造体が仮想テーブル情報を保持 | E-01 (31-41行目) | ○ |
| C-12 | LogEstで対数スケール行数を表現 | E-02 | ○ |
| C-13 | sqlite3WhereMalloc()で専用メモリ管理 | E-01 (263行目) | ○ |
| C-14 | sqlite3WhereRealloc()でメモリ再割り当て | E-01 (274行目) | ○ |
| C-15 | whereOrInsert()でOR条件最適化 | E-01 (208行目) | ○ |
| C-16 | 機能No.16として定義 | E-07 | ○ |
| C-17 | where.c, whereexpr.c, wherecode.cの3ファイル構成 | E-07（備考欄） | ○ |
| C-18 | sqlite_stat1から統計情報を取得 | E-07（説明） | ○ |
| C-19 | wherePathSolver()が動的計画法で最適化 | **根拠なし** | △ |
| C-20 | コスト見積もり計算式の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- wherePathSolver()の詳細アルゴリズム
  - 候補：where.c内の関数実装を詳細解析
- コスト計算の具体的な計算式
  - 候補：whereLoopAddBtree()等のコスト設定部分

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造の説明（コードから確認済み）
- 1: 中リスク - 最適化アルゴリズムの詳細（詳細解析未実施）
- 1: 中リスク - コスト計算式（詳細解析未実施）

## 6) レビュアーチェックリスト（最小）
- [ ] sqlite3WhereBegin()の完全な処理フローを確認
- [ ] wherePathSolver()のアルゴリズムを確認
- [ ] コスト計算ロジック（whereLoopAddBtreeIndex等）を確認
- [ ] EXPLAIN QUERY PLANの出力と実装の対応を確認
