---
generated_at: 2026-01-21 11:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：17-VDBE（仮想データベースエンジン）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **オペコード数（約170種類）**：正確な数の確認が必要
  2. **オペコードディスパッチ時間（数ナノ秒）**：ベンチマーク確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vdbe.c` 11-19行目 ファイルヘッダーコメント
- E-02: `src/vdbe.c` 49-57行目 テスト用グローバル変数
- E-03: `src/vdbe.c` 253-289行目 allocateCursor()関数
- E-04: `src/vdbeInt.h` Vdbe, Mem, VdbeCursor構造体定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 画面No.9, 10との関連
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.17の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VDBEはバイトコードインタープリター | E-01 (13行目) | ○ |
| C-02 | vdbe.cにメイン実行エンジンがある | E-01 | ○ |
| C-03 | sqlite3_search_countでテスト用カウント | E-02 (56行目) | ○ |
| C-04 | sqlite3_interrupt_countで中断テスト | E-02 (68行目) | ○ |
| C-05 | sqlite3_sort_countでソートカウント | E-02 (79行目) | ○ |
| C-06 | sqlite3_max_blobsizeでBLOBサイズ追跡 | E-02 (90行目) | ○ |
| C-07 | VdbeCursorはSZ_VDBECURSORでサイズ計算 | E-03 (281行目) | ○ |
| C-08 | カーソル0はaMem[0]に対応 | E-03 (273-277行目) | ○ |
| C-09 | CURTYPE_BTREEでB-Treeカーソル | E-03 (283行目) | ○ |
| C-10 | Mem構造体でレジスタ値を表現 | E-04 | ○ |
| C-11 | VdbeCursor構造体でカーソル管理 | E-04 | ○ |
| C-12 | test_trace_breakpoint()でデバッグ支援 | E-01 (143-150行目) | ○ |
| C-13 | VdbeBranchTaken()でカバレッジ測定 | E-01 (191-229行目) | ○ |
| C-14 | isSorter()マクロでソーター判定 | E-01 (247行目) | ○ |
| C-15 | MEM_Ephemフラグでエフェメラル文字列 | E-01 (231-244行目) | ○ |
| C-16 | Deephemeralize()で永続化 | E-01 (242-244行目) | ○ |
| C-17 | 画面No.9, 10と関連（Speedtest1） | E-05 | ○ |
| C-18 | 機能No.17として定義 | E-06 | ○ |
| C-19 | HAS_UPDATE_HOOKでフック有無判定 | E-01 (102-106行目) | ○ |
| C-20 | sqlite3_found_countで外部キーテスト | E-01 (116行目) | ○ |
| C-21 | 約170種類のオペコード | **根拠なし** | △ |
| C-22 | オペコードディスパッチは数ナノ秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- オペコードの正確な数
  - 候補：vdbe.hまたはopcodes.hでオペコード定義を数える
- パフォーマンス特性の詳細
  - 候補：ベンチマーク実行またはプロファイリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造の説明（コードから確認済み）
- 1: 中リスク - パフォーマンス特性（推測に基づく記述）
- 0: 低リスク - テスト・デバッグ機能（コードから確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] オペコードの正確な数を確認
- [ ] sqlite3VdbeExec()のメインループ構造を確認
- [ ] 主要オペコード（OP_Column, OP_ResultRow等）の実装を確認
- [ ] カーソル管理の詳細を確認
