---
generated_at: 2026-01-21 11:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：18-VDBEソート処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **マルチスレッドソートの詳細動作**：ワーカースレッド実装の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vdbesort.c` 11-67行目 ファイルヘッダーとAPIコメント
- E-02: `src/vdbesort.c` 69-137行目 アルゴリズム説明コメント
- E-03: `src/vdbesort.c` 155行目 SQLITE_MAX_PMASZ定義
- E-04: `src/vdbesort.c` 160-167行目 構造体typedef
- E-05: `src/vdbesort.c` 173-176行目 SorterFile構造体
- E-06: `src/vdbesort.c` 186-190行目 SorterList構造体
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.18の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VdbeSorterはCREATE INDEX/ORDER BYで使用 | E-01 (13-15行目) | ○ |
| C-02 | マルチスレッド外部マージソートを実装 | E-01 (17-18行目) | ○ |
| C-03 | sqlite3VdbeSorterInit()で初期化 | E-01 (24行目) | ○ |
| C-04 | sqlite3VdbeSorterWrite()でレコード追加 | E-01 (26-32行目) | ○ |
| C-05 | sqlite3VdbeSorterRewind()でソート実行 | E-01 (34-36行目) | ○ |
| C-06 | sqlite3VdbeSorterNext()で次レコード | E-01 (38-40行目) | ○ |
| C-07 | sqlite3VdbeSorterRowkey()でデータ取得 | E-01 (41-43行目) | ○ |
| C-08 | sqlite3VdbeSorterCompare()でUNIQUEチェック | E-01 (45-49行目) | ○ |
| C-09 | sqlite3VdbeSorterClose()で終了 | E-01 (51-52行目) | ○ |
| C-10 | sqlite3VdbeSorterReset()でリセット | E-01 (54-56行目) | ○ |
| C-11 | PMA形式で一時ファイルに書き出し | E-02 (80行目) | ○ |
| C-12 | Level-0 PMAはメモリデータから生成 | E-02 (81-83行目) | ○ |
| C-13 | メモリ閾値はpage_size*cache_size | E-02 (86-89行目) | ○ |
| C-14 | SQLITE_MAX_WORKER_THREADSでマルチスレッド | E-02 (100-103行目) | ○ |
| C-15 | SORTER_MAX_MERGE_COUNTで増分マージ | E-02 (109-113行目) | ○ |
| C-16 | 階層的マージで大量PMA処理 | E-02 (124-129行目) | ○ |
| C-17 | SQLITE_MAX_PMAZは512MiB | E-03 | ○ |
| C-18 | SorterFile構造体でファイル管理 | E-05 | ○ |
| C-19 | 機能No.18として定義 | E-07 | ○ |
| C-20 | マルチスレッドソートの詳細動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- マルチスレッドソートの詳細実装（SortSubtask構造体、スレッド起動・同期）
  - 候補：vdbesort.c内のスレッド関連コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様（コメントから確認済み）
- 0: 低リスク - アルゴリズム概要（コメントから確認済み）
- 1: 中リスク - マルチスレッド実装詳細（詳細解析未実施）

## 6) レビュアーチェックリスト（最小）
- [ ] sqlite3VdbeSorterWrite()の実装詳細を確認
- [ ] PMAファイル形式の詳細を確認
- [ ] マルチスレッドソート（SortSubtask）の実装を確認
- [ ] PRAGMA threads設定の影響を検証
