---
generated_at: 2026-01-21 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：19-VDBEトレース

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **EXPLAIN出力との関連**：vdbetrace.c以外の実装確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vdbetrace.c` 11-17行目 ファイルヘッダーコメント
- E-02: `src/vdbetrace.c` 29-46行目 findNextHostParameter()関数
- E-03: `src/vdbetrace.c` 72-190行目 sqlite3VdbeExpandSql()関数
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.19の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | vdbetrace.cでホストパラメータ展開を実装 | E-01 (14-15行目) | ○ |
| C-02 | sqlite3_trace()で使用される | E-01 (14行目) | ○ |
| C-03 | findNextHostParameter()でパラメータ位置検出 | E-02 | ○ |
| C-04 | TK_VARIABLEトークンでパラメータ検出 | E-02 (38行目) | ○ |
| C-05 | sqlite3VdbeExpandSql()がメイン関数 | E-03 | ○ |
| C-06 | nVdbeExec > 1でコメント形式 | E-03 (90行目) | ○ |
| C-07 | p->nVar == 0でそのまま出力 | E-03 (98-99行目) | ○ |
| C-08 | ?パラメータは位置パラメータ | E-03 (108-114行目) | ○ |
| C-09 | :, $, @, #は名前付きパラメータ | E-03 (115-117行目) | ○ |
| C-10 | sqlite3VdbeParameterIndex()でインデックス取得 | E-03 (122行目) | ○ |
| C-11 | MEM_Nullは"NULL"出力 | E-03 (129-130行目) | ○ |
| C-12 | MEM_Int/IntRealは"%lld"出力 | E-03 (131-132行目) | ○ |
| C-13 | MEM_Realは"%!.15g"出力 | E-03 (133-134行目) | ○ |
| C-14 | MEM_Strは"'%.*q'"出力 | E-03 (135, 157行目) | ○ |
| C-15 | MEM_Zeroは"zeroblob(%d)"出力 | E-03 (166-167行目) | ○ |
| C-16 | MEM_Blobは"x'%02x'"形式 | E-03 (168-179行目) | ○ |
| C-17 | 機能No.19として定義 | E-04 | ○ |
| C-18 | EXPLAIN出力の生成に使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- EXPLAIN出力との関連
  - 候補：vdbe.c または explain.c でのEXPLAIN実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パラメータ展開処理（コードから確認済み）
- 0: 低リスク - 各型の出力形式（コードから確認済み）
- 1: 中リスク - EXPLAIN関連（詳細解析未実施）

## 6) レビュアーチェックリスト（最小）
- [ ] SQLITE_TRACE_SIZE_LIMITの動作を確認
- [ ] UTF-16変換処理を確認
- [ ] EXPLAIN出力との関連を確認
- [ ] sqlite3_trace_v2()からの呼び出しパスを確認
