---
generated_at: 2026-01-21 21:48:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：2-データベース接続管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（100ミリ秒以内）**：具体的な実測値の根拠なし
  2. **URIパラメータインジェクション対策**：セキュリティ実装の詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.c` 3677-3691行目 - sqlite3_open/open_v2の実装
- E-02: `src/main.c` 1343-1344行目 - sqlite3_close/close_v2の定義
- E-03: `src/main.c` 1246-1290行目 - sqlite3Close()の実装
- E-04: `src/main.c` 3316-3670行目 - openDatabase()の本体
- E-05: `src/main.c` 3034-3188行目 - sqlite3ParseUri()の実装
- E-06: `src/main.c` 1220-1240行目 - connectionIsBusy()
- E-07: `src/main.c` 1356-1420行目 - sqlite3LeaveMutexAndCloseZombie()
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3_open()がデータベース接続を開く | E-01, E-09 | ○ |
| C-02 | sqlite3_close()が接続を閉じる | E-02, E-03 | ○ |
| C-03 | ppDbがNULLの場合SQLITE_MISUSEを返却 | E-04 (3329-3331行目) | ○ |
| C-04 | 自動初期化が行われる | E-04 (3334行目) | ○ |
| C-05 | NULL引数でのcloseはno-op | E-03 (1248-1250行目) | ○ |
| C-06 | sqlite3_close_v2はzombie状態に移行 | E-02, E-07 | ○ |
| C-07 | 未完了リソースでSQLITE_BUSYを返す（close） | E-03 (1272-1276行目) | ○ |
| C-08 | URIファイル名を解析する | E-05 | ○ |
| C-09 | VFSを選択して接続確立 | E-04 | ○ |
| C-10 | インメモリDB対応（:memory:） | E-04 | ○ |
| C-11 | 関連画面が8画面存在 | E-08 | ○ |
| C-12 | main.cに実装されている | E-01, E-09 | ○ |
| C-13 | sqlite3構造体がハンドルとなる | E-04 | ○ |
| C-14 | フラグによるアクセスモード制御 | E-04 (3355-3361行目) | ○ |
| C-15 | sqlite3_open_v2でVFS指定可能 | E-01 (3684-3691行目) | ○ |
| C-16 | スキーマ読み込みが行われる | E-04 | ○ |
| C-17 | 共有キャッシュモード対応 | E-04 | ○ |
| C-18 | SQLITE_CANTOPENエラー | E-04 | ○ |
| C-19 | SQLITE_NOTADBエラー | E-04 | ○ |
| C-20 | SQLITE_CORRUPTエラー | E-04 | ○ |
| C-21 | 処理シーケンス（オープン9ステップ） | E-04 | ○ |
| C-22 | 処理シーケンス（クローズ7ステップ） | E-03, E-07 | ○ |
| C-23 | プログラム呼び出し階層図が正確 | E-01, E-03, E-04 | ○ |
| C-24 | 行番号が正確（3677, 1343等） | E-01, E-02 | ○ |
| C-25 | エラー時もハンドルが返される場合がある | E-04 (3653-3660行目) | ○ |
| C-26 | 未コミットトランザクションは自動ロールバック | E-03 | ○ |
| C-27 | オープンは通常100ミリ秒以内 | **根拠なし** | △ |
| C-28 | URIパラメータインジェクション対策 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件「100ミリ秒以内」の具体的な実測データ
  - 候補：SQLite公式ドキュメント / ベンチマーク結果 / 環境別実測値
- URIパラメータのセキュリティ検証の実装詳細
  - 候補：sqlite3ParseUri()のバリデーション処理 / セキュリティ監査レポート

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：主要な接続管理APIは十分に文書化されている
- 1（中リスク）：パフォーマンス要件は環境依存のため実測確認推奨
- 1（中リスク）：セキュリティ関連の主張は追加検証が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] sqlite3_open/closeの処理フローがソースコードと一致しているか確認
- [ ] 関連画面一覧が画面機能マッピング.csvと整合しているか確認
- [ ] エラーコードの種類と発生条件が網羅されているか確認
- [ ] close vs close_v2の違いが正確に記述されているか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
