---
generated_at: 2026-01-21 11:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：20-B-Treeストレージエンジン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **バランシングアルゴリズムの詳細**：balance()関数の詳細実装確認が必要
  2. **共有キャッシュのロック競合処理**：詳細な競合解決メカニズムの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/btree.c` 11-15行目 ファイルヘッダーコメント
- E-02: `src/btreeInt.h` 11-215行目 ファイルフォーマット詳細説明
- E-03: `src/btreeInt.h` 273-304行目 MemPage構造体
- E-04: `src/btreeInt.h` 345-363行目 Btree構造体
- E-05: `src/btreeInt.h` 425-460行目 BtShared構造体
- E-06: `src/btreeInt.h` 480-486行目 CellInfo構造体
- E-07: `src/btree.c` 2528-2649行目 sqlite3BtreeOpen()関数
- E-08: `src/btree.c` 2917-2974行目 sqlite3BtreeClose()関数
- E-09: `src/btree.c` 9394-9539行目 sqlite3BtreeInsert()関数
- E-10: `src/btree.c` 9826-9919行目 sqlite3BtreeDelete()関数
- E-11: `src/btree.c` 5676行目 sqlite3BtreeFirst()関数
- E-12: `src/btree.c` 5757行目 sqlite3BtreeLast()関数
- E-13: `src/btree.c` 6369行目 sqlite3BtreeNext()関数
- E-14: `src/btree.c` 6461行目 sqlite3BtreePrevious()関数
- E-15: `src/btree.h` 45-52行目 sqlite3BtreeOpen API定義
- E-16: `src/btree.h` 60-63行目 オープンフラグ定義
- E-17: `src/btree.h` 122-123行目 BTREE_INTKEY/BTREE_BLOBKEY定義
- E-18: `src/btreeInt.h` 375-377行目 TRANS_NONE/READ/WRITE定義
- E-19: `src/btreeInt.h` 320-322行目 READ_LOCK/WRITE_LOCK定義
- E-20: `src/btreeInt.h` 222行目 MX_CELL_SIZE計算式
- E-21: `src/btreeInt.h` 229行目 MX_CELL計算式
- E-22: `src/btreeInt.h` 497行目 BTCURSOR_MAX_DEPTH定義
- E-23: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.20の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | btree.cでディスクベースB-Treeを実装 | E-01 (12行目) | ○ |
| C-02 | ファイルフォーマットはbtreeInt.hに記載 | E-02 | ○ |
| C-03 | マジックヘッダー "SQLite format 3" | E-02 (58行目) | ○ |
| C-04 | ページサイズは512-65536（2のべき乗） | E-02 (49行目) | ○ |
| C-05 | ファイルヘッダーは100バイト | E-02 (53-54行目) | ○ |
| C-06 | MemPage構造体でページ情報を管理 | E-03 | ○ |
| C-07 | Btree構造体で接続ハンドルを表現 | E-04 | ○ |
| C-08 | BtShared構造体で共有情報を管理 | E-05 | ○ |
| C-09 | CellInfo構造体でセル情報を保持 | E-06 | ○ |
| C-10 | sqlite3BtreeOpen()でデータベースオープン | E-07 | ○ |
| C-11 | :memory:でインメモリDB作成 | E-07 (2552-2554行目) | ○ |
| C-12 | sqlite3BtreeClose()でデータベースクローズ | E-08 | ○ |
| C-13 | クローズ時にロールバック実行 | E-08 (2941行目) | ○ |
| C-14 | sqlite3BtreeInsert()でデータ挿入 | E-09 | ○ |
| C-15 | 挿入時にsaveAllCursors()で他カーソル保存 | E-09 (9424行目) | ○ |
| C-16 | btreeOverwriteCell()で上書き最適化 | E-09 (9490行目) | ○ |
| C-17 | sqlite3BtreeDelete()でデータ削除 | E-10 | ○ |
| C-18 | 削除時にsaveCursorKey()でキー保存 | E-10 (9894行目) | ○ |
| C-19 | sqlite3BtreeFirst/Last/Next/Previous | E-11, E-12, E-13, E-14 | ○ |
| C-20 | BTREE_OMIT_JOURNAL等のオープンフラグ | E-16 | ○ |
| C-21 | BTREE_INTKEY/BLOBKEYでテーブル/インデックス区別 | E-17 | ○ |
| C-22 | TRANS_NONE/READ/WRITEのトランザクション状態 | E-18 | ○ |
| C-23 | BTCURSOR_MAX_DEPTH=20 | E-22 | ○ |
| C-24 | バランシングアルゴリズムの詳細 | **根拠なし** | △ |
| C-25 | 共有キャッシュのロック競合詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- balance()関数群の詳細アルゴリズム
  - 候補：btree.c内のbalance_nonroot(), balance_deeper()の詳細解析
- 共有キャッシュのロック競合解決メカニズム
  - 候補：btree.c内のquerySharedCacheTableLock(), setSharedCacheTableLock()

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造の説明（コードから確認済み）
- 0: 低リスク - 主要API（関数シグネチャから確認済み）
- 0: 低リスク - ファイルフォーマット（詳細コメントから確認済み）
- 1: 中リスク - バランシングアルゴリズム（概要のみ、詳細未確認）
- 1: 中リスク - 共有キャッシュロック（概要のみ、詳細未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] balance_nonroot()の実装詳細を確認
- [ ] balance_deeper()の実装詳細を確認
- [ ] ページ分割のトリガー条件を確認
- [ ] 共有キャッシュのロック取得順序を確認
- [ ] オーバーフローページ管理の詳細を確認
- [ ] フリーリスト管理の詳細を確認
