---
generated_at: 2026-01-21 22:10:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：23-WAL機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **wal_autocheckpointデフォルト値1000**：公式ドキュメント照合推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `src/wal.c` 16-27行目（WALファイルフォーマット概要）
- E-02: `src/wal.c` 34-45行目（WALヘッダ構造）
- E-03: `src/wal.c` 47-58行目（フレームヘッダ構造）
- E-04: `src/wal.c` 59-68行目（フレーム有効性条件）
- E-05: `src/wal.c` 77-82行目（チェックサムアルゴリズム）
- E-06: `src/wal.c` 100-118行目（リーダーアルゴリズム）
- E-07: `src/wal.c` 127-146行目（WALインデックス概要）
- E-08: `src/wal.c` 166-177行目（ハッシュテーブル概要）
- E-09: `src/wal.c` 204-207行目（ハッシュ計算式）
- E-10: `src/wal.c` 277-278行目（バージョン定数）
- E-11: `src/wal.c` 294-299行目（ロックインデックス定数）
- E-12: `src/wal.c` 321-333行目（WalIndexHdr構造体）
- E-13: `src/wal.c` 394-400行目（WalCkptInfo構造体）
- E-14: `src/wal.c` 404-466行目（wal-indexヘッダ図解）
- E-15: `src/wal.c` 477-480行目（WAL定数：HDRSIZE, FRAME_HDRSIZE）
- E-16: `src/wal.c` 491行目（WALマジックナンバー）
- E-17: `src/wal.c` 498-500行目（walFrameOffsetマクロ）
- E-18: `src/wal.c` 511-554行目（Wal構造体）
- E-19: `src/wal.c` 559-561行目（exclusiveMode定数）
- E-20: `src/wal.c` 566-568行目（readOnly定数）
- E-21: `src/wal.c` 591-601行目（WalIterator構造体）
- E-22: `src/wal.c` 615-617行目（HASHTABLE定数）
- E-23: `src/wal.c` 624行目（HASHTABLE_NPAGE_ONE）
- E-24: `src/wal.c` 627-629行目（WALINDEX_PGSZ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WALファイルはヘッダ+フレーム列で構成 | E-01, E-02 | ○ |
| C-02 | WALヘッダ32バイト | E-15 | ○ |
| C-03 | フレームヘッダ24バイト | E-15 | ○ |
| C-04 | マジックナンバー0x377f0682/0x377f0683 | E-02, E-16 | ○ |
| C-05 | バージョン3007000 | E-10 | ○ |
| C-06 | チェックサムアルゴリズム（フィボナッチ重み付き） | E-05 | ○ |
| C-07 | walFrameOffsetマクロの計算式 | E-17 | ○ |
| C-08 | WalIndexHdr構造体のフィールド | E-12 | ○ |
| C-09 | WalCkptInfo構造体のフィールド | E-13 | ○ |
| C-10 | Wal構造体のフィールド | E-18 | ○ |
| C-11 | WAL_WRITE_LOCK/CKPT_LOCK/READ_LOCK定数 | E-11 | ○ |
| C-12 | WAL_NREADER計算式 | E-11 (299行目) | ○ |
| C-13 | HASHTABLE_NPAGE=4096 | E-22 | ○ |
| C-14 | HASHTABLE_HASH_1=383 | E-22 | ○ |
| C-15 | HASHTABLE_NSLOT=8192 | E-22 | ○ |
| C-16 | HASHTABLE_NPAGE_ONE=4062 | E-23 | ○ |
| C-17 | ハッシュ計算 iKey=(P*383)%NSLOT | E-09 | ○ |
| C-18 | リーダーはmxFrameを記録してスナップショット読み取り | E-06 | ○ |
| C-19 | チェックポイント時のソルト更新 | E-01 (95-98行目) | ○ |
| C-20 | WalIterator構造体 | E-21 | ○ |
| C-21 | exclusiveMode定数（NORMAL/EXCLUSIVE/HEAPMEMORY） | E-19 | ○ |
| C-22 | readOnly定数（RDWR/RDONLY/SHM_RDONLY） | E-20 | ○ |
| C-23 | WALINDEX_PGSZ計算式 | E-24 | ○ |
| C-24 | フレーム有効性条件（salt一致+checksum一致） | E-04 | ○ |
| C-25 | WAL-INDEXヘッダ136バイト | E-14 | ○ |
| C-26 | wal_autocheckpointデフォルト1000ページ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- wal_autocheckpointデフォルト値の公式根拠
  - 候補：`src/main.c` / `SQLITE_DEFAULT_WAL_AUTOCHECKPOINT`マクロ / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイルフォーマット定義は正確
- 0: 低リスク - ハッシュテーブル定数は正確
- 0: 低リスク - 構造体定義は正確
- 1: 中リスク - デフォルト値は公式ドキュメント参照推奨

## 6) レビュアーチェックリスト（最小）
- [ ] WALヘッダ図解（404-466行目）と設計書の記述が一致するか
- [ ] チェックサムアルゴリズムの記述が77-82行目と一致するか
- [ ] ハッシュテーブル定数（615-617行目）と一致するか
- [ ] wal_autocheckpointデフォルト値を公式ドキュメントで確認
