---
generated_at: 2026-01-21 22:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：25-ATTACH/DETACH機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **SQLITE_MAX_ATTACHEDデフォルト値10**：公式ドキュメント照合推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `src/attach.c` 12-13行目（ファイル概要コメント）
- E-02: `src/attach.c` 16行目（SQLITE_OMIT_ATTACHプリプロセッサ）
- E-03: `src/attach.c` 35-46行目（resolveAttachExpr関数）
- E-04: `src/attach.c` 52-57行目（sqlite3DbIsNamed関数）
- E-05: `src/attach.c` 59-68行目（attachFuncコメント）
- E-06: `src/attach.c` 74-274行目（attachFunc関数）
- E-07: `src/attach.c` 137-142行目（最大接続数チェック）
- E-08: `src/attach.c` 143-149行目（名前重複チェック）
- E-09: `src/attach.c` 154-164行目（aDb配列拡張）
- E-10: `src/attach.c` 178-183行目（AttachWrite/AttachCreateフラグ）
- E-11: `src/attach.c` 186行目（sqlite3BtreeOpen呼び出し）
- E-12: `src/attach.c` 196-203行目（スキーマ取得とエンコーディングチェック）
- E-13: `src/attach.c` 238行目（sqlite3Init呼び出し）
- E-14: `src/attach.c` 284行目以降（detachFunc関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ATTACHはSQL関数sqlite_attachとして実装 | E-05 | ○ |
| C-02 | DETACHはSQL関数sqlite_detachとして実装 | E-14 (283-284行目コメント) | ○ |
| C-03 | 最大接続数チェック（SQLITE_LIMIT_ATTACHED+2） | E-07 | ○ |
| C-04 | 名前重複チェック | E-08 | ○ |
| C-05 | aDb配列の動的拡張 | E-09 | ○ |
| C-06 | SQLITE_AttachWriteフラグによる読み取り専用制限 | E-10 | ○ |
| C-07 | SQLITE_AttachCreateフラグによる作成禁止 | E-10 | ○ |
| C-08 | sqlite3BtreeOpenによるファイルオープン | E-11 | ○ |
| C-09 | エンコーディング一致チェック | E-12 | ○ |
| C-10 | sqlite3Initによるスキーマ初期化 | E-13 | ○ |
| C-11 | resolveAttachExprで単純識別子を文字列化 | E-03 | ○ |
| C-12 | sqlite3DbIsNamedで"main"も照合 | E-04 | ○ |
| C-13 | REOPEN_AS_MEMDBによるメモリDB再オープン | E-06 (104-127行目) | ○ |
| C-14 | safety_level初期化 | E-06 (215行目) | ○ |
| C-15 | main/tempはDETACH不可 | E-14推定 | ○ |
| C-16 | SQLITE_OMIT_ATTACHコンパイルオプション | E-02 | ○ |
| C-17 | トランザクション中はATTACH不可 | E-06推定（エラーハンドリング） | ○ |
| C-18 | デフォルト最大接続数10 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SQLITE_MAX_ATTACHEDデフォルト値の公式根拠
  - 候補：`src/sqlite3.h` / `SQLITE_MAX_ATTACHED`マクロ / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - attachFunc処理フローは正確
- 0: 低リスク - フラグチェックロジックは正確
- 1: 中リスク - デフォルト値は公式ドキュメント参照推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 最大接続数チェック（137-142行目）のロジックが正確か
- [ ] SQLITE_AttachWrite/AttachCreateフラグの処理（178-183行目）が正確か
- [ ] エンコーディングチェック（199-203行目）が正確か
- [ ] SQLITE_MAX_ATTACHEDデフォルト値を公式ドキュメントで確認
