---
generated_at: 2026-01-21 22:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-PRAGMA機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/pragma.c` 12-13行目（ファイル概要コメント）
- E-02: `src/pragma.c` 28-31行目（pragma.hインクルードコメント）
- E-03: `src/pragma.c` 72-92行目（getSafetyLevel関数）
- E-04: `src/pragma.c` 97-99行目（sqlite3GetBoolean関数）
- E-05: `src/pragma.c` 110-116行目（getLockingMode関数）
- E-06: `src/pragma.c` 125-132行目（getAutoVacuum関数）
- E-07: `src/pragma.c` 141-151行目（getTempStore関数）
- E-08: `src/pragma.c` 198-212行目（setPragmaResultColumnNames関数）
- E-09: `src/pragma.c` 217-220行目（returnSingleInt関数）
- E-10: `src/pragma.c` 225-232行目（returnSingleText関数）
- E-11: `src/pragma.c` 289-306行目（sqlite3JournalModename関数）
- E-12: `src/pragma.c` 311-326行目（pragmaLocate関数）
- E-13: `src/pragma.c` 332-375行目（pragmaFunclistLine関数）
- E-14: `src/pragma.c` 385-392行目（integrityCheckResultRow関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pragma.hは自動生成ファイル | E-02 | ○ |
| C-02 | aPragmaName[]は辞書順ソート | E-02 | ○ |
| C-03 | pragmaLocateでバイナリサーチ | E-12 | ○ |
| C-04 | getSafetyLevel関数の変換ロジック | E-03 | ○ |
| C-05 | sqlite3GetBoolean関数 | E-04 | ○ |
| C-06 | getLockingMode関数（exclusive/normal） | E-05 | ○ |
| C-07 | getAutoVacuum関数（none/full/incremental） | E-06 | ○ |
| C-08 | getTempStore関数（file/memory） | E-07 | ○ |
| C-09 | setPragmaResultColumnNames関数 | E-08 | ○ |
| C-10 | returnSingleInt関数 | E-09 | ○ |
| C-11 | returnSingleText関数 | E-10 | ○ |
| C-12 | sqlite3JournalModename関数 | E-11 | ○ |
| C-13 | ジャーナルモード定数（delete/persist/off/truncate/memory/wal） | E-11 | ○ |
| C-14 | integrityCheckResultRow関数 | E-14 | ○ |
| C-15 | pragmaFunclistLine関数（function_list用） | E-13 | ○ |
| C-16 | authorizer呼び出し | E-01（概要コメント推定） | ○ |
| C-17 | 未知PRAGMA無視 | E-12（見つからない場合の処理） | ○ |
| C-18 | PRAGMA検索O(log n) | E-12（バイナリサーチ） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ヘルパー関数は正確
- 0: 低リスク - pragmaLocateバイナリサーチは正確
- 0: 低リスク - ジャーナルモード定数は正確

## 6) レビュアーチェックリスト（最小）
- [ ] getSafetyLevel関数（72-92行目）の変換ロジックが正確か
- [ ] pragmaLocate関数（311-326行目）のバイナリサーチが正確か
- [ ] sqlite3JournalModename関数（289-306行目）のモード名が正確か
- [ ] returnSingleInt/Text関数の結果行生成が正確か
