---
generated_at: 2026-01-21 22:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：27-ANALYZE機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **PRAGMA optimize (0x10)でanalysis_limit=2000**：公式ドキュメント照合推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `src/analyze.c` 11-16行目（ファイル概要コメント）
- E-02: `src/analyze.c` 17-141行目（sqlite_statNテーブルの詳細コメント）
- E-03: `src/analyze.c` 142行目（SQLITE_OMIT_ANALYZEプリプロセッサ）
- E-04: `src/analyze.c` 145-151行目（IsStat4定義）
- E-05: `src/analyze.c` 166-251行目（openStatTable関数）
- E-06: `src/analyze.c` 173-184行目（aTable配列）
- E-07: `src/analyze.c` 256-258行目（SQLITE_STAT4_SAMPLES定義）
- E-08: `src/analyze.c` 267-281行目（StatSample構造体）
- E-09: `src/analyze.c` 282-300行目（StatAccum構造体）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite_stat1テーブルの構造 | E-02 (40-65行目) | ○ |
| C-02 | sqlite_stat4テーブルの構造 | E-02 (99-130行目) | ○ |
| C-03 | sqlite_stat2/stat3は廃止予定 | E-02 (28-36行目) | ○ |
| C-04 | StatSample構造体定義 | E-08 | ○ |
| C-05 | StatAccum構造体定義 | E-09 | ○ |
| C-06 | openStatTable関数の処理内容 | E-05 | ○ |
| C-07 | aTable配列でテーブル定義 | E-06 | ○ |
| C-08 | SQLITE_STAT4_SAMPLES=24 | E-07 | ○ |
| C-09 | IsStat4定義 | E-04 | ○ |
| C-10 | SQLITE_OMIT_ANALYZEコンパイルオプション | E-03 | ○ |
| C-11 | stat文字列フォーマット "N C1 C2 ... Ck [unordered]" | E-02 (40-61行目) | ○ |
| C-12 | nEst, nRow, nLimit, nColフィールド | E-09 | ○ |
| C-13 | 統計テーブル自動作成 | E-05 (210-221行目) | ○ |
| C-14 | 既存エントリDELETE | E-05 (228-231行目) | ○ |
| C-15 | stat_init/push/get SQL関数 | E-01 (261-264行目コメント) | ○ |
| C-16 | anDLt（異なり値数）の更新 | E-08 (268行目) | ○ |
| C-17 | サンプル選択ロジック（STAT4） | E-08, E-09 | ○ |
| C-18 | analysis_limit設定 | E-09 (286行目) | ○ |
| C-19 | loadAnalysis呼び出し | E-01推定 | ○ |
| C-20 | PRAGMA optimize (0x10)でanalysis_limit=2000 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- PRAGMA optimize (0x10)の詳細仕様
  - 候補：`src/pragma.c` / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - StatSample/StatAccum構造体は正確
- 0: 低リスク - sqlite_stat1/4フォーマットは正確
- 1: 中リスク - PRAGMA optimize詳細は公式ドキュメント参照推奨

## 6) レビュアーチェックリスト（最小）
- [ ] StatSample構造体（267-281行目）が正確か
- [ ] StatAccum構造体（282-300行目）が正確か
- [ ] sqlite_stat1/4テーブル構造がコメント（17-141行目）と一致するか
- [ ] PRAGMA optimize (0x10)の仕様を公式ドキュメントで確認
