---
generated_at: 2026-01-21 22:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-組み込みSQL関数機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/func.c` 11-15行目（ファイル概要コメント）
- E-02: `src/func.c` 27-34行目（sqlite3GetFuncCollSeq関数）
- E-03: `src/func.c` 40-44行目（sqlite3SkipAccumulatorLoad関数）
- E-04: `src/func.c` 49-74行目（minmaxFunc関数）
- E-05: `src/func.c` 79-98行目（typeofFunc関数）
- E-06: `src/func.c` 104-111行目（subtypeFunc関数）
- E-07: `src/func.c` 116-150行目（lengthFunc関数）
- E-08: `src/func.c` 155-186行目（bytelengthFunc関数）
- E-09: `src/func.c` 194-230行目（absFunc関数）
- E-10: `src/func.c` 243-306行目（instrFunc関数）
- E-11: `src/func.c` 311-333行目（printfFunc関数）
- E-12: `src/func.c` 347-400行目以降（substrFunc関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 日付・時刻関数は別ファイル | E-01 | ○ |
| C-02 | sqlite3GetFuncCollSeq関数 | E-02 | ○ |
| C-03 | sqlite3SkipAccumulatorLoad関数 | E-03 | ○ |
| C-04 | minmaxFunc実装 | E-04 | ○ |
| C-05 | typeofFunc実装（integer/real/text/blob/null） | E-05 | ○ |
| C-06 | subtypeFunc実装 | E-06 | ○ |
| C-07 | lengthFunc実装（TEXT=文字数、BLOB=バイト数） | E-07 | ○ |
| C-08 | bytelengthFunc実装（octet_length） | E-08 | ○ |
| C-09 | absFunc実装とオーバーフローチェック | E-09 | ○ |
| C-10 | SMALLEST_INT64のオーバーフローエラー | E-09 (201-206行目) | ○ |
| C-11 | instrFunc実装（BLOB/TEXT両対応） | E-10 | ○ |
| C-12 | UTF-8マルチバイト考慮 | E-07 (136-140行目), E-10 (291-294行目) | ○ |
| C-13 | printfFunc実装 | E-11 | ○ |
| C-14 | PrintfArguments構造体使用 | E-11 (316-325行目) | ○ |
| C-15 | substrFunc実装 | E-12 | ○ |
| C-16 | NULL伝播ルール | E-04 (65-67行目), E-07 (145-147行目) | ○ |
| C-17 | sqlite3_result_*による結果返却 | E-05 (97行目), E-07 (127,142行目) | ○ |
| C-18 | 型判定にsqlite3_value_type使用 | E-05 (85行目), E-07 (123行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 関数実装は正確
- 0: 低リスク - オーバーフローチェックは正確
- 0: 低リスク - UTF-8処理は正確

## 6) レビュアーチェックリスト（最小）
- [ ] typeofFunc（79-98行目）の型文字列が正確か
- [ ] lengthFunc（116-150行目）のUTF-8処理が正確か
- [ ] absFunc（194-230行目）のオーバーフローチェックが正確か
- [ ] instrFunc（243-306行目）のBLOB/TEXT両対応が正確か
