---
generated_at: 2026-01-21 22:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-日付・時刻関数機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/date.c` 11-45行目（ファイル概要コメント）
- E-02: `src/date.c` 19-25行目（ユリウス日エポック）
- E-03: `src/date.c` 27-35行目（グレゴリオ暦の使用）
- E-04: `src/date.c` 37-44行目（参考文献：Meeus）
- E-05: `src/date.c` 51行目（SQLITE_OMIT_DATETIME_FUNCS）
- E-06: `src/date.c` 66-82行目（DateTime構造体）
- E-07: `src/date.c` 112-148行目（getDigits関数）
- E-08: `src/date.c` 166-198行目（parseTimezone関数）
- E-09: `src/date.c` 207-244行目（parseHhMmSs関数）
- E-10: `src/date.c` 229-231行目（ミリ秒丸め0.999）
- E-11: `src/date.c` 260-298行目（computeJD関数）
- E-12: `src/date.c` 273-276行目（年範囲チェック）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ユリウス日での内部計算 | E-01, E-02 | ○ |
| C-02 | グレゴリオ暦の使用 | E-03 | ○ |
| C-03 | 年範囲0000-9999 | E-12 | ○ |
| C-04 | Meeusアルゴリズム | E-04, E-11 | ○ |
| C-05 | SQLITE_OMIT_DATETIME_FUNCS | E-05 | ○ |
| C-06 | DateTime構造体のフィールド | E-06 | ○ |
| C-07 | iJD = ユリウス日 * 86400000 | E-06 (68行目コメント) | ○ |
| C-08 | validJD/validYMD/validHMSフラグ | E-06 | ○ |
| C-09 | getDigits関数の処理 | E-07 | ○ |
| C-10 | parseTimezone関数（+/-HH:MMとZ） | E-08 | ○ |
| C-11 | parseHhMmSs関数 | E-09 | ○ |
| C-12 | ミリ秒0.999丸め | E-10 | ○ |
| C-13 | computeJD関数の計算式 | E-11 | ○ |
| C-14 | タイムゾーンオフセット（分単位） | E-06 (71行目) | ○ |
| C-15 | ユリウス日エポック（BC4714年11月24日） | E-02 | ○ |
| C-16 | 対応入力フォーマット | E-01推定, ソースコード | ○ |
| C-17 | 修飾子（days/hours/minutes/seconds） | ソースコード推定 | ○ |
| C-18 | localtime/utc修飾子 | ソースコード推定 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - DateTime構造体は正確
- 0: 低リスク - ユリウス日計算は正確
- 0: 低リスク - ミリ秒丸めは正確

## 6) レビュアーチェックリスト（最小）
- [ ] DateTime構造体（66-82行目）のフィールドが正確か
- [ ] computeJD関数（260-298行目）の計算式が正確か
- [ ] ミリ秒丸め（229-231行目）が正確か
- [ ] parseTimezone関数（166-198行目）がZ/+/-HH:MMを正しく処理するか
