---
generated_at: 2026-01-21 21:52:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-バージョン情報取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.c` 89-92行目 - sqlite3_version定数の定義
- E-02: `src/main.c` 95-98行目 - sqlite3_libversion()の実装
- E-03: `src/main.c` 100-106行目 - sqlite3_sourceid()の実装
- E-04: `src/main.c` 108-111行目 - sqlite3_libversion_number()の実装
- E-05: `src/sqlite3.h` - SQLITE_VERSION等マクロの定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3_versionがバージョン文字列を提供 | E-01 | ○ |
| C-02 | sqlite3_libversion()がsqlite3_versionへのポインタを返却 | E-02 | ○ |
| C-03 | sqlite3_libversion_number()が数値形式を返却 | E-04 | ○ |
| C-04 | sqlite3_sourceid()がソースIDを返却 | E-03 | ○ |
| C-05 | SQLITE_VERSIONマクロから値が来る | E-01, E-05 | ○ |
| C-06 | SQLITE_VERSION_NUMBERマクロから値が来る | E-04, E-05 | ○ |
| C-07 | SQLITE_SOURCE_IDマクロから値が来る | E-03, E-05 | ○ |
| C-08 | 全関数は引数を取らない | E-02, E-03, E-04 | ○ |
| C-09 | バージョン番号形式 X*1000000+Y*1000+Z | E-05（公式ドキュメント） | ○ |
| C-10 | ソースID形式がYYYY-MM-DD HH:MM:SS形式 | E-03 | ○ |
| C-11 | main.cに実装されている | E-01, E-07 | ○ |
| C-12 | エラーを発生させない | E-02, E-03, E-04（実装確認） | ○ |
| C-13 | 定数値を返却するのみ | E-02, E-03, E-04 | ○ |
| C-14 | 関連画面が4画面存在 | E-06 | ○ |
| C-15 | SQLITE_AMALGAMATION条件分岐 | E-01（88行目） | ○ |
| C-16 | コードリーディングガイドの行番号89-111 | E-01, E-02, E-03, E-04 | ○ |
| C-17 | プログラム呼び出し階層図が正確 | E-01, E-02, E-03, E-04 | ○ |
| C-18 | ヘッダー/ライブラリ整合性確認可能 | E-05 | ○ |
| C-19 | 実行中に値が変化しない | E-01（const定義） | ○ |
| C-20 | 関連ファイル一覧が正確 | E-01, E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に十分な根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：本機能は非常にシンプルで、ソースコードとの整合性が完全に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] バージョン番号の計算式が正しいか確認（X*1000000+Y*1000+Z）
- [ ] 関連画面一覧が画面機能マッピング.csvと整合しているか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
