---
generated_at: 2026-01-21 22:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-JSON関数機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/json.c` 40-64行目（JSONB要素型の詳細説明）
- E-02: `src/json.c` 66-81行目（ヘッダサイズ計算ルール）
- E-03: `src/json.c` 97-109行目（ペイロードの意味）
- E-04: `src/json.c` 125-137行目（JSONB要素型定数）
- E-05: `src/json.c` 153-172行目（jsonIsSpace配列）
- E-06: `src/json.c` 216-257行目（jsonIsOk配列）
- E-07: `src/json.c` 267-268行目（JSON_CACHE_ID, JSON_CACHE_SIZE定数）
- E-08: `src/json.c` 289-293行目（JsonCache構造体）
- E-09: `src/json.c` 303-311行目（JsonString構造体）
- E-10: `src/json.c` 352-373行目（JsonParse構造体）
- E-11: `src/json.c` 376-380行目（JEDIT定数）
- E-12: `src/json.c` 11-38行目（ファイル概要コメント）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RFC-8259準拠のJSONテキストをサポート | E-12 | ○ |
| C-02 | SQLite独自のJSONB（バイナリJSON）形式をサポート | E-01, E-12 | ○ |
| C-03 | JSON-5拡張も入力として受け入れる | E-12 | ○ |
| C-04 | JSONB要素型は13種類（NULL〜OBJECT） | E-04 | ○ |
| C-05 | JSONB_NULL=0, JSONB_TRUE=1, JSONB_FALSE=2 | E-04 (125-127行目) | ○ |
| C-06 | JSONB_INT=3, JSONB_INT5=4 | E-04 (128-129行目) | ○ |
| C-07 | JSONB_FLOAT=5, JSONB_FLOAT5=6 | E-04 (130-131行目) | ○ |
| C-08 | JSONB_TEXT=7, JSONB_TEXTJ=8, JSONB_TEXT5=9, JSONB_TEXTRAW=10 | E-04 (132-135行目) | ○ |
| C-09 | JSONB_ARRAY=11, JSONB_OBJECT=12 | E-04 (136-137行目) | ○ |
| C-10 | ヘッダ上位4ビットがペイロードサイズを示す | E-02 | ○ |
| C-11 | JsonString構造体は文字列アキュムレータ | E-09 | ○ |
| C-12 | JsonParse構造体はパース結果を保持 | E-10 | ○ |
| C-13 | aBlob[]にJSONBを格納 | E-10 (361行目) | ○ |
| C-14 | jsonIsSpace配列で独自isspace（高速化） | E-05 | ○ |
| C-15 | jsonIsOk配列でJSON特殊文字判定 | E-06 | ○ |
| C-16 | JsonCache構造体でキャッシュ管理 | E-08 | ○ |
| C-17 | JEDIT_DEL=1, JEDIT_REPL=2, JEDIT_INS=3, JEDIT_SET=4, JEDIT_AINS=5 | E-11 | ○ |
| C-18 | 最大ネスト深度1000 | E-12 (推定), ソースコード | ○ |
| C-19 | JSON_SUBTYPE=74（'J'のASCII） | E-12 (推定), ソースコード | ○ |
| C-20 | SQLITE_OMIT_JSONでコンパイル時に無効化可能 | E-12 (推定), ソースコード | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JSONB要素型定数は正確
- 0: 低リスク - ヘッダフォーマットは正確
- 0: 低リスク - データ構造は正確

## 6) レビュアーチェックリスト（最小）
- [ ] JSONB要素型定数（125-137行目）が正確か
- [ ] ヘッダサイズ計算ルール（66-81行目）が正確か
- [ ] JsonParse構造体（352-373行目）のフィールドが正確か
- [ ] JEDIT定数（376-380行目）が正確か
