---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：31-外部キー制約

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件のO(log n)記述**：定量的な性能データの根拠不足
  2. **セキュリティ考慮事項の権限管理**：具体的な実装詳細の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/fkey.c` 1-1486行目（外部キー制約のメイン実装）
- E-02: `src/fkey.c` 19-124行目（ファイル先頭のアーキテクチャコメント）
- E-03: `src/fkey.c` 889-1086行目（sqlite3FkCheck関数）
- E-04: `src/fkey.c` 320-460行目（fkLookupParent関数）
- E-05: `src/fkey.c` 547-660行目（fkScanChildren関数）
- E-06: `src/fkey.c` 1216-1410行目（fkActionTrigger関数）
- E-07: `src/fkey.c` 183-292行目（sqlite3FkLocateIndex関数）
- E-08: `src/fkey.c` 1088行目（COLUMN_MASKマクロ）
- E-09: 機能一覧.csv 31行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 外部キー制約はFOREIGN KEY制約の検証・CASCADE処理を実装 | E-01, E-09 | ○ |
| C-02 | 遅延制約（Deferred）と即座制約（Immediate）の2種類をサポート | E-02 (23-48行目) | ○ |
| C-03 | INSERT時に親テーブルの存在確認を行う（I.1操作） | E-02 (50-55行目), E-03 | ○ |
| C-04 | DELETE時に依存する子行をチェック（D.2操作） | E-02 (61-70行目), E-03 | ○ |
| C-05 | UPDATE時は影響カラムのみ検証 | E-02 (72-76行目), E-08 | ○ |
| C-06 | 制約カウンターで遅延制約を管理 | E-02 (31-48行目) | ○ |
| C-07 | PRAGMA foreign_keysで有効/無効を切り替え | E-03 (907行目) | ○ |
| C-08 | CASCADE/SET NULL/SET DEFAULT/RESTRICTアクションをサポート | E-06 | ○ |
| C-09 | アクションはトリガーとして実装 | E-06, E-02 (118-124行目) | ○ |
| C-10 | 親テーブルのUNIQUE/PRIMARY KEYインデックスを使用 | E-07 (229-231行目) | ○ |
| C-11 | FK列がNULLの場合は検証スキップ | E-04 (353-356行目) | ○ |
| C-12 | INTEGER PRIMARY KEYは特別扱い | E-04 (359-389行目) | ○ |
| C-13 | 自己参照テーブルの除外条件を処理 | E-05 (600-636行目) | ○ |
| C-14 | WHERE句を構築して子テーブルをスキャン | E-05 (575-598行目) | ○ |
| C-15 | OP_FkCounter/OP_FkIfZeroオペコードを使用 | E-04 (455行目), E-05 (649行目) | ○ |
| C-16 | sqlite3FkCheckがメインエントリーポイント | E-03 | ○ |
| C-17 | fkLookupParentで親行を検索 | E-04 | ○ |
| C-18 | fkScanChildrenで子行をスキャン | E-05 | ○ |
| C-19 | fkActionTriggerでアクショントリガーを構築 | E-06 | ○ |
| C-20 | sqlite3FkReferencesでpTabを参照するFKeyリスト取得 | E-01 (676-678行目) | ○ |
| C-21 | SQLITE_OMIT_FOREIGN_KEYで無効化可能 | E-01 (16行目) | ○ |
| C-22 | SQLITE_OMIT_TRIGGERでも無効化 | E-01 (17行目) | ○ |
| C-23 | SQLITE_CONSTRAINT_FOREIGNKEYエラーを返す | E-04 (449-450行目) | ○ |
| C-24 | foreign key mismatchエラーメッセージ | E-07 (282-284行目) | ○ |
| C-25 | sqlite3_set_authorizerで認可チェック | E-03 (976-985行目) | ○ |
| C-26 | SQLITE_IGNOREでNULL扱い | E-03 (984行目) | ○ |
| C-27 | パフォーマンスはO(log n)の計算量 | **根拠なし** | △ |
| C-28 | 権限管理の具体的な実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-27: パフォーマンスに関する記述はB-Treeインデックスの特性から推定されるが、fkey.c内に明示的な計算量の記述はない
  - 候補：btree.c / B-Tree実装のドキュメント / SQLiteパフォーマンスドキュメント
- C-28: 権限管理についてはsqlite3_set_authorizerの使用は確認できるが、「適切な権限管理が必要」という記述の具体的な実装根拠が不足
  - 候補：auth.c / SQLiteドキュメント / pragma.c

## 5) リスクフラグ（レビュー観点）
- 0: 機能の基本的な説明（Claim C-01〜C-06）：ソースコードのコメントと実装で十分に裏付け
- 0: API/関数の説明（Claim C-16〜C-20）：関数定義から直接確認可能
- 1: パフォーマンス要件（Claim C-27）：推定に基づく記述であり、実測データがない
- 1: セキュリティ考慮事項の一部（Claim C-28）：一般論に基づく記述

## 6) レビュアーチェックリスト（最小）
- [ ] fkey.cファイル先頭のアーキテクチャコメント（19-124行目）が設計書の記述と整合しているか
- [ ] CASCADE/SET NULL等のアクション実装がfkActionTrigger()の実装と一致しているか
- [ ] エラーコードSQLITE_CONSTRAINT_FOREIGNKEYの発生条件が正確か
- [ ] パフォーマンス要件の記述が適切か（必要に応じて削除または修正）
- [ ] セキュリティ考慮事項が組織のセキュリティ基準と整合しているか
