---
generated_at: 2026-01-21 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：32-認証認可

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件のプリペアドステートメント再利用推奨**：一般的なベストプラクティスだが明示的な根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/auth.c` 1-261行目（認可機能のメイン実装）
- E-02: `src/auth.c` 25-68行目（ファイル先頭のAPIコメント）
- E-03: `src/auth.c` 70-84行目（sqlite3_set_authorizer関数）
- E-04: `src/auth.c` 193-231行目（sqlite3AuthCheck関数）
- E-05: `src/auth.c` 104-125行目（sqlite3AuthReadCol関数）
- E-06: `src/auth.c` 136-185行目（sqlite3AuthRead関数）
- E-07: `src/auth.c` 238-258行目（AuthContextPush/Pop関数）
- E-08: 機能一覧.csv 32行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3_set_authorizer()でコールバック関数を登録 | E-02, E-03 | ○ |
| C-02 | コンパイル時に認可チェックを実行 | E-02 (28-30行目) | ○ |
| C-03 | SQLITE_OK/DENY/IGNOREの3つの戻り値をサポート | E-02 (60-65行目) | ○ |
| C-04 | SQLITE_DENYでコンパイルエラー | E-04 (223-225行目) | ○ |
| C-05 | SQLITE_IGNOREでカラム値をNULL化 | E-06 (182-184行目) | ○ |
| C-06 | 登録時に既存プリペアドステートメントを無効化 | E-03 (81行目) | ○ |
| C-07 | db->xAuthがNULLなら即座にSQLITE_OK | E-04 (207行目) | ○ |
| C-08 | データベース初期化中は認可チェックをスキップ | E-04 (207行目), E-05 (114行目) | ○ |
| C-09 | アクションコード（SQLITE_CREATE_TABLE等）を引数として渡す | E-02 (32-56行目) | ○ |
| C-10 | 第3-6引数はアクション依存 | E-02 (58-59行目) | ○ |
| C-11 | SQLITE_AUTHエラーコードを返す | E-05 (120行目), E-04 (225行目) | ○ |
| C-12 | "not authorized"エラーメッセージ | E-04 (224行目) | ○ |
| C-13 | "access to X.Y is prohibited"エラーメッセージ | E-05 (117-119行目) | ○ |
| C-14 | "authorizer malfunction"エラーメッセージ | E-01 (91行目) | ○ |
| C-15 | TK_COLUMNをTK_NULLに変換 | E-06 (183行目) | ○ |
| C-16 | AuthContextでトリガー認可コンテキスト管理 | E-07 | ○ |
| C-17 | pParse->zAuthContextでコンテキスト伝播 | E-07 (245-246行目) | ○ |
| C-18 | SQLITE_OMIT_AUTHORIZATIONで無効化可能 | E-01 (23行目) | ○ |
| C-19 | sqlite3_declare_vtab内では認可チェック無効 | E-04 (207行目, IN_SPECIAL_PARSE) | ○ |
| C-20 | コールバック不正戻り値でSQLITE_DENY扱い | E-04 (226-228行目) | ○ |
| C-21 | 認可コールバック設定でステートメント無効化 | E-03 (81行目) | ○ |
| C-22 | プリペアドステートメント再利用で認可チェック1回 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-22: プリペアドステートメントの再利用によるパフォーマンス最適化は一般的なベストプラクティスとして知られているが、auth.c内に明示的な言及はない
  - 候補：SQLiteドキュメント / prepare.c / パフォーマンスガイド

## 5) リスクフラグ（レビュー観点）
- 0: API仕様の説明（Claim C-01〜C-10）：ソースコードのコメントと実装で十分に裏付け
- 0: エラー処理（Claim C-11〜C-14）：エラーメッセージがソースコードから直接確認可能
- 0: 条件付き処理（Claim C-18〜C-21）：プリプロセッサ条件から確認可能
- 1: パフォーマンス要件（Claim C-22）：推定に基づく記述

## 6) レビュアーチェックリスト（最小）
- [ ] auth.cファイル先頭のAPIコメント（25-68行目）が設計書の記述と整合しているか
- [ ] アクションコード（SQLITE_CREATE_TABLE等）の網羅性が十分か
- [ ] SQLITE_IGNORE時のNULL変換動作が正確に記述されているか
- [ ] パフォーマンス要件の記述が適切か（必要に応じて修正）
