---
generated_at: 2026-01-21 10:40:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：33-仮想テーブル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **eponymous仮想テーブルの詳細仕様**：機能の存在は確認できるが詳細な仕様の根拠不足
  2. **シャドウテーブル保護機能の詳細**：機能の存在は確認できるが詳細な仕様の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vtab.c` 1-1420行目（仮想テーブルのメイン実装）
- E-02: `src/vtab.c` 9-90行目（ファイル先頭のコメント）
- E-03: `src/vtab.c` 1101-1166行目（sqlite3_create_module_v2関数）
- E-04: `src/vtab.c` 614-740行目（vtabCallConstructor関数）
- E-05: `src/vtab.c` 891-948行目（sqlite3VtabBestIndex関数）
- E-06: `src/sqlite3.h`（sqlite3_module構造体定義）
- E-07: 機能一覧.csv 33行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3_create_module()でモジュールを登録 | E-03 | ○ |
| C-02 | CREATE VIRTUAL TABLEでテーブルを定義 | E-04 (750-858行目) | ○ |
| C-03 | xBestIndexでクエリプラン最適化 | E-05 | ○ |
| C-04 | xFilter/xNext/xColumnでデータ取得 | E-02 (28-55行目) | ○ |
| C-05 | xUpdateでINSERT/UPDATE/DELETE | E-02 (56-80行目) | ○ |
| C-06 | sqlite3_module構造体の必須メソッド一覧 | E-06 | ○ |
| C-07 | sqlite3_declare_vtab()でスキーマ宣言 | E-04 (687行目), E-01 (981-1066行目) | ○ |
| C-08 | VDBEオペコード（OP_VOpen等）を使用 | E-02 (40-55行目) | ○ |
| C-09 | Module構造体をハッシュテーブルで管理 | E-03 (1132行目) | ○ |
| C-10 | estimatedCostでコスト見積もり | E-05 (910-930行目) | ○ |
| C-11 | idxNum/idxStrでインデックス識別 | E-05 | ○ |
| C-12 | トランザクション管理（xBegin/xSync等） | E-01 (1180-1270行目) | ○ |
| C-13 | セーブポイントサポート（xSavepoint等） | E-01 (1275-1348行目) | ○ |
| C-14 | SQLITE_OMIT_VIRTUALTABLEで無効化可能 | E-01 (20行目) | ○ |
| C-15 | sqlite_schemaへの登録 | E-04 (815-835行目) | ○ |
| C-16 | no such moduleエラー | E-01 (792行目) | ○ |
| C-17 | vtabCallConstructorでxCreate呼び出し | E-04 | ○ |
| C-18 | sqlite3VtabCallCreateで仮想テーブル作成 | E-01 (750-858行目) | ○ |
| C-19 | sqlite3VtabBestIndexでxBestIndex呼び出し | E-05 | ○ |
| C-20 | カーソル独立性 | E-02 (45-50行目) | ○ |
| C-21 | xBestIndexは副作用を持ってはならない | E-02 (35-38行目) | ○ |
| C-22 | sqlite3_vtab_config()でリスクレベル設定 | E-01 (1360-1415行目) | ○ |
| C-23 | SQLITE_VTAB_INNOCUOUSフラグ | E-01 (1377行目) | ○ |
| C-24 | whereLoopAddVirtualでクエリプラン統合 | E-01 (75-80行目コメント) | ○ |
| C-25 | eponymous仮想テーブルのサポート | **根拠不足** | △ |
| C-26 | シャドウテーブル保護機能 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: eponymous仮想テーブル（CREATE TABLE不要で同名でアクセス可能）の機能はSQLiteドキュメントに記載されているが、vtab.c内の具体的な実装箇所の特定が必要
  - 候補：SQLiteドキュメント / 実装コードの詳細調査
- C-26: シャドウテーブル保護機能はSQLite 3.26.0で追加された機能。vtab.c内のSQLITE_VTAB_DIRECTONLY等の関連コードの詳細調査が必要
  - 候補：リリースノート / 実装コードの詳細調査

## 5) リスクフラグ（レビュー観点）
- 0: 基本的なAPI仕様（Claim C-01〜C-08）：ソースコードとヘッダーで十分に裏付け
- 0: クエリプラン最適化（Claim C-10〜C-11）：sqlite3_index_info構造体から確認可能
- 0: トランザクション管理（Claim C-12〜C-13）：関数実装から確認可能
- 1: 高度な機能（Claim C-25〜C-26）：機能の存在は確認できるが詳細仕様の根拠不足

## 6) レビュアーチェックリスト（最小）
- [ ] sqlite3_module構造体の全メソッドが網羅されているか
- [ ] vtab.cファイル先頭のコメント（9-90行目）と設計書の整合性
- [ ] xBestIndexの入出力パラメータの正確性
- [ ] eponymous仮想テーブルの記述が正確か（必要に応じて修正）
- [ ] シャドウテーブル保護の記述が正確か（必要に応じて修正）
