---
generated_at: 2026-01-21 10:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-拡張モジュールローダー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/loadext.c` 1-944行目（拡張ローダーのメイン実装）
- E-02: `src/loadext.c` 133-534行目（sqlite3Apis構造体）
- E-03: `src/loadext.c` 556-725行目（sqlite3LoadExtension関数）
- E-04: `src/loadext.c` 726-738行目（sqlite3_load_extension関数）
- E-05: `src/loadext.c` 744-751行目（sqlite3CloseExtensions関数）
- E-06: `src/loadext.c` 757-769行目（sqlite3_enable_load_extension関数）
- E-07: `src/loadext.c` 806-845行目（sqlite3_auto_extension関数）
- E-08: `src/loadext.c` 856-879行目（sqlite3_cancel_auto_extension関数）
- E-09: `src/loadext.c` 884-899行目（sqlite3_reset_auto_extension関数）
- E-10: `src/loadext.c` 906-943行目（sqlite3AutoLoadExtensions関数）
- E-11: 機能一覧.csv 34行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3_enable_load_extension()で有効化 | E-06 | ○ |
| C-02 | デフォルトで拡張ロードは無効 | E-03 (594-599行目) | ○ |
| C-03 | sqlite3_load_extension()で共有ライブラリをロード | E-03, E-04 | ○ |
| C-04 | load_extension() SQL関数も提供 | E-01 (18行目コメント), func.c | ○ |
| C-05 | エントリーポイントは通常sqlite3_extension_init | E-03 (601行目) | ○ |
| C-06 | sqlite3Apis経由でAPIにアクセス | E-02, E-03 (688行目) | ○ |
| C-07 | sqlite3_auto_extension()で自動ロード登録 | E-07 | ○ |
| C-08 | SQLITE_OMIT_LOAD_EXTENSIONで無効化可能 | E-01 (22行目) | ○ |
| C-09 | パス長制限SQLITE_MAX_PATHLEN | E-03 (611行目) | ○ |
| C-10 | 空ファイル名はブロック | E-03 (615行目) | ○ |
| C-11 | 拡張子リトライ（.so/.dll/.dylib） | E-03 (574-582行目, 619-626行目) | ○ |
| C-12 | エントリーポイント名自動生成 | E-03 (648-671行目) | ○ |
| C-13 | "lib"プレフィックス除去 | E-03 (661行目) | ○ |
| C-14 | SQLITE_OK_LOAD_PERMANENTLYでアンロード不可 | E-03 (690行目) | ○ |
| C-15 | db->aExtension[]でハンドル管理 | E-03 (700-710行目) | ○ |
| C-16 | sqlite3CloseExtensions()で自動アンロード | E-05 | ○ |
| C-17 | sqlite3OsDlOpen()で動的ロード | E-03 (617行目) | ○ |
| C-18 | sqlite3OsDlSym()でシンボル検索 | E-03 (629行目, 669行目) | ○ |
| C-19 | sqlite3OsDlClose()でアンロード | E-05 (748行目) | ○ |
| C-20 | "not authorized"エラーメッセージ | E-03 (596行目) | ○ |
| C-21 | "no entry point"エラーメッセージ | E-03 (678-679行目) | ○ |
| C-22 | "unable to open shared library"エラー | E-03 (719-720行目) | ○ |
| C-23 | sqlite3_cancel_auto_extension()で登録解除 | E-08 | ○ |
| C-24 | sqlite3_reset_auto_extension()で全クリア | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がソースコードから直接確認可能
- 0: エラーメッセージもソースコードから直接引用

## 6) レビュアーチェックリスト（最小）
- [ ] sqlite3Apis構造体（133-534行目）のAPIバージョン互換性が最新であるか
- [ ] プラットフォーム別の拡張子（.so/.dll/.dylib）が正しく記載されているか
- [ ] セキュリティ考慮事項の記述が組織のセキュリティ基準と整合しているか
