---
generated_at: 2026-01-21 10:50:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：35-FTS3FTS4全文検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **automergeオプションの詳細仕様**：機能の存在は確認できるが詳細根拠不足
  2. **暗号化FTS拡張の存在**：外部拡張であり、ソースコード内での確認不可

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/fts3/fts3.c` 26-289行目（アーキテクチャコメント）
- E-02: `ext/fts3/fts3.c` 292行目以降（メイン実装）
- E-03: `ext/fts3/fts3_write.c`（インデックス書き込み）
- E-04: `ext/fts3/fts3_expr.c`（クエリパーサー）
- E-05: `ext/fts3/fts3_snippet.c`（補助関数）
- E-06: 機能一覧.csv 35行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FTS3/FTS4は転置インデックスを使用 | E-01 (26-31行目) | ○ |
| C-02 | CREATE VIRTUAL TABLE...USING fts3/fts4で作成 | E-01 (291-292行目) | ○ |
| C-03 | MATCH演算子でキーワード検索 | E-01, E-04 | ○ |
| C-04 | トークナイザーでテキストを分解 | E-01 (33-52行目) | ○ |
| C-05 | simpleトークナイザーがデフォルト | E-01 | ○ |
| C-06 | porterトークナイザーで英語ステミング | fts3_porter.c | ○ |
| C-07 | unicode61でUnicode正規化 | fts3_unicode.c | ○ |
| C-08 | varintエンコーディングを使用 | E-01 (34-52行目) | ○ |
| C-09 | doclistフォーマット | E-01 (60-115行目) | ○ |
| C-10 | セグメントベースのインデックス | E-01 (116-159行目) | ○ |
| C-11 | MERGE_COUNT（16）でマージ | E-01 (237-255行目) | ○ |
| C-12 | _content、_segments、_segdirシャドウテーブル | E-01 (204-228行目) | ○ |
| C-13 | snippet()関数 | E-05 | ○ |
| C-14 | offsets()関数 | E-05 | ○ |
| C-15 | matchinfo()関数 | E-05 | ○ |
| C-16 | フレーズ検索（"hello world"） | E-04 | ○ |
| C-17 | AND/OR/NOT論理演算 | E-04 | ○ |
| C-18 | NEAR近接検索 | E-04 | ○ |
| C-19 | プレフィックス検索（*） | E-04 | ○ |
| C-20 | FTS4のcontentオプション | E-02 | ○ |
| C-21 | FTS4のprefixオプション | E-02 | ○ |
| C-22 | SQLITE_ENABLE_FTS3で有効化 | E-02 (292行目) | ○ |
| C-23 | rebuildコマンドで再構築 | E-03 | ○ |
| C-24 | automergeオプション | **根拠不足** | △ |
| C-25 | 暗号化FTS拡張 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-24: automergeオプションはFTS4の機能として存在するが、fts3.cまたはfts3_write.c内での詳細な実装箇所の特定が必要
  - 候補：fts3_write.c / SQLiteドキュメント
- C-25: 暗号化FTS拡張への言及はセキュリティ考慮事項の一般的な推奨であり、SQLiteコアの一部ではない
  - 候補：サードパーティ拡張 / SQLite Encryption Extension (SEE)

## 5) リスクフラグ（レビュー観点）
- 0: アーキテクチャ説明（Claim C-01〜C-12）：fts3.c先頭コメントから直接確認可能
- 0: 補助関数（Claim C-13〜C-15）：fts3_snippet.cから確認可能
- 0: 検索構文（Claim C-16〜C-19）：fts3_expr.cから確認可能
- 1: FTS4固有オプション（Claim C-24）：詳細な実装箇所の確認が必要
- 1: セキュリティ推奨（Claim C-25）：外部拡張のため直接確認不可

## 6) レビュアーチェックリスト（最小）
- [ ] fts3.cファイル先頭のアーキテクチャコメント（26-289行目）と設計書の整合性
- [ ] MATCH構文の網羅性（全演算子が記載されているか）
- [ ] FTS3とFTS4の違いが正確に記述されているか
- [ ] automergeオプションの記述が正確か（必要に応じて修正または削除）
- [ ] 暗号化FTS拡張の記述が適切か（外部拡張であることを明記）
