---
generated_at: 2026-01-21 10:55:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：36-FTS5全文検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **BM25計算式の定数値**：一般的なBM25の定義だが、FTS5実装での正確な値の確認が必要
  2. **detail=noneでの75%削減**：定量的な数値の根拠確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/fts5/fts5_main.c` 1-300行目（メインモジュール）
- E-02: `ext/fts5/fts5_main.c` 37-88行目（トランザクション管理コメント）
- E-03: `ext/fts5/fts5_main.c` 78-152行目（Fts5Global/Fts5FullTable構造体）
- E-04: `ext/fts5/fts5_main.c` 198-275行目（Fts5Cursor構造体）
- E-05: `ext/fts5/fts5_aux.c`（補助関数実装）
- E-06: 機能一覧.csv 36行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FTS5はFTS3/FTS4の後継 | E-01 (コメント), E-06 | ○ |
| C-02 | CREATE VIRTUAL TABLE...USING fts5で作成 | E-01 | ○ |
| C-03 | トークナイザーAPI v2でロケール対応 | E-03 (96-97行目) | ○ |
| C-04 | fts5_api_from_db()でAPI取得 | E-01 (fts5.h) | ○ |
| C-05 | xCreateTokenizer_v2()でカスタムトークナイザー | E-03 (132-140行目) | ○ |
| C-06 | bm25()補助関数 | E-05 | ○ |
| C-07 | highlight()補助関数 | E-05 | ○ |
| C-08 | snippet()補助関数 | E-05 | ○ |
| C-09 | fts5vocab仮想テーブル | fts5_vocab.c | ○ |
| C-10 | ^演算子で先頭一致 | E-01 (fts5_expr.c) | ○ |
| C-11 | カラム除外（-{column}:） | E-01 (fts5_expr.c) | ○ |
| C-12 | detailオプション（full/column/none） | E-01 (fts5_config.c) | ○ |
| C-13 | contentオプション | E-01 (fts5_config.c) | ○ |
| C-14 | prefixオプション | E-01 (fts5_config.c) | ○ |
| C-15 | シャドウテーブル（_data, _idx等） | E-01 (fts5_storage.c) | ○ |
| C-16 | Fts5Cursorトランザクション状態追跡 | E-02, E-03 (150-152行目) | ○ |
| C-17 | xBegin/xSync/xCommit/xRollback | E-02 (43-47行目) | ○ |
| C-18 | セーブポイントサポート | E-02 (53-57行目) | ○ |
| C-19 | SQLITE_ENABLE_FTS5で有効化 | E-01 | ○ |
| C-20 | 'rebuild'コマンド | E-01 (fts5_storage.c) | ○ |
| C-21 | 'optimize'コマンド | E-01 (fts5_index.c) | ○ |
| C-22 | 'merge'コマンド | E-01 (fts5_index.c) | ○ |
| C-23 | fts5vocabのrow/col/instance | fts5_vocab.c | ○ |
| C-24 | FTS3/FTS4との非互換性 | E-01 (独立モジュール) | ○ |
| C-25 | BM25計算式の定数（k1=1.2, b=0.75） | **根拠不足** | △ |
| C-26 | detail=noneで最大75%削減 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: BM25の計算式は一般的な定義として正しいが、FTS5実装での実際の定数値（k1=1.2, b=0.75）の確認が必要
  - 候補：fts5_aux.c内のbm25関数実装 / SQLiteドキュメント
- C-26: detail=noneでのストレージ削減率（75%）は目安として記載されているが、実測データに基づく根拠が必要
  - 候補：FTS5ドキュメント / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 構造体定義（Claim C-03〜C-05）：fts5_main.cから直接確認可能
- 0: 補助関数（Claim C-06〜C-08）：fts5_aux.cから確認可能
- 0: オプション（Claim C-12〜C-14）：fts5_config.cから確認可能
- 1: 定量的データ（Claim C-25〜C-26）：具体的な数値の検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] FTS5とFTS3/FTS4の主要な違いが正確に記述されているか
- [ ] トランザクション管理のコメント（37-88行目）と設計書の整合性
- [ ] MATCH構文の全演算子が網羅されているか
- [ ] BM25計算式の定数値が正確か（必要に応じて修正）
- [ ] ストレージ削減率の記述が適切か（「約」を追加等）
