---
generated_at: 2026-01-21 11:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：37-R-Tree空間インデックス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **R*-treeアルゴリズムの詳細**：基本的なR-tree実装は確認できるが、R*-tree固有の再挿入アルゴリズムの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/rtree/rtree.c` 16-54行目（データベースフォーマットコメント）
- E-02: `ext/rtree/rtree.c` 160-214行目（Rtree構造体）
- E-03: `ext/rtree/rtree.c` 253-259行目（RtreeSearchPoint構造体）
- E-04: `ext/rtree/rtree.c` 136-137行目（RTREE_MAX_DIMENSIONS）
- E-05: `ext/rtree/rtree.c` 154-155行目（RTREE_DEFAULT_ROWEST）
- E-06: 機能一覧.csv 37行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | R-Treeは空間データ構造 | E-01 (16-17行目) | ○ |
| C-02 | 1〜5次元をサポート | E-04 (136行目) | ○ |
| C-03 | CREATE VIRTUAL TABLE...USING rtree | E-01, E-02 | ○ |
| C-04 | シャドウテーブル（_node, _rowid, _parent） | E-01 (25-28行目) | ○ |
| C-05 | ルートノードはnodeno=1 | E-01 (37-38行目) | ○ |
| C-06 | ノードフォーマット（深さ、エントリ数） | E-01 (42-54行目) | ○ |
| C-07 | 8バイトrowid + 座標 | E-01 (49-53行目) | ○ |
| C-08 | 32ビット浮動小数点座標（デフォルト） | E-02 (166-167行目) | ○ |
| C-09 | rtree_i32で32ビット整数座標 | E-02 (217-218行目) | ○ |
| C-10 | 補助カラム（+aux）のサポート | E-02 (169-172行目) | ○ |
| C-11 | RTREE_DEFAULT_ROWEST（1048576） | E-05 | ○ |
| C-12 | RTREE_MIN_ROWEST（100） | E-05 (155行目) | ○ |
| C-13 | 最小セル数 M/3 | E-01 (270-271行目) | ○ |
| C-14 | RTREE_MAXCELLS（51） | E-01 (272行目) | ○ |
| C-15 | 最大深さ40（RTREE_MAX_DEPTH） | E-01 (281行目) | ○ |
| C-16 | RtreeCursor優先度キュー | E-01 (294-300行目) | ○ |
| C-17 | FULLY_WITHIN/PARTLY_WITHIN/NOT_WITHIN | E-03 (257行目) | ○ |
| C-18 | ノードキャッシュ（RTREE_CACHE_SZ=5） | E-01 (289行目) | ○ |
| C-19 | SQLITE_ENABLE_RTREEで有効化 | E-01 (56-57行目) | ○ |
| C-20 | SQLITE_ENABLE_GEOPOLYでGeopoly有効化 | geopoly.c | ○ |
| C-21 | ルートノード常に存在 | E-01 (37行目) | ○ |
| C-22 | pDeletedリスト（CondenseTree） | E-02 (186-190行目) | ○ |
| C-23 | Blob I/O（pNodeBlob） | E-02 (193-194行目) | ○ |
| C-24 | R*-tree再挿入アルゴリズム | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-24: R*-treeアルゴリズムの再挿入（forced reinsert）の詳細実装。rtree.cにはR-treeの基本実装が含まれているが、R*-tree固有の最適化アルゴリズムの詳細な実装箇所の特定が必要
  - 候補：rtree.c内のSplitNode/ChooseLeaf実装 / Beckmann et al., 1990論文との比較

## 5) リスクフラグ（レビュー観点）
- 0: データ構造（Claim C-01〜C-10）：rtree.c先頭コメントと構造体定義から直接確認可能
- 0: 定数値（Claim C-11〜C-15）：マクロ定義から確認可能
- 0: 実装詳細（Claim C-16〜C-23）：構造体メンバーとコメントから確認可能
- 1: アルゴリズム詳細（Claim C-24）：R*-tree固有の最適化の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] rtree.cファイル先頭のデータベースフォーマットコメント（16-54行目）と設計書の整合性
- [ ] Rtree構造体の主要メンバーが正確に記述されているか
- [ ] R*-treeアルゴリズムの記述が正確か（必要に応じて「R-treeベース」等に修正）
- [ ] Geopoly拡張の記述が正確か
