---
generated_at: 2026-01-21 11:05:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：38-セッション拡張

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **rebase blob機能の詳細**：機能の存在は確認できるが詳細な使用方法の根拠確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/session/sqlite3session.c` 1-300行目（メイン実装）
- E-02: `ext/session/sqlite3session.c` 44-61行目（sqlite3_session構造体）
- E-03: `ext/session/sqlite3session.c` 98-112行目（sqlite3_changeset_iter構造体）
- E-04: `ext/session/sqlite3session.c` 139-154行目（SessionTable構造体）
- E-05: `ext/session/sqlite3session.c` 156-300行目（フォーマットコメント）
- E-06: 機能一覧.csv 38行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3session_create()でセッション作成 | E-02 | ○ |
| C-02 | sqlite3session_attach()でテーブル登録 | E-02 (59行目) | ○ |
| C-03 | pre-updateフックで変更検出 | E-01 (2行目コメント) | ○ |
| C-04 | sqlite3session_changeset()で出力 | E-01 | ○ |
| C-05 | sqlite3changeset_apply()で適用 | E-01 | ○ |
| C-06 | sqlite3_session構造体 | E-02 | ○ |
| C-07 | sqlite3_changeset_iter構造体 | E-03 | ○ |
| C-08 | SessionTable構造体 | E-04 | ○ |
| C-09 | CHANGESETフォーマット（0x54ヘッダ） | E-05 (197-211行目) | ○ |
| C-10 | PATCHSETフォーマット（0x50ヘッダ） | E-05 (240-277行目) | ○ |
| C-11 | RECORDフォーマット（型バイト0x00〜0x05） | E-05 (156-196行目) | ○ |
| C-12 | コンフリクト解決コード（OMIT/REPLACE/ABORT） | E-01 (sqlite3session.h) | ○ |
| C-13 | SQLITE_CHANGESET_DATAエラー | E-01 | ○ |
| C-14 | SQLITE_CHANGESET_NOTFOUNDエラー | E-01 | ○ |
| C-15 | SQLITE_CHANGESET_CONFLICTエラー | E-01 | ○ |
| C-16 | SQLITE_CHANGESET_CONSTRAINTエラー | E-01 | ○ |
| C-17 | indirectフラグ | E-02 (49行目) | ○ |
| C-18 | bEnableSizeオプション | E-02 (47行目) | ○ |
| C-19 | SQLITE_ENABLE_SESSIONで有効化 | E-01 (2行目) | ○ |
| C-20 | SQLITE_ENABLE_PREUPDATE_HOOKで有効化 | E-01 (2行目) | ○ |
| C-21 | sqlite3changeset_invert()で反転 | E-01 | ○ |
| C-22 | sqlite3changeset_concat()で連結 | E-01 | ○ |
| C-23 | sqlite3changegroup_*()でグループ化 | E-01 | ○ |
| C-24 | ストリーミングAPI（_strm） | E-05 (20-26行目) | ○ |
| C-25 | REBASE BLOBフォーマット | E-05 (279-300行目) | ○ |
| C-26 | rebase blob機能の使用方法詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-26: rebase blob機能（sqlite3changeset_apply_v2()のppRebase出力）の具体的な使用方法と、sqlite3_rebaser APIの詳細な使用例の確認が必要
  - 候補：sqlite3session.h / SQLiteドキュメント / テストコード

## 5) リスクフラグ（レビュー観点）
- 0: 構造体定義（Claim C-06〜C-08）：sqlite3session.cから直接確認可能
- 0: フォーマット仕様（Claim C-09〜C-11）：詳細なコメントから確認可能
- 0: エラーコード（Claim C-12〜C-16）：ヘッダーファイルから確認可能
- 0: コンパイルオプション（Claim C-19〜C-20）：プリプロセッサ条件から確認可能
- 1: 高度な機能（Claim C-26）：rebase機能の詳細な使用方法の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] sqlite3_session構造体の主要メンバーが正確に記述されているか
- [ ] CHANGESET/PATCHSETフォーマットの記述がコメント（156-300行目）と整合しているか
- [ ] コンフリクト解決コードの網羅性（OMIT/REPLACE/ABORT以外のコードがないか）
- [ ] rebase blob機能の記述が適切か（必要に応じて詳細化または簡略化）
