---
generated_at: 2026-01-21 11:10:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-RBU

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/rbu/sqlite3rbu.c` 14-81行目（OVERVIEWコメント）
- E-02: `ext/rbu/sqlite3rbu.c` 120-184行目（状態定義）
- E-03: `ext/rbu/sqlite3rbu.c` 243-298行目（RbuObjIter構造体）
- E-04: `ext/rbu/sqlite3rbu.c` 179-184行目（RBU_STAGE定数）
- E-05: `ext/rbu/sqlite3rbu.h`（公開API定義）
- E-06: 機能一覧.csv 39行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RBUは中断・再開可能なバルク更新 | E-01 (14-20行目) | ○ |
| C-02 | 読み取りをブロックしない | E-01 (29-30行目) | ○ |
| C-03 | *-oalファイルを使用 | E-01 (27-31行目) | ○ |
| C-04 | 3つのステージ（OAL、MOVE、CKPT） | E-01, E-04 | ○ |
| C-05 | sqlite3rbu_open()でハンドル作成 | E-05 | ○ |
| C-06 | sqlite3rbu_step()で更新進行 | E-05 | ○ |
| C-07 | data_xxxテーブル構造 | E-01 (sqlite3rbu.hコメント) | ○ |
| C-08 | rbu_control列（0=INSERT, 1=DELETE, 文字列=UPDATE） | E-05 (sqlite3rbu.h) | ○ |
| C-09 | RBU_STATE_STAGE〜RBU_STATE_DATATBL | E-02 (168-177行目) | ○ |
| C-10 | RBU_STAGE_OAL〜RBU_STAGE_DONE | E-04 | ○ |
| C-11 | imposterテーブルを使用 | E-01 (33-36行目) | ○ |
| C-12 | B-Treeをキー順にソートして更新 | E-01 (36-37行目) | ○ |
| C-13 | STAGE_MOVEで排他ロック取得 | E-01 (40-44行目) | ○ |
| C-14 | rename("*-oal", "*-wal") | E-01 (39-40行目) | ○ |
| C-15 | チェックポイントは1フレームずつ | E-01 (49-55行目) | ○ |
| C-16 | rbu_stateテーブルで状態保存 | E-02 (186-188行目) | ○ |
| C-17 | RbuObjIter構造体 | E-03 | ○ |
| C-18 | SQLITE_ENABLE_RBUで有効化 | E-01 (89行目) | ○ |
| C-19 | sqlite3rbu_vacuum()のサポート | E-05 | ○ |
| C-20 | rbu_exclusive_checkpointオプション | E-02 (117行目) | ○ |
| C-21 | 電源断耐性 | E-01 (57-68行目) | ○ |
| C-22 | WALモードDBでも動作 | E-01 (28-29行目) | ○ |
| C-23 | RbuState構造体 | E-02 (219-230行目) | ○ |
| C-24 | RbuUpdateStmt構造体 | E-02 (232-236行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がソースコードのOVERVIEWコメントまたは構造体定義から直接確認可能
- 0: ステージ定数はマクロ定義から確認可能
- 0: API仕様はsqlite3rbu.hから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] sqlite3rbu.cファイル先頭のOVERVIEWコメント（14-81行目）と設計書の整合性
- [ ] 3つのステージ（OAL、MOVE、CKPT）の説明が正確か
- [ ] rbu_control列の解釈（0=INSERT, 1=DELETE, 文字列=UPDATE）が正確か
- [ ] 電源断耐性の記述がPOTENTIAL PROBLEMSセクション（57-81行目）と整合しているか
