---
generated_at: 2026-01-21 11:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：40-データベースリカバリ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **SQLite 3.40.0以降で利用可能**：バージョン情報の正確性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/recover/sqlite3recover.c` 1-300行目（メイン実装）
- E-02: `ext/recover/sqlite3recover.c` 46-93行目（RecoverTable/RecoverColumn構造体）
- E-03: `ext/recover/sqlite3recover.c` 205-243行目（sqlite3_recover構造体）
- E-04: `ext/recover/sqlite3recover.c` 246-274行目（RECOVER_STATE定数）
- E-05: `ext/recover/sqlite3recover.h`（公開API定義）
- E-06: `ext/recover/dbdata.c`（sqlite_dbdata/dbptr仮想テーブル）
- E-07: 機能一覧.csv 40行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3_recover_init()でハンドル作成 | E-05 | ○ |
| C-02 | sqlite3_recover_config()でオプション設定 | E-05 | ○ |
| C-03 | sqlite3_recover_step()で進行 | E-05 | ○ |
| C-04 | sqlite3_recover_finish()で完了 | E-05 | ○ |
| C-05 | RecoverTable構造体 | E-02 (85-93行目) | ○ |
| C-06 | RecoverColumn構造体 | E-02 (116-122行目) | ○ |
| C-07 | sqlite3_recover構造体 | E-03 | ○ |
| C-08 | RECOVER_STATE_*定数 | E-04 (267-274行目) | ○ |
| C-09 | SQLITE_RECOVER_LOST_AND_FOUNDオプション | E-03 (215行目) | ○ |
| C-10 | SQLITE_RECOVER_FREELIST_CORRUPTオプション | E-03 (216行目) | ○ |
| C-11 | SQLITE_RECOVER_ROWIDSオプション | E-03 (217行目) | ○ |
| C-12 | SQLITE_RECOVER_SLOWINDEXESオプション | E-03 (218行目) | ○ |
| C-13 | sqlite_dbdata仮想テーブル | E-06 (30行目) | ○ |
| C-14 | sqlite_dbptr仮想テーブル | E-06 (30行目) | ○ |
| C-15 | RecoverStateLAF構造体 | E-01 (186-200行目) | ○ |
| C-16 | RecoverStateW1構造体 | E-01 (164-179行目) | ○ |
| C-17 | RecoverBitmap構造体 | E-01 (150-154行目) | ○ |
| C-18 | lost_and_foundテーブル構造 | E-01 (lost_and_found関連コード) | ○ |
| C-19 | RECOVER_EHIDDEN_*定数 | E-02 (124-127行目) | ○ |
| C-20 | WITHOUT ROWIDサポート | E-02 (90行目 bIntkey) | ○ |
| C-21 | RecoverGlobal構造体 | E-01 (279-283行目) | ○ |
| C-22 | RECOVER_MUTEX_ID | E-01 (290行目) | ○ |
| C-23 | RECOVER_ROWID_DEFAULT | E-01 (296行目) | ○ |
| C-24 | SQLite 3.40.0以降で利用可能 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-24: SQLite 3.40.0で追加されたという情報はSQLiteリリースノートや公式ドキュメントに基づくが、ソースコード内での明示的なバージョン確認が必要
  - 候補：SQLiteリリースノート / CHANGES.txt / sqlite3.h内のバージョン定義

## 5) リスクフラグ（レビュー観点）
- 0: 構造体定義（Claim C-05〜C-08）：sqlite3recover.cから直接確認可能
- 0: オプション定数（Claim C-09〜C-12）：sqlite3_recover構造体メンバーから確認可能
- 0: 仮想テーブル（Claim C-13〜C-14）：dbdata.cから確認可能
- 1: バージョン情報（Claim C-24）：外部ドキュメントでの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] sqlite3_recover構造体の主要メンバーが正確に記述されているか
- [ ] RECOVER_STATE_*定数の遷移順序が正確か
- [ ] lost_and_foundテーブルの構造が正確か
- [ ] バージョン情報（3.40.0以降）が正確か（必要に応じて修正）
