---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート: 41-メモリ管理

## 概要

本レポートは「機能設計書 41-メモリ管理」に記載された内容の根拠を示し、各主張がソースコードのどの部分に基づいているかを明確にする。

## 根拠一覧

### 1. 処理概要に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| メモリ割り当てはsqlite3Malloc関数で実行 | src/malloc.c | 296-309 | `void *sqlite3Malloc(u64 n){...}` |
| 統計モード有効時はミューテックスを取得 | src/malloc.c | 300-303 | `sqlite3_mutex_enter(mem0.mutex); mallocWithAlarm((int)n, &p); sqlite3_mutex_leave(mem0.mutex);` |
| 8バイトアライメントが保証される | src/malloc.c | 307 | `assert( EIGHT_BYTE_ALIGNMENT(p) );` |
| NULLポインタの解放はno-op | src/malloc.c | 392 | `if( p==0 ) return;  /* IMP: R-49053-54554 */` |

### 2. データ構造に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| Mem0Globalにmutex, alarmThreshold, hardLimit, nearlyFullが存在 | src/malloc.c | 45-55 | `static SQLITE_WSD struct Mem0Global { sqlite3_mutex *mutex; sqlite3_int64 alarmThreshold; sqlite3_int64 hardLimit; int nearlyFull; } mem0` |
| Mem5Globalにszatom, nBlock, zPool, mutex, aiFreelist, aCtrlが存在 | src/mem5.c | 92-132 | `static SQLITE_WSD struct Mem5Global { int szAtom; int nBlock; u8 *zPool; sqlite3_mutex *mutex; int aiFreelist[LOGMAX+1]; u8 *aCtrl; } mem5;` |

### 3. Lookasideメモリに関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| Lookasideはdb接続ごとに小規模メモリプールを提供 | src/malloc.c | 643-690 | `void *sqlite3DbMallocRawNN(sqlite3 *db, u64 n){...}` |
| 小規模スロット（LOOKASIDE_SMALL）が存在 | src/malloc.c | 658-668 | `if( n<=LOOKASIDE_SMALL ){ if( (pBuf = db->lookaside.pSmallFree)!=0 ){...} }` |
| Lookasideからの割り当てはミューテックス不要 | src/malloc.c | 670-677 | 直接pFreeリストから取得、mutex操作なし |
| isLookaside関数でLookaside領域を判定 | src/malloc.c | 333-335 | `static int isLookaside(sqlite3 *db, const void *p){ return SQLITE_WITHIN(p, db->lookaside.pStart, db->lookaside.pTrueEnd); }` |

### 4. ヒープ制限に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| ソフトヒープ制限はsqlite3_soft_heap_limit64で設定 | src/malloc.c | 95-123 | `sqlite3_int64 sqlite3_soft_heap_limit64(sqlite3_int64 n){...}` |
| ハードヒープ制限はsqlite3_hard_heap_limit64で設定 | src/malloc.c | 137-153 | `sqlite3_int64 sqlite3_hard_heap_limit64(sqlite3_int64 n){...}` |
| ハード制限超過時は割り当て失敗 | src/malloc.c | 265-271 | `if( mem0.hardLimit ){ nUsed = sqlite3StatusValue(SQLITE_STATUS_MEMORY_USED); if( nUsed >= mem0.hardLimit - nFull ){ *pp = 0; return; } }` |
| ソフト制限超過時はキャッシュ解放を試行 | src/malloc.c | 116-117 | `excess = sqlite3_memory_used() - n; if( excess>0 ) sqlite3_release_memory((int)(excess & 0x7fffffff));` |

### 5. アラーム機構に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3MallocAlarmがキャッシュ解放をトリガー | src/malloc.c | 217-222 | `static void sqlite3MallocAlarm(int nByte){ if( mem0.alarmThreshold<=0 ) return; sqlite3_mutex_leave(mem0.mutex); sqlite3_release_memory(nByte); sqlite3_mutex_enter(mem0.mutex); }` |
| nearlyFullフラグで閾値接近を追跡 | src/malloc.c | 114 | `AtomicStore(&mem0.nearlyFull, n>0 && n<=nUsed);` |
| sqlite3HeapNearlyFull関数で状態取得可能 | src/malloc.c | 180-182 | `int sqlite3HeapNearlyFull(void){ return AtomicLoad(&mem0.nearlyFull); }` |

### 6. システムmallocラッパー（mem1.c）に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| SQLITE_MALLOCSIZEマクロでmalloc_usable_size相当を使用 | src/mem1.c | 107-116 | `#if defined(SQLITE_USE_MALLOC_USABLE_SIZE)... #define SQLITE_MALLOCSIZE(x) malloc_usable_size(x)` |
| Apple環境ではzone allocatorを使用 | src/mem1.c | 52-68 | `#if defined(__APPLE__)... static malloc_zone_t* _sqliteZone_; #define SQLITE_MALLOC(x) malloc_zone_malloc(_sqliteZone_, (x))` |
| sqlite3MemSetDefaultでデフォルトアロケータを設定 | src/mem1.c | 277-289 | `void sqlite3MemSetDefault(void){ static const sqlite3_mem_methods defaultMethods = {...}; sqlite3_config(SQLITE_CONFIG_MALLOC, &defaultMethods); }` |

### 7. memsys5バディアロケータに関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| サイズを2のべき乗に切り上げ | src/mem5.c | 242 | `for(iFullSz=mem5.szAtom,iLogsize=0; iFullSz<nByte; iFullSz*=2,iLogsize++){}` |
| フリーリストから適切サイズのブロックを検索 | src/mem5.c | 248-253 | `for(iBin=iLogsize; iBin<=LOGMAX && mem5.aiFreelist[iBin]<0; iBin++){} if( iBin>LOGMAX ){ sqlite3_log(SQLITE_NOMEM,...); return 0; }` |
| 大きいブロックを分割して使用 | src/mem5.c | 256-263 | `while( iBin>iLogsize ){ iBin--; newSize = 1 << iBin; mem5.aCtrl[i+newSize] = CTRL_FREE \| iBin; memsys5Link(i+newSize, iBin); }` |
| 解放時にバディブロックをマージ | src/mem5.c | 321-342 | `while( ALWAYS(iLogsize<LOGMAX) ){ int iBuddy;... if( mem5.aCtrl[iBuddy]!=(CTRL_FREE \| iLogsize) ) break; memsys5Unlink(iBuddy, iLogsize); iLogsize++;...}` |
| 最大割り当てサイズは1GiB | src/mem5.c | 230 | `if( nByte > 0x40000000 ) return 0;` |

### 8. OOM処理に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3OomFaultでmallocFailedフラグ設定 | src/malloc.c | 827-845 | `void *sqlite3OomFault(sqlite3 *db){ if( db->mallocFailed==0 && db->bBenignMalloc==0 ){ db->mallocFailed = 1;...} }` |
| mallocFailed後の後続malloc全て失敗 | src/malloc.c | 652-654 | `}else if( db->mallocFailed ){ return 0; }` |
| sqlite3OomClearでフラグリセット | src/malloc.c | 854-861 | `void sqlite3OomClear(sqlite3 *db){ if( db->mallocFailed && db->nVdbeExec==0 ){ db->mallocFailed = 0;...} }` |

### 9. 初期化・終了処理に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3MallocInitでメモリサブシステム初期化 | src/malloc.c | 159-173 | `int sqlite3MallocInit(void){...rc = sqlite3GlobalConfig.m.xInit(sqlite3GlobalConfig.m.pAppData);...}` |
| sqlite3MallocEndでサブシステム終了 | src/malloc.c | 187-192 | `void sqlite3MallocEnd(void){ if( sqlite3GlobalConfig.m.xShutdown ){ sqlite3GlobalConfig.m.xShutdown(sqlite3GlobalConfig.m.pAppData); } memset(&mem0, 0, sizeof(mem0)); }` |

### 10. デバッグ機能に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 解放済みメモリを0xAAでパターン埋め | src/malloc.c | 429 | `memset(p, 0xaa, LOOKASIDE_SMALL);  /* Trash freed content */` |
| memsys5で0x55パターンで埋め | src/mem5.c | 347 | `memset(&mem5.zPool[iBlock*mem5.szAtom], 0x55, size);` |
| 割り当て時は0xAAで初期化（memsys5） | src/mem5.c | 280 | `memset(&mem5.zPool[i*mem5.szAtom], 0xAA, iFullSz);` |

## 根拠なし項目

| 主張 | 理由 |
|------|------|
| 「組み込みデータベースとして様々な環境で動作」 | 一般的な知識に基づく記述、コード内に直接の根拠なし |
| 「リソースが限られた組み込み環境から大規模サーバー環境まで」 | 設計意図の説明であり、コードコメントに明示的記述なし |

## 信頼度評価

- **claims_total**: 35
- **claims_with_evidence**: 33
- **claims_without_evidence**: 2
- **confidence_derived**: 33 / 35 = 0.94 (94%)

根拠なしの2項目は、SQLiteの一般的な特性に関する説明文であり、機能の技術的正確性には影響しない。
