---
generated_at: 2026-01-21 10:45:00
metrics:
  claims_total: 32
  claims_with_evidence: 31
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート: 42-ミューテックス

## 概要

本レポートは「機能設計書 42-ミューテックス」に記載された内容の根拠を示し、各主張がソースコードのどの部分に基づいているかを明確にする。

## 根拠一覧

### 1. 処理概要に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| ミューテックス割り当てはsqlite3_mutex_allocで実行 | src/mutex.c | 281-288 | `sqlite3_mutex *sqlite3_mutex_alloc(int id){...}` |
| NULLポインタ操作はno-op | src/mutex.c | 314, 340 | `if( p ){...}` |
| bCoreMutex有効時はsqlite3DefaultMutex使用 | src/mutex.c | 230-235 | `if( sqlite3GlobalConfig.bCoreMutex ){ pFrom = sqlite3DefaultMutex(); }` |
| bCoreMutex無効時はsqlite3NoopMutex使用 | src/mutex.c | 236-238 | `}else{ pFrom = sqlite3NoopMutex(); }` |

### 2. データ構造に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| pthreads実装はpthread_mutex_tを内包 | src/mutex_unix.c | 41-51 | `struct sqlite3_mutex { pthread_mutex_t mutex; int id; volatile int nRef; volatile pthread_t owner; int trace; };` |
| デバッグ実装はidとcntを持つ | src/mutex_noop.c | 80-83 | `typedef struct sqlite3_debug_mutex { int id; int cnt; } sqlite3_debug_mutex;` |
| 静的ミューテックスは配列で管理 | src/mutex_unix.c | 154-167 | `static sqlite3_mutex staticMutexes[] = { SQLITE3_MUTEX_INITIALIZER(2),...}` |

### 3. ミューテックス種別に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| SQLITE_MUTEX_FAST=0, RECURSIVE=1 | src/mutex.c | 100 | `assert( SQLITE_MUTEX_RECURSIVE==1 && SQLITE_MUTEX_FAST==0 );` |
| 静的ミューテックスの種類（MAIN,MEM,OPEN等） | src/mutex_unix.c | 113-127 | コメントで列挙: `SQLITE_MUTEX_STATIC_MAIN...SQLITE_MUTEX_STATIC_VFS3` |
| 動的ミューテックスは毎回新規生成 | src/mutex_unix.c | 147-150 | `Note that if one of the dynamic mutex parameters... returns a different mutex on every call` |

### 4. pthreads実装に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| RECURSIVEはPTHREAD_MUTEX_RECURSIVEで初期化 | src/mutex_unix.c | 179-183 | `pthread_mutexattr_settype(&recursiveAttr, PTHREAD_MUTEX_RECURSIVE); pthread_mutex_init(&p->mutex, &recursiveAttr);` |
| FASTは通常のpthread_mutex_init | src/mutex_unix.c | 194 | `pthread_mutex_init(&p->mutex, 0);` |
| pthreadMutexEnterはpthread_mutex_lockを呼び出し | src/mutex_unix.c | 279 | `pthread_mutex_lock(&p->mutex);` |
| pthreadMutexLeaveはpthread_mutex_unlockを呼び出し | src/mutex_unix.c | 363 | `pthread_mutex_unlock(&p->mutex);` |
| pthreadMutexTryはpthread_mutex_trylockを使用 | src/mutex_unix.c | 325 | `if( pthread_mutex_trylock(&p->mutex)==0 ){` |

### 5. no-op実装に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| noopMutexAllocは固定値(8)を返却 | src/mutex_noop.c | 40-43 | `static sqlite3_mutex *noopMutexAlloc(int id){ UNUSED_PARAMETER(id); return (sqlite3_mutex*)8; }` |
| noopMutexEnterは何もしない | src/mutex_noop.c | 45 | `static void noopMutexEnter(sqlite3_mutex *p){ UNUSED_PARAMETER(p); return; }` |
| noopMutexTryは常にSQLITE_OK | src/mutex_noop.c | 46-49 | `static int noopMutexTry(sqlite3_mutex *p){ UNUSED_PARAMETER(p); return SQLITE_OK; }` |

### 6. デバッグ機能に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| debugMutexEnterはcntをインクリメント | src/mutex_noop.c | 163-167 | `static void debugMutexEnter(sqlite3_mutex *pX){ sqlite3_debug_mutex *p = ...; p->cnt++; }` |
| debugMutexHeldはcnt>0で判定 | src/mutex_noop.c | 89-92 | `static int debugMutexHeld(sqlite3_mutex *pX){ sqlite3_debug_mutex *p = ...; return p==0 || p->cnt>0; }` |
| pthreadMutexHeldはnRefとownerで判定 | src/mutex_unix.c | 78-80 | `static int pthreadMutexHeld(sqlite3_mutex *p){ return (p->nRef!=0 && pthread_equal(p->owner, pthread_self())); }` |
| TSANビルド時はheld/notheldを無効化 | src/mutex.c | 355-358 | `#if __has_feature(thread_sanitizer) p = 0; #endif` |

### 7. 初期化・終了処理に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3MutexInitで関数ポインタをコピー | src/mutex.c | 239-248 | `pTo->xMutexInit = pFrom->xMutexInit;... pTo->xMutexAlloc = pFrom->xMutexAlloc;` |
| sqlite3MutexEndでxMutexEndを呼び出し | src/mutex.c | 265-276 | `if( sqlite3GlobalConfig.mutex.xMutexEnd ){ rc = sqlite3GlobalConfig.mutex.xMutexEnd(); }` |
| pthreadMutexInit/Endは何もしない | src/mutex_unix.c | 102-103 | `static int pthreadMutexInit(void){ return SQLITE_OK; } static int pthreadMutexEnd(void){ return SQLITE_OK; }` |

### 8. API関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3_mutex_freeは動的ミューテックスのみ解放 | src/mutex_unix.c | 224-238 | `static void pthreadMutexFree(sqlite3_mutex *p){... if( p->id==SQLITE_MUTEX_FAST || p->id==SQLITE_MUTEX_RECURSIVE ){ pthread_mutex_destroy(&p->mutex); sqlite3_free(p); } }` |
| sqlite3_mutex_tryはSQLITE_BUSYを返す可能性 | src/mutex_unix.c | 331-332 | `}else{ rc = SQLITE_BUSY; }` |
| sqlite3MutexAllocはbCoreMutex無効時にNULL返却 | src/mutex.c | 290-297 | `sqlite3_mutex *sqlite3MutexAlloc(int id){ if( !sqlite3GlobalConfig.bCoreMutex ){ return 0; }...}` |

### 9. メモリバリアに関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3MemoryBarrierでメモリバリアを提供 | src/mutex_unix.c | 91-97 | `void sqlite3MemoryBarrier(void){... __sync_synchronize(); }` |
| 初期化時にメモリバリアを挿入 | src/mutex.c | 247, 257 | `sqlite3MemoryBarrier();` |

### 10. マルチスレッドチェック機能に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| SQLITE_ENABLE_MULTITHREADED_CHECKSでラッパー実装 | src/mutex.c | 30-214 | `#ifdef SQLITE_ENABLE_MULTITHREADED_CHECKS...` |
| 競合検出時にsqlite3_logで警告 | src/mutex.c | 160-162 | `sqlite3_log(SQLITE_MISUSE, "illegal multi-threaded access to database connection");` |
| CheckMutex構造体でラップ | src/mutex.c | 54-58 | `struct CheckMutex { int iType; sqlite3_mutex *mutex; };` |

## 根拠なし項目

| 主張 | 理由 |
|------|------|
| 「デッドロック回避のため一貫した順序で取得」 | 設計ガイドラインとしての記述、コード内に強制ロジックなし |

## 信頼度評価

- **claims_total**: 32
- **claims_with_evidence**: 31
- **claims_without_evidence**: 1
- **confidence_derived**: 31 / 32 = 0.97 (97%)

根拠なしの1項目は設計指針に関する記述であり、コードの技術的正確性には影響しない。
