---
generated_at: 2026-01-21 11:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 34
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート: 43-OS抽象化層（VFS）

## 概要

本レポートは「機能設計書 43-OS抽象化層（VFS）」に記載された内容の根拠を示し、各主張がソースコードのどの部分に基づいているかを明確にする。

## 根拠一覧

### 1. VFS概要に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| VFSはUnix系OS向けの実装を提供 | src/os_unix.c | 13-14 | `This file contains the VFS implementation for unix-like operating systems include Linux, MacOSX, *BSD, QNX, VxWorks, AIX, HPUX, and others.` |
| 複数のロック方式が存在 | src/os_unix.c | 50-59 | `There are various methods for file locking... 1. POSIX locking (the default), 2. No locking, 3. Dot-file locking, 4. flock() locking, 5. AFP locking, 6. Named POSIX semaphores, 7. proxy locking.` |

### 2. データ構造に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| unixFile構造体がUnix VFSのファイルハンドル | src/os_unix.c | 257-312 | `struct unixFile { sqlite3_io_methods const *pMethod; sqlite3_vfs *pVfs; unixInodeInfo *pInode; int h;...}` |
| pMethodが常に先頭 | src/os_unix.c | 258 | `sqlite3_io_methods const *pMethod;  /* Always the first entry */` |
| vfsListで登録済みVFSを管理 | src/os.c | 355-356 | `static sqlite3_vfs * SQLITE_WSD vfsList = 0; #define vfsList GLOBAL(sqlite3_vfs *, vfsList)` |

### 3. VFS管理に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3_vfs_findで名前またはNULLで検索 | src/os.c | 362-381 | `sqlite3_vfs *sqlite3_vfs_find(const char *zVfs){...for(pVfs = vfsList; pVfs; pVfs=pVfs->pNext){ if( zVfs==0 ) break; if( strcmp(zVfs, pVfs->zName)==0 ) break; }` |
| makeDflt=trueで先頭に挿入 | src/os.c | 421-427 | `if( makeDflt || vfsList==0 ){ pVfs->pNext = vfsList; vfsList = pVfs; }else{ pVfs->pNext = vfsList->pNext; vfsList->pNext = pVfs; }` |
| SQLITE_MUTEX_STATIC_MAINで保護 | src/os.c | 372-374 | `mutex = sqlite3MutexAlloc(SQLITE_MUTEX_STATIC_MAIN); sqlite3_mutex_enter(mutex);` |

### 4. OS抽象化ラッパーに関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3OsCloseはpMethods経由で呼び出し | src/os.c | 82-87 | `void sqlite3OsClose(sqlite3_file *pId){ if( pId->pMethods ){ pId->pMethods->xClose(pId); pId->pMethods = 0; } }` |
| sqlite3OsReadはxRead呼び出し | src/os.c | 88-91 | `int sqlite3OsRead(sqlite3_file *id, void *pBuf, int amt, i64 offset){ DO_OS_MALLOC_TEST(id); return id->pMethods->xRead(id, pBuf, amt, offset); }` |
| sqlite3OsOpenはpVfs->xOpen呼び出し | src/os.c | 229 | `rc = pVfs->xOpen(pVfs, zPath, pFile, flags & 0x1087f7f, pFlagsOut);` |

### 5. システムコールテーブルに関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| aSyscall配列でシステムコールを管理 | src/os_unix.c | 423-596 | `static struct unix_syscall { const char *zName; sqlite3_syscall_ptr pCurrent; sqlite3_syscall_ptr pDefault; } aSyscall[] = { { "open", ... }` |
| osOpenマクロで間接呼び出し | src/os_unix.c | 429 | `#define osOpen ((int(*)(const char*,int,int))aSyscall[0].pCurrent)` |
| unixSetSystemCallでオーバーライド可能 | src/os_unix.c | 731-767 | `static int unixSetSystemCall(sqlite3_vfs *pNotUsed, const char *zName, sqlite3_syscall_ptr pNewFunc){...aSyscall[i].pCurrent = pNewFunc;...}` |

### 6. 堅牢なファイル操作に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| robust_openでEINTRリトライ | src/os_unix.c | 834-856 | `static int robust_open(const char *z, int f, mode_t m){ int fd;...while(1){ fd = osOpen(z,f|O_CLOEXEC,m2); if( fd<0 ){ if( errno==EINTR ) continue; break; }...}` |
| FD<3は使用しない | src/os_unix.c | 813-815, 847 | `#define SQLITE_MINIMUM_FILE_DESCRIPTOR 3... if( fd>=SQLITE_MINIMUM_FILE_DESCRIPTOR ) break;` |
| /dev/null開いてFD確保 | src/os_unix.c | 855 | `if( osOpen("/dev/null", O_RDONLY, m)<0 ) break;` |
| デフォルトパーミッションは0644 | src/os_unix.c | 166-168 | `#ifndef SQLITE_DEFAULT_FILE_PERMISSIONS # define SQLITE_DEFAULT_FILE_PERMISSIONS 0644 #endif` |

### 7. ミューテックス保護に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| unixBigLockでグローバル保護 | src/os_unix.c | 898 | `static sqlite3_mutex *unixBigLock = 0;` |
| unixEnterMutex/LeaveMutexで取得・解放 | src/os_unix.c | 899-906 | `static void unixEnterMutex(void){ assert( sqlite3_mutex_notheld(unixBigLock) ); sqlite3_mutex_enter(unixBigLock); }` |

### 8. ファイルフラグに関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| UNIXFILE_*フラグの定義 | src/os_unix.c | 323-334 | `#define UNIXFILE_EXCL 0x01... #define UNIXFILE_RDONLY 0x02... #define UNIXFILE_DELETE 0x20...` |
| 最大パス長512バイト | src/os_unix.c | 180 | `#define MAX_PATHNAME 512` |

### 9. pread/pwrite使用に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| Apple/Linuxでpread/pwrite使用 | src/os_unix.c | 75-78 | `#if defined(__APPLE__) || defined(__linux__) # define HAVE_PREAD 1 # define HAVE_PWRITE 1 #endif` |
| osPreadマクロ定義 | src/os_unix.c | 471 | `#define osPread ((ssize_t(*)(int,void*,size_t,off_t))aSyscall[9].pCurrent)` |

### 10. FD_CLOEXEC設定に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| O_CLOEXECでオープン | src/os_unix.c | 839 | `fd = osOpen(z,f|O_CLOEXEC,m2);` |
| FD_CLOEXEC後付け設定 | src/os_unix.c | 867-868 | `#if defined(FD_CLOEXEC) && (!defined(O_CLOEXEC) || O_CLOEXEC==0) osFcntl(fd, F_SETFD, osFcntl(fd, F_GETFD, 0) | FD_CLOEXEC);` |

### 11. ロック種別に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| ロックレベル定数（NO_LOCK等） | src/os_unix.c | 921-926 | `case NO_LOCK: return "NONE"; case SHARED_LOCK: return "SHARED"; case RESERVED_LOCK: return "RESERVED"; case PENDING_LOCK: return "PENDING"; case EXCLUSIVE_LOCK: return "EXCLUSIVE";` |

### 12. WAL/メモリマップに関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| mmapサポート（SQLITE_MAX_MMAP_SIZE>0時） | src/os_unix.c | 270-276 | `#if SQLITE_MAX_MMAP_SIZE>0 int nFetchOut; sqlite3_int64 mmapSize;...void *pMapRegion; #endif` |
| sqlite3OsShmMap実装 | src/os.c | 179-188 | `int sqlite3OsShmMap(...){ DO_OS_MALLOC_TEST(id); return id->pMethods->xShmMap(id, iPage, pgsz, bExtend, pp); }` |

## 根拠なし項目

| 主張 | 理由 |
|------|------|
| 「組み込みシステムからデスクトップ、サーバーまで多様な環境で動作」 | SQLiteの一般的特性の説明であり、コード内に直接の根拠なし |

## 信頼度評価

- **claims_total**: 35
- **claims_with_evidence**: 34
- **claims_without_evidence**: 1
- **confidence_derived**: 34 / 35 = 0.97 (97%)

根拠なしの1項目はSQLiteの一般的な特性に関する説明であり、技術的正確性には影響しない。
