---
generated_at: 2026-01-21 11:15:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 44-UTF-8/UTF-16エンコーディング

## 概要

本レポートは「機能設計書 44-UTF-8/UTF-16エンコーディング」に記載された内容の根拠を示し、各主張がソースコードのどの部分に基づいているかを明確にする。

## 根拠一覧

### 1. エンコーディング規則に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| UTF-8のバイト構造 | src/utf.c | 15-22 | コメント: `Byte-0 Byte-1 Byte-2 Byte-3 Value...` |
| UTF-16のワード構造 | src/utf.c | 24-28 | コメント: `Word-0 Word-1 Value... 110110ww wwzzzzyy...` |
| BOMの定義 | src/utf.c | 31-33 | `BOM or Byte Order Mark: 0xff 0xfe little-endian utf-16 follows 0xfe 0xff big-endian utf-16 follows` |

### 2. UTF-8デコードテーブルに関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3Utf8Trans1テーブルの存在 | src/utf.c | 52-61 | `static const unsigned char sqlite3Utf8Trans1[] = { 0x00, 0x01, 0x02,...}` |
| テーブルの目的 | src/utf.c | 49-50 | `This lookup table is used to help decode the first byte of a multi-byte UTF8 character.` |

### 3. UTF-8書き込みマクロに関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 1バイト文字（0x80未満） | src/utf.c | 65-66 | `if( c<0x00080 ){ *zOut++ = (u8)(c&0xFF); }` |
| 2バイト文字（0x800未満） | src/utf.c | 68-70 | `else if( c<0x00800 ){ *zOut++ = 0xC0 + (u8)((c>>6)&0x1F); *zOut++ = 0x80 + (u8)(c & 0x3F); }` |
| 3バイト文字（0x10000未満） | src/utf.c | 72-75 | `else if( c<0x10000 ){ *zOut++ = 0xE0 + (u8)((c>>12)&0x0F);...}` |
| 4バイト文字 | src/utf.c | 76-81 | `else{ *zOut++ = 0xF0 + (u8)((c>>18) & 0x07);...}` |

### 4. UTF-8読み取りに関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| READ_UTF8マクロの実装 | src/utf.c | 164-174 | `#define READ_UTF8(zIn, zTerm, c) c = *(zIn++); if( c>=0xc0 ){...}` |
| 継続バイト処理 | src/utf.c | 168-170 | `while( zIn<zTerm && (*zIn & 0xc0)==0x80 ){ c = (c<<6) + (0x3f & *(zIn++)); }` |
| sqlite3Utf8Read関数 | src/utf.c | 175-194 | `u32 sqlite3Utf8Read(const unsigned char **pz){...}` |

### 5. 不正UTF-8の処理に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| オーバーロング、サロゲート、非文字を0xFFFDに | src/utf.c | 171-173 | `if( c<0x80 || (c&0xFFFFF800)==0xD800 || (c&0xFFFFFFFE)==0xFFFE ){ c = 0xFFFD; }` |
| 処理方針のコメント | src/utf.c | 146-162 | `Notes On Invalid UTF-8: * This routine never allows a 7-bit character... to be encoded as a multi-byte character...` |

### 6. UTF-16書き込みマクロに関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| WRITE_UTF16LEマクロ（BMP範囲） | src/utf.c | 84-88 | `#define WRITE_UTF16LE(zOut, c) { if( c<=0xFFFF ){ *zOut++ = (u8)(c&0x00FF); *zOut++ = (u8)((c>>8)&0x00FF); }` |
| WRITE_UTF16LEマクロ（サロゲート） | src/utf.c | 88-93 | `else{ *zOut++ = (u8)(((c>>10)&0x003F) + (((c-0x10000)>>10)&0x00C0));...}` |
| WRITE_UTF16BEマクロ | src/utf.c | 96-106 | `#define WRITE_UTF16BE(zOut, c) {...}` |

### 7. エンコーディング変換に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3VdbeMemTranslate関数 | src/utf.c | 242-424 | `SQLITE_NOINLINE int sqlite3VdbeMemTranslate(Mem *pMem, u8 desiredEnc){...}` |
| UTF-16間はバイトスワップのみ | src/utf.c | 266-288 | `If the translation is between UTF-16 little and big endian, then all that is required is to swap the byte order.` |
| UTF-8→UTF-16バッファサイズ | src/utf.c | 299-305 | `len = 2 * (sqlite3_int64)pMem->n + 2;` |
| UTF-16→UTF-8バッファサイズ | src/utf.c | 291-298 | `len = 2 * (sqlite3_int64)pMem->n + 1;` |

### 8. サロゲートペア処理に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| UTF-16LEでのサロゲート検出 | src/utf.c | 346-366 | `if( c>=0xd800 && c<0xe000 ){...c = ((c&0x3ff)<<10) + (c2&0x3ff) + 0x10000;...}` |
| UTF-16BEでのサロゲート処理 | src/utf.c | 375-395 | 同様の処理をBE用に実装 |

### 9. BOM処理に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3VdbeMemHandleBom関数 | src/utf.c | 437-465 | `int sqlite3VdbeMemHandleBom(Mem *pMem){...}` |
| 0xFE 0xFF=UTF-16BE | src/utf.c | 445-446 | `if( b1==0xFE && b2==0xFF ){ bom = SQLITE_UTF16BE; }` |
| 0xFF 0xFE=UTF-16LE | src/utf.c | 448-449 | `if( b1==0xFF && b2==0xFE ){ bom = SQLITE_UTF16LE; }` |
| BOM削除処理 | src/utf.c | 456-461 | `pMem->n -= 2; memmove(pMem->z, &pMem->z[2], pMem->n);` |

### 10. 文字カウントに関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3Utf8CharLen関数 | src/utf.c | 475-490 | `int sqlite3Utf8CharLen(const char *zIn, int nByte){...}` |
| SQLITE_SKIP_UTF8マクロ使用 | src/utf.c | 486 | `SQLITE_SKIP_UTF8(z);` |
| sqlite3Utf16ByteLen関数 | src/utf.c | 551-566 | `int sqlite3Utf16ByteLen(const void *zIn, int nByte, int nChar){...}` |

### 11. その他の関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3Utf16to8関数 | src/utf.c | 529-543 | `char *sqlite3Utf16to8(sqlite3 *db, const void *z, int nByte, u8 enc){...}` |
| sqlite3AppendOneUtf8Character関数 | src/utf.c | 114-135 | `int sqlite3AppendOneUtf8Character(char *zOut, u32 v){...}` |
| sqlite3Utf8ReadLimited関数 | src/utf.c | 208-227 | `int sqlite3Utf8ReadLimited(const u8 *z, int n, u32 *piOut){...}` |

## 根拠なし項目

なし

## 信頼度評価

- **claims_total**: 30
- **claims_with_evidence**: 30
- **claims_without_evidence**: 0
- **confidence_derived**: 30 / 30 = 1.00 (100%)

すべての主張についてソースコード内に明確な根拠が存在する。
