---
generated_at: 2026-01-21 11:45:00
metrics:
  claims_total: 32
  claims_with_evidence: 32
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 46-ステータス情報

## 概要

本レポートは「機能設計書 46-ステータス情報」に記載された内容の根拠を示し、各主張がソースコードのどの部分に基づいているかを明確にする。

## 根拠一覧

### 1. データ構造に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3StatValueType型定義（64ビット条件） | src/status.c | 22-26 | `#if SQLITE_PTRSIZE>4 typedef sqlite3_int64 sqlite3StatValueType; #else typedef u32 sqlite3StatValueType; #endif` |
| sqlite3StatType構造体の定義 | src/status.c | 28-31 | `static SQLITE_WSD struct sqlite3StatType { sqlite3StatValueType nowValue[10]; sqlite3StatValueType mxValue[10]; } sqlite3Stat = { {0,}, {0,} };` |
| nowValue[10]が現在値 | src/status.c | 29 | `sqlite3StatValueType nowValue[10];  /* Current value */` |
| mxValue[10]が最大値 | src/status.c | 30 | `sqlite3StatValueType mxValue[10];   /* Maximum value */` |

### 2. ミューテックス選択に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| statMutex配列の定義 | src/status.c | 37-48 | `static const char statMutex[] = { 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, };` |
| MEMORY_USEDはMallocMutex（0） | src/status.c | 38 | `0,  /* SQLITE_STATUS_MEMORY_USED */` |
| PAGECACHE_USEDはPcache1Mutex（1） | src/status.c | 39 | `1,  /* SQLITE_STATUS_PAGECACHE_USED */` |
| ミューテックス選択ロジック | src/status.c | 148 | `pMutex = statMutex[op] ? sqlite3Pcache1Mutex() : sqlite3MallocMutex();` |

### 3. sqlite3StatusValue関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 関数定義 | src/status.c | 69-76 | `sqlite3_int64 sqlite3StatusValue(int op){...return wsdStat.nowValue[op];}` |
| ミューテックス保持のassert | src/status.c | 73-74 | `assert( sqlite3_mutex_held(statMutex[op] ? sqlite3Pcache1Mutex() : sqlite3MallocMutex()) );` |

### 4. sqlite3StatusUp関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 関数定義 | src/status.c | 89-99 | `void sqlite3StatusUp(int op, int N){...}` |
| 現在値の加算 | src/status.c | 95 | `wsdStat.nowValue[op] += N;` |
| 最大値の更新条件 | src/status.c | 96-98 | `if( wsdStat.nowValue[op]>wsdStat.mxValue[op] ){ wsdStat.mxValue[op] = wsdStat.nowValue[op]; }` |

### 5. sqlite3StatusDown関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 関数定義 | src/status.c | 100-108 | `void sqlite3StatusDown(int op, int N){...}` |
| N>=0のassert | src/status.c | 102 | `assert( N>=0 );` |
| 現在値の減算 | src/status.c | 107 | `wsdStat.nowValue[op] -= N;` |

### 6. sqlite3StatusHighwater関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 関数定義 | src/status.c | 114-129 | `void sqlite3StatusHighwater(int op, int X){...}` |
| 対象項目のassert | src/status.c | 123-125 | `assert( op==SQLITE_STATUS_MALLOC_SIZE || op==SQLITE_STATUS_PAGECACHE_SIZE || op==SQLITE_STATUS_PARSER_STACK );` |
| 最大値更新条件 | src/status.c | 126-128 | `if( newValue>wsdStat.mxValue[op] ){ wsdStat.mxValue[op] = newValue; }` |

### 7. sqlite3_status64関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 関数定義 | src/status.c | 134-158 | `int sqlite3_status64(int op, sqlite3_int64 *pCurrent, sqlite3_int64 *pHighwater, int resetFlag){...}` |
| 範囲チェック | src/status.c | 142-144 | `if( op<0 || op>=ArraySize(wsdStat.nowValue) ){ return SQLITE_MISUSE_BKPT; }` |
| API Armorチェック | src/status.c | 145-147 | `#ifdef SQLITE_ENABLE_API_ARMOR if( pCurrent==0 || pHighwater==0 ) return SQLITE_MISUSE_BKPT; #endif` |
| 現在値取得 | src/status.c | 150 | `*pCurrent = wsdStat.nowValue[op];` |
| 最大値取得 | src/status.c | 151 | `*pHighwater = wsdStat.mxValue[op];` |
| リセット処理 | src/status.c | 152-154 | `if( resetFlag ){ wsdStat.mxValue[op] = wsdStat.nowValue[op]; }` |

### 8. sqlite3_status関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 32ビット版ラッパー | src/status.c | 159-171 | `int sqlite3_status(int op, int *pCurrent, int *pHighwater, int resetFlag){...rc = sqlite3_status64(op, &iCur, &iHwtr, resetFlag);...}` |

### 9. countLookasideSlots関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 関数定義 | src/status.c | 176-183 | `static u32 countLookasideSlots(LookasideSlot *p){ u32 cnt = 0; while( p ){ p = p->pNext; cnt++; } return cnt; }` |

### 10. sqlite3LookasideUsed関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 関数定義 | src/status.c | 188-198 | `int sqlite3LookasideUsed(sqlite3 *db, int *pHighwater){...}` |
| Init/Freeスロットのカウント | src/status.c | 189-190 | `u32 nInit = countLookasideSlots(db->lookaside.pInit); u32 nFree = countLookasideSlots(db->lookaside.pFree);` |
| 使用中スロット計算 | src/status.c | 197 | `return (int)(db->lookaside.nSlot - (nInit+nFree));` |

### 11. sqlite3_db_status64関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 関数定義 | src/status.c | 203-421 | `int sqlite3_db_status64(sqlite3 *db, int op, sqlite3_int64 *pCurrent, sqlite3_int64 *pHighwtr, int resetFlag){...}` |
| db->mutex取得 | src/status.c | 216 | `sqlite3_mutex_enter(db->mutex);` |
| LOOKASIDE_USED処理 | src/status.c | 218-241 | `case SQLITE_DBSTATUS_LOOKASIDE_USED: {...}` |
| CACHE_USED処理 | src/status.c | 264-284 | `case SQLITE_DBSTATUS_CACHE_USED: {...}` |
| SCHEMA_USED処理 | src/status.c | 291-330 | `case SQLITE_DBSTATUS_SCHEMA_USED: {...}` |
| STMT_USED処理 | src/status.c | 337-354 | `case SQLITE_DBSTATUS_STMT_USED: {...}` |
| CACHE_HIT/MISS/WRITE処理 | src/status.c | 364-383 | `case SQLITE_DBSTATUS_CACHE_HIT: case SQLITE_DBSTATUS_CACHE_MISS: case SQLITE_DBSTATUS_CACHE_WRITE:{...}` |
| DEFERRED_FKS処理 | src/status.c | 409-413 | `case SQLITE_DBSTATUS_DEFERRED_FKS: { *pHighwtr = 0; *pCurrent = db->nDeferredImmCons>0 || db->nDeferredCons>0; break; }` |
| db->mutex解放 | src/status.c | 419 | `sqlite3_mutex_leave(db->mutex);` |

### 12. sqlite3_db_status関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 32ビット版ラッパー | src/status.c | 426-446 | `int sqlite3_db_status(sqlite3 *db, int op, int *pCurrent, int *pHighwtr, int resetFlag){...rc = sqlite3_db_status64(db, op, &C, &H, resetFlag);...}` |
| 32ビットマスク処理 | src/status.c | 442-443 | `*pCurrent = C & 0x7fffffff; *pHighwtr = H & 0x7fffffff;` |

## 根拠なし項目

なし

## 信頼度評価

- **claims_total**: 32
- **claims_with_evidence**: 32
- **claims_without_evidence**: 0
- **confidence_derived**: 32 / 32 = 1.00 (100%)

すべての主張についてソースコード内に明確な根拠が存在する。
