---
generated_at: 2026-01-21 12:15:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 48-ビットベクター

## 概要

本レポートは「機能設計書 48-ビットベクター」に記載された内容の根拠を示し、各主張がソースコードのどの部分に基づいているかを明確にする。

## 根拠一覧

### 1. 目的と用途に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| ジャーナルページ追跡用途 | src/bitvec.c | 15-16 | `A bitmap is used to record which pages of a database file have been journalled during a transaction, or which pages have the "dont-write" property.` |
| 疎/密の両方に対応 | src/bitvec.c | 17-22 | `Usually only a few pages are meet either condition. So the bitmap is usually sparse and has low cardinality. But sometimes... most or all of the pages in a database can get journalled.` |
| 1起点インデックス | src/bitvec.c | 13 | `Bits are numbered starting with 1.` |

### 2. コンパイル時定数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| BITVEC_SZ=512 | src/bitvec.c | 40 | `#define BITVEC_SZ        512` |
| BITVEC_USIZE計算 | src/bitvec.c | 44-45 | `#define BITVEC_USIZE (((BITVEC_SZ-(3*sizeof(u32)))/sizeof(Bitvec*))*sizeof(Bitvec*))` |
| BITVEC_TELEM=u8 | src/bitvec.c | 51 | `#define BITVEC_TELEM     u8` |
| BITVEC_SZELEM=8 | src/bitvec.c | 53 | `#define BITVEC_SZELEM    8` |
| BITVEC_NELEM計算 | src/bitvec.c | 55 | `#define BITVEC_NELEM     (BITVEC_USIZE/sizeof(BITVEC_TELEM))` |
| BITVEC_NBIT計算 | src/bitvec.c | 57 | `#define BITVEC_NBIT      (BITVEC_NELEM*BITVEC_SZELEM)` |
| BITVEC_NINT計算 | src/bitvec.c | 60 | `#define BITVEC_NINT      (BITVEC_USIZE/sizeof(u32))` |
| BITVEC_MXHASH計算 | src/bitvec.c | 63 | `#define BITVEC_MXHASH    (BITVEC_NINT/2)` |
| BITVEC_NPTR計算 | src/bitvec.c | 70 | `#define BITVEC_NPTR      ((u32)(BITVEC_USIZE/sizeof(Bitvec *)))` |

### 3. Bitvec構造体に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 構造体定義 | src/bitvec.c | 94-108 | `struct Bitvec { u32 iSize; u32 nSet; u32 iDivisor; union {...} u; };` |
| iSizeフィールド | src/bitvec.c | 95 | `u32 iSize;      /* Maximum bit index.  Max iSize is 4,294,967,296. */` |
| nSetフィールド | src/bitvec.c | 96-98 | `u32 nSet;       /* Number of bits that are set - only valid for aHash element.  Max is BITVEC_NINT. */` |
| iDivisorフィールド | src/bitvec.c | 99-102 | `u32 iDivisor;   /* Number of bits handled by each apSub[] entry. */` |
| aBitmap配列 | src/bitvec.c | 104 | `BITVEC_TELEM aBitmap[BITVEC_NELEM];    /* Bitmap representation */` |
| aHash配列 | src/bitvec.c | 105 | `u32 aHash[BITVEC_NINT];      /* Hash table representation */` |
| apSub配列 | src/bitvec.c | 106 | `Bitvec *apSub[BITVEC_NPTR];  /* Recursive representation */` |

### 4. 3種類の表現に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 表現選択の説明 | src/bitvec.c | 79-92 | `There are three possible representations of the bitmap. If iSize<=BITVEC_NBIT, then Bitvec.u.aBitmap[] is a straight bitmap...` |
| ビットマップ表現条件 | src/bitvec.c | 80-81 | `If iSize<=BITVEC_NBIT, then Bitvec.u.aBitmap[] is a straight bitmap.` |
| ハッシュ表現条件 | src/bitvec.c | 83-84 | `If iSize>BITVEC_NBIT and iDivisor==0 then Bitvec.u.aHash[] is a hash table that will hold up to BITVEC_MXHASH distinct values.` |
| サブビットマップ表現 | src/bitvec.c | 86-92 | `Otherwise, the value i is redirected into one of BITVEC_NPTR sub-bitmaps pointed to by Bitvec.u.apSub[].` |

### 5. sqlite3BitvecCreate関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 関数定義 | src/bitvec.c | 116-124 | `Bitvec *sqlite3BitvecCreate(u32 iSize){...}` |
| サイズアサート | src/bitvec.c | 118 | `assert( sizeof(*p)==BITVEC_SZ );` |
| MallocZeroで確保 | src/bitvec.c | 119 | `p = sqlite3MallocZero( sizeof(*p) );` |
| iSize設定 | src/bitvec.c | 121 | `p->iSize = iSize;` |

### 6. sqlite3BitvecTestNotNull関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 関数定義 | src/bitvec.c | 131-153 | `int sqlite3BitvecTestNotNull(Bitvec *p, u32 i){...}` |
| i--で0起点変換 | src/bitvec.c | 133 | `i--;` |
| 範囲チェック | src/bitvec.c | 134 | `if( i>=p->iSize ) return 0;` |
| サブビットマップ探索 | src/bitvec.c | 135-142 | `while( p->iDivisor ){ u32 bin = i/p->iDivisor; i = i%p->iDivisor; p = p->u.apSub[bin];...}` |
| ビットマップ表現テスト | src/bitvec.c | 143-144 | `if( p->iSize<=BITVEC_NBIT ){ return (p->u.aBitmap[i/BITVEC_SZELEM] & (1<<(i&(BITVEC_SZELEM-1))))!=0; }` |
| ハッシュ表現テスト | src/bitvec.c | 146-152 | `u32 h = BITVEC_HASH(i++); while( p->u.aHash[h] ){ if( p->u.aHash[h]==i ) return 1; h = (h+1) % BITVEC_NINT; }` |

### 7. sqlite3BitvecSet関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 関数定義 | src/bitvec.c | 170-235 | `int sqlite3BitvecSet(Bitvec *p, u32 i){...}` |
| NULLチェック | src/bitvec.c | 172 | `if( p==0 ) return SQLITE_OK;` |
| サブビットマップ作成 | src/bitvec.c | 176-184 | `while((p->iSize > BITVEC_NBIT) && p->iDivisor) {...p->u.apSub[bin] = sqlite3BitvecCreate( p->iDivisor );...}` |
| ビットマップ設定 | src/bitvec.c | 185-188 | `if( p->iSize<=BITVEC_NBIT ){ p->u.aBitmap[i/BITVEC_SZELEM] |= 1 << (i&(BITVEC_SZELEM-1)); return SQLITE_OK; }` |
| ハッシュ衝突処理 | src/bitvec.c | 202-206 | `do { if( p->u.aHash[h]==i ) return SQLITE_OK; h++; if( h>=BITVEC_NINT ) h = 0; } while( p->u.aHash[h] );` |
| リハッシュ条件 | src/bitvec.c | 211 | `if( p->nSet>=BITVEC_MXHASH ){` |
| リハッシュ処理 | src/bitvec.c | 214-228 | `memcpy(aiValues, p->u.aHash, sizeof(p->u.aHash)); memset(p->u.apSub, 0, sizeof(p->u.apSub)); p->iDivisor = p->iSize/BITVEC_NPTR;...` |

### 8. sqlite3BitvecClear関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 関数定義 | src/bitvec.c | 243-275 | `void sqlite3BitvecClear(Bitvec *p, u32 i, void *pBuf){...}` |
| 一時バッファ要件 | src/bitvec.c | 240-241 | `pBuf must be a pointer to at least BITVEC_SZ bytes of temporary storage that BitvecClear can use to rebuilt its hash table.` |
| ビットマップクリア | src/bitvec.c | 255-256 | `if( p->iSize<=BITVEC_NBIT ){ p->u.aBitmap[i/BITVEC_SZELEM] &= ~(BITVEC_TELEM)(1<<(i&(BITVEC_SZELEM-1))); }` |
| ハッシュ再構築 | src/bitvec.c | 258-273 | `memcpy(aiValues, p->u.aHash, sizeof(p->u.aHash)); memset(p->u.aHash, 0, sizeof(p->u.aHash)); p->nSet = 0;...` |

### 9. sqlite3BitvecDestroy関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 関数定義 | src/bitvec.c | 280-289 | `void sqlite3BitvecDestroy(Bitvec *p){...}` |
| サブビットマップ再帰解放 | src/bitvec.c | 282-287 | `if( p->iDivisor ){ unsigned int i; for(i=0; i<BITVEC_NPTR; i++){ sqlite3BitvecDestroy(p->u.apSub[i]); } }` |
| メモリ解放 | src/bitvec.c | 288 | `sqlite3_free(p);` |

### 10. ハッシュ関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| ハッシュ関数定義 | src/bitvec.c | 68 | `#define BITVEC_HASH(X)   (((X)*1)%BITVEC_NINT)` |
| *37が*1と同等というコメント | src/bitvec.c | 64-67 | `Empirical testing showed that the *37 multiplier (an arbitrary prime) in the hash function provided no fewer collisions than the no-op *1.` |

## 根拠なし項目

なし

## 信頼度評価

- **claims_total**: 35
- **claims_with_evidence**: 35
- **claims_without_evidence**: 0
- **confidence_derived**: 35 / 35 = 1.00 (100%)

すべての主張についてソースコード内に明確な根拠が存在する。
