---
generated_at: 2026-01-21 12:30:00
metrics:
  claims_total: 40
  claims_with_evidence: 40
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 49-各種ユーティリティ関数

## 概要

本レポートは「機能設計書 49-各種ユーティリティ関数」に記載された内容の根拠を示し、各主張がソースコードのどの部分に基づいているかを明確にする。

## 根拠一覧

### 1. 文字列操作に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3Strlen30の30ビット制限 | src/util.c | 84-95 | `Compute a string length that is limited to what can be stored in lower 30 bits of a 32-bit signed integer.` |
| 0x3fffffffマスク | src/util.c | 94 | `return 0x3fffffff & (int)strlen(z);` |
| NULLチェック | src/util.c | 93 | `if( z==0 ) return 0;` |
| sqlite3StrICmpの実装 | src/util.c | 416-434 | `int sqlite3StrICmp(const char *zLeft, const char *zRight){...}` |
| UpperToLowerテーブル使用 | src/util.c | 427 | `c = (int)UpperToLower[c] - (int)UpperToLower[x];` |
| sqlite3Dequoteの実装 | src/util.c | 298-319 | `void sqlite3Dequote(char *z){...}` |
| クォート文字判定 | src/util.c | 303 | `if( !sqlite3Isquote(quote) ) return;` |
| MS-Accessブラケット対応 | src/util.c | 304 | `if( quote=='[' ) quote = ']';` |

### 2. 数値変換に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3AtoFの戻り値説明 | src/util.c | 505-511 | `1 => The input string is a pure integer, 2 or more => The input has a decimal point or eNNN clause, 0 or less => The input string is not a valid number` |
| Dekker乗算の参照 | src/util.c | 461-465 | `Double-Double multiplication... Reference: T. J. Dekker, "A Floating-Point Technique for Extending the Available Precision". 1971-07-26.` |
| dekkerMul2関数 | src/util.c | 467-495 | `static void dekkerMul2(volatile double *x, double y, double yy){...}` |
| sqlite3Atoi64の戻り値説明 | src/util.c | 786-792 | `-1 Not even a prefix... 0 Successful transformation... 1 Excess non-space text... 2 Integer too large... 3 Special case` |
| compare2pow63関数 | src/util.c | 765-780 | `static int compare2pow63(const char *zNum, int incr){...const char *pow63 = "922337203685477580";...}` |
| sqlite3GetInt32の実装 | src/util.c | 935-988 | `int sqlite3GetInt32(const char *zNum, int *pValue){...}` |
| 16進数サポート | src/util.c | 946-962 | `else if( zNum[0]=='0' && (zNum[1]=='x' || zNum[1]=='X')...` |

### 3. 可変長整数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| Varintエンコーディング仕様 | src/util.c | 1158-1175 | `The variable-length integer encoding is as follows: KEY: A = 0xxxxxxx 7 bits... B = 1xxxxxxx 7 bits... C = xxxxxxxx 8 bits...` |
| 7〜64ビットの対応 | src/util.c | 1166-1174 | `7 bits - A, 14 bits - BA, ... 64 bits - BBBBBBBBC` |
| sqlite3PutVarint実装 | src/util.c | 1211-1222 | `int sqlite3PutVarint(unsigned char *p, u64 v){...}` |
| 1バイトケース | src/util.c | 1212-1215 | `if( v<=0x7f ){ p[0] = v&0x7f; return 1; }` |
| 2バイトケース | src/util.c | 1216-1220 | `if( v<=0x3fff ){ p[0] = ((v>>7)&0x7f)|0x80; p[1] = v&0x7f; return 2; }` |
| putVarint64の9バイトケース | src/util.c | 1190-1198 | `if( v & (((u64)0xff000000)<<32) ){ p[8] = (u8)v;...return 9; }` |
| sqlite3GetVarint実装 | src/util.c | 1241-1389 | `u8 sqlite3GetVarint(const unsigned char *p, u64 *v){...}` |
| 読み取り1バイトケース | src/util.c | 1244-1247 | `if( ((signed char*)p)[0]>=0 ){ *v = *p; return 1; }` |
| 読み取り2バイトケース | src/util.c | 1248-1251 | `if( ((signed char*)p)[1]>=0 ){ *v = ((u32)(p[0]&0x7f)<<7) | p[1]; return 2; }` |
| sqlite3VarintLen実装 | src/util.c | 1435-1439 | `int sqlite3VarintLen(u64 v){ int i; for(i=1; (v >>= 7)!=0; i++){ assert( i<10 ); } return i; }` |

### 4. バイトオーダー操作に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3Get4byte実装 | src/util.c | 1445-1462 | `u32 sqlite3Get4byte(const u8 *p){...}` |
| ビッグエンディアン最適化 | src/util.c | 1446-1449 | `#if SQLITE_BYTEORDER==4321 u32 x; memcpy(&x,p,4); return x;` |
| GCC bswap最適化 | src/util.c | 1450-1453 | `#elif SQLITE_BYTEORDER==1234 && GCC_VERSION>=4003000...return __builtin_bswap32(x);` |
| 汎用実装 | src/util.c | 1459-1460 | `return ((unsigned)p[0]<<24) | (p[1]<<16) | (p[2]<<8) | p[3];` |
| sqlite3Put4byte実装 | src/util.c | 1463-1478 | `void sqlite3Put4byte(unsigned char *p, u32 v){...}` |

### 5. エラー処理に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3Error実装 | src/util.c | 130-138 | `void sqlite3Error(sqlite3 *db, int err_code){...db->errCode = err_code;...}` |
| sqlite3ErrorMsg実装 | src/util.c | 242-266 | `void sqlite3ErrorMsg(Parse *pParse, const char *zFormat, ...){...}` |
| sqlite3VMPrintf使用 | src/util.c | 250 | `zMsg = sqlite3VMPrintf(db, zFormat, ap);` |
| sqlite3SafetyCheckOk実装 | src/util.c | 1547-1563 | `int sqlite3SafetyCheckOk(sqlite3 *db){...}` |
| NULLポインタチェック | src/util.c | 1549-1552 | `if( db==0 ){ logBadConnection("NULL"); return 0; }` |
| eOpenState検証 | src/util.c | 1554 | `if( eOpenState!=SQLITE_STATE_OPEN ){` |

### 6. オーバーフロー検出に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3AddInt64実装 | src/util.c | 1584-1603 | `int sqlite3AddInt64(i64 *pA, i64 iB){...}` |
| GCC組み込み関数使用 | src/util.c | 1585-1586 | `#if GCC_VERSION>=5004000 && !defined(__INTEL_COMPILER) return __builtin_add_overflow(*pA, iB, pA);` |
| オーバーフロー判定 | src/util.c | 1594 | `if( iA>0 && LARGEST_INT64 - iA < iB ) return 1;` |
| sqlite3MulInt64実装 | src/util.c | 1619-1639 | `int sqlite3MulInt64(i64 *pA, i64 iB){...}` |

### 7. その他の関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3IsNaN実装 | src/util.c | 57-68 | `int sqlite3IsNaN(double x){...}` |
| sqlite3HexToInt実装 | src/util.c | 1487-1496 | `u8 sqlite3HexToInt(int h){...h += 9*(1&(h>>6));...return (u8)(h & 0xf); }` |
| sqlite3HexToBlob実装 | src/util.c | 1505-1518 | `void *sqlite3HexToBlob(sqlite3 *db, const char *z, int n){...}` |
| sqlite3FaultSim実装 | src/util.c | 44-47 | `int sqlite3FaultSim(int iTest){ int (*xCallback)(int) = sqlite3GlobalConfig.xTestCallback; return xCallback ? xCallback(iTest) : SQLITE_OK; }` |

## 根拠なし項目

なし

## 信頼度評価

- **claims_total**: 40
- **claims_with_evidence**: 40
- **claims_without_evidence**: 0
- **confidence_derived**: 40 / 40 = 1.00 (100%)

すべての主張についてソースコード内に明確な根拠が存在する。
