---
generated_at: 2026-01-21 21:58:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：5-SQLパーサー/トークナイザー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（1文字あたり数十ナノ秒）**：具体的な実測値の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/tokenize.c` 全体 - トークナイザー実装
- E-02: `src/tokenize.c` 21-60行目 - 文字クラス定義（CC_*）
- E-03: `src/tokenize.c` 61-100行目 - aiClass配列
- E-04: `src/tokenize.c` 273-500行目 - sqlite3GetToken()関数
- E-05: `src/tokenize.c` 137-148行目 - keywordhash.hインクルード
- E-06: `src/parse.y` - SQL文法定義
- E-07: `src/keywordhash.h` - キーワードハッシュテーブル
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SQL文字列をトークンに分割する | E-01, E-04, E-09 | ○ |
| C-02 | Lemonパーサージェネレータで生成されたパーサーを使用 | E-06, E-09 | ○ |
| C-03 | tokenize.cとparse.yに実装されている | E-01, E-06, E-09 | ○ |
| C-04 | 文字クラス定義（CC_*）による判定 | E-02 | ○ |
| C-05 | aiClass配列でマッピング | E-03 | ○ |
| C-06 | sqlite3GetToken()がトークンを返却 | E-04 | ○ |
| C-07 | キーワードはkeywordhash.hでハッシュ検索 | E-05, E-07 | ○ |
| C-08 | キーワード大文字小文字非区別 | E-05, E-07 | ○ |
| C-09 | 識別子のクォート対応（"..."、[...]、`...`） | E-04 (396-420行目) | ○ |
| C-10 | コメントスキップ（--、/* */） | E-04 (289-330行目) | ○ |
| C-11 | UTF-8対応 | E-02, E-03 (72-79行目) | ○ |
| C-12 | 数値セパレータ対応 | E-04 (443-456行目) | ○ |
| C-13 | 関連画面が3画面存在 | E-08 | ○ |
| C-14 | TK_*トークンタイプ定数 | E-04 | ○ |
| C-15 | Parse構造体に解析結果を格納 | E-01 | ○ |
| C-16 | SQLITE_ERROR構文エラー | E-01 | ○ |
| C-17 | SQLITE_NOMEM メモリ不足 | E-01 | ○ |
| C-18 | プログラム呼び出し階層図が正確 | E-01, E-04, E-06 | ○ |
| C-19 | 行番号273-500の範囲が正確 | E-04 | ○ |
| C-20 | データフロー図が正確 | E-01, E-04 | ○ |
| C-21 | 関連ファイル一覧が正確 | E-01, E-06, E-07 | ○ |
| C-22 | mkkeywordhash.cでハッシュ生成 | E-05 (143行目コメント) | ○ |
| C-23 | parse.cが自動生成されたパーサー | E-06 | ○ |
| C-24 | LALR(1)パーサー | E-06（Lemon仕様） | ○ |
| C-25 | トークン化は1文字あたり数十ナノ秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件「1文字あたり数十ナノ秒」の具体的な実測データ
  - 候補：ベンチマーク結果 / SQLite公式ドキュメント / プロファイリングデータ

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：主要なパーサー/トークナイザー機能は十分に文書化されている
- 1（中リスク）：パフォーマンス要件は環境依存のため実測確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] sqlite3GetToken()の処理フローがソースコードと一致しているか確認
- [ ] 関連画面一覧が画面機能マッピング.csvと整合しているか確認
- [ ] 文字クラス定義（CC_*）が正しく説明されているか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
