---
generated_at: 2026-01-21 12:45:00
metrics:
  claims_total: 42
  claims_with_evidence: 42
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 50-printf実装

## 概要

本レポートは「機能設計書 50-printf実装」に記載された内容の根拠を示し、各主張がソースコードのどの部分に基づいているかを明確にする。

## 根拠一覧

### 1. コードの由来に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 1980年代のパブリックドメインコード | src/printf.c | 2-3 | `The "printf" code that follows dates from the 1980's. It is in the public domain.` |

### 2. 変換タイプ定数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| etRADIX定義 | src/printf.c | 18 | `#define etRADIX       0 /* non-decimal integer types.  %x %o */` |
| etFLOAT定義 | src/printf.c | 19 | `#define etFLOAT       1 /* Floating point.  %f */` |
| etEXP定義 | src/printf.c | 20 | `#define etEXP         2 /* Exponentional notation. %e and %E */` |
| etGENERIC定義 | src/printf.c | 21 | `#define etGENERIC     3 /* Floating or exponential, depending on exponent. %g */` |
| etSTRING定義 | src/printf.c | 23 | `#define etSTRING      5 /* Strings. %s */` |
| etDYNSTRING定義 | src/printf.c | 24 | `#define etDYNSTRING   6 /* Dynamically allocated strings. %z */` |
| etESCAPE_q定義 | src/printf.c | 28 | `#define etESCAPE_q    9  /* Strings with '\'' doubled.  %q */` |
| etESCAPE_Q定義 | src/printf.c | 29-30 | `#define etESCAPE_Q    10 /* Strings with '\'' doubled and enclosed in '', NULL pointers replaced by SQL NULL.  %Q */` |
| etTOKEN定義 | src/printf.c | 31 | `#define etTOKEN       11 /* a pointer to a Token structure */` |
| etSRCITEM定義 | src/printf.c | 32 | `#define etSRCITEM     12 /* a pointer to a SrcItem */` |
| etESCAPE_w定義 | src/printf.c | 34 | `#define etESCAPE_w    14 /* %w -> Strings with '\"' doubled */` |
| etORDINAL定義 | src/printf.c | 35 | `#define etORDINAL     15 /* %r -> 1st, 2nd, 3rd, 4th, etc.  English only */` |
| etDECIMAL定義 | src/printf.c | 36 | `#define etDECIMAL     16 /* %d or %u, but not %x, %o */` |

### 3. et_info構造体に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 構造体定義 | src/printf.c | 50-58 | `typedef struct et_info { char fmttype; etByte base; etByte flags; etByte type; etByte charset; etByte prefix; char iNxt; } et_info;` |

### 4. fmtinfo配列に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| 配列定義 | src/printf.c | 94-118 | `static const et_info fmtinfo[23] = {...}` |
| ハッシュテーブル構造 | src/printf.c | 67-68 | `The table is searched by hash. In the case of %C where C is the character and that character has ASCII value j, then the hash is j%23.` |

### 5. StrAccum関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3StrAccumInit関数 | src/printf.c | 1284-1292 | `void sqlite3StrAccumInit(StrAccum *p, sqlite3 *db, char *zBase, int n, int mx){...}` |
| sqlite3StrAccumEnlarge関数 | src/printf.c | 1054-1099 | `int sqlite3StrAccumEnlarge(StrAccum *p, i64 N){...}` |
| 指数バッファ成長 | src/printf.c | 1068-1072 | `if( szNew+p->nChar<=p->mxAlloc ){ /* Force exponential buffer size growth... */ szNew += p->nChar; }` |
| sqlite3_str_append関数 | src/printf.c | 1132-1144 | `void sqlite3_str_append(sqlite3_str *p, const char *z, int N){...}` |
| sqlite3StrAccumFinish関数 | src/printf.c | 1172-1180 | `char *sqlite3StrAccumFinish(StrAccum *p){...}` |
| sqlite3_str_reset関数 | src/printf.c | 1249-1257 | `void sqlite3_str_reset(StrAccum *p){...}` |

### 6. メインフォーマット関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3_str_vappendf関数 | src/printf.c | 194-1006 | `void sqlite3_str_vappendf(sqlite3_str *pAccum, const char *fmt, va_list ap){...}` |
| %以外の直接出力 | src/printf.c | 242-253 | `if( c!='%' ){ bufpt = (char *)fmt;...sqlite3_str_append(pAccum, bufpt, (int)(fmt - bufpt));...}` |
| フラグ解析 | src/printf.c | 266-275 | `switch( c ){ case '-': flag_leftjustify = 1; break; case '+': flag_prefix = '+'; break;...}` |
| 幅解析 | src/printf.c | 286-304 | `case '1': case '2':...width = wx & 0x7fffffff;...` |
| 精度解析 | src/printf.c | 327-358 | `case '.': c = *++fmt; if( c=='*' ){...precision = (int)getIntArg(pArgList);...}` |
| ハッシュ検索（ASCII） | src/printf.c | 377-389 | `assert( ArraySize(fmtinfo)==23 ); idx = ((unsigned)c) % 23; if( fmtinfo[idx].fmttype==c...` |

### 7. 型別変換処理に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| etDECIMAL処理 | src/printf.c | 419-525 | `case etDECIMAL:...longvalue = va_arg(ap,int);...` |
| 基数変換ループ | src/printf.c | 493-496 | `do{ *(--bufpt) = cset[longvalue%base]; longvalue = longvalue/base; }while( longvalue>0 );` |
| etFLOAT処理 | src/printf.c | 526-708 | `case etFLOAT: case etEXP: case etGENERIC: {...}` |
| sqlite3FpDecode呼び出し | src/printf.c | 552 | `sqlite3FpDecode(&s, realvalue, iRound, flag_altform2 ? 26 : 16);` |
| etSTRING処理 | src/printf.c | 764-815 | `case etSTRING: case etDYNSTRING:...bufpt = va_arg(ap,char*);...` |
| etESCAPE処理 | src/printf.c | 816-923 | `case etESCAPE_q: case etESCAPE_Q: case etESCAPE_w: {...}` |
| NULL時の処理 | src/printf.c | 830-831 | `if( escarg==0 ){ escarg = (xtype==etESCAPE_Q ? "NULL" : "(NULL)"); }` |
| %T, %S内部専用チェック | src/printf.c | 925 | `if( (pAccum->printfFlags & SQLITE_PRINTF_INTERNAL)==0 ) return;` |

### 8. 公開API関数に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3_mprintf関数 | src/printf.c | 1367-1377 | `char *sqlite3_mprintf(const char *zFormat, ...){...z = sqlite3_vmprintf(zFormat, ap);...}` |
| sqlite3_snprintf関数 | src/printf.c | 1407-1424 | `char *sqlite3_snprintf(int n, char *zBuf, const char *zFormat, ...){...}` |
| sqlite3VMPrintf関数 | src/printf.c | 1310-1324 | `char *sqlite3VMPrintf(sqlite3 *db, const char *zFormat, va_list ap){...}` |
| SQLITE_PRINTF_INTERNAL設定 | src/printf.c | 1317 | `acc.printfFlags = SQLITE_PRINTF_INTERNAL;` |

### 9. エラー処理に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3StrAccumSetError関数 | src/printf.c | 129-134 | `void sqlite3StrAccumSetError(StrAccum *p, u8 eError){ assert( eError==SQLITE_NOMEM || eError==SQLITE_TOOBIG ); p->accError = eError;...}` |
| SQLITE_TOOBIG設定 | src/printf.c | 164-166 | `if( n>pAccum->nAlloc && n>pAccum->mxAlloc ){ sqlite3StrAccumSetError(pAccum, SQLITE_TOOBIG);...}` |
| SQLITE_NOMEM設定 | src/printf.c | 169-171 | `if( z==0 ){ sqlite3StrAccumSetError(pAccum, SQLITE_NOMEM); }` |

### 10. バッファサイズに関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| SQLITE_PRINT_BUF_SIZE=70 | src/printf.c | 179-181 | `#ifndef SQLITE_PRINT_BUF_SIZE # define SQLITE_PRINT_BUF_SIZE 70 #endif` |
| 精度制限 | src/printf.c | 187-189 | `#ifndef SQLITE_PRINTF_PRECISION_LIMIT # define SQLITE_FP_PRECISION_LIMIT 100000000 #endif` |

### 11. 参照カウント文字列に関する根拠

| 主張 | 根拠ファイル | 該当行 | 根拠コード/コメント |
|------|-------------|--------|-------------------|
| sqlite3RCStrRef関数 | src/printf.c | 1520-1526 | `char *sqlite3RCStrRef(char *z){ RCStr *p = (RCStr*)z;...p->nRCRef++;...}` |
| sqlite3RCStrUnref関数 | src/printf.c | 1532-1542 | `void sqlite3RCStrUnref(void *z){...if( p->nRCRef>=2 ){ p->nRCRef--; }else{ sqlite3_free(p); }...}` |
| sqlite3RCStrNew関数 | src/printf.c | 1553-1558 | `char *sqlite3RCStrNew(u64 N){ RCStr *p = sqlite3_malloc64( N + sizeof(*p) + 1 );...p->nRCRef = 1;...}` |

## 根拠なし項目

なし

## 信頼度評価

- **claims_total**: 42
- **claims_with_evidence**: 42
- **claims_without_evidence**: 0
- **confidence_derived**: 42 / 42 = 1.00 (100%)

すべての主張についてソースコード内に明確な根拠が存在する。
