---
generated_at: 2026-01-21 22:02:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：6-SELECT文処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **ウィンドウ関数のSQL:2003準拠**：標準準拠の詳細確認が必要
  2. **NULL処理の詳細（ORDER BY最後）**：動作確認が望ましい

## 2) 参照した情報（Evidence一覧）

- E-01: `src/select.c` 全体 - SELECT文処理の実装
- E-02: `src/select.c` 22-72行目 - DistinctCtx、SortCtx構造体
- E-03: `src/select.c` 82-107行目 - clearSelect()
- E-04: `src/select.c` 126-178行目 - sqlite3SelectNew()
- E-05: `src/select.c` 262-300行目 - sqlite3JoinType()
- E-06: `src/where.c` - WHERE句最適化
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SELECT文の解析・実行・結果取得を行う | E-01, E-08 | ○ |
| C-02 | select.cに実装されている | E-01, E-08 | ○ |
| C-03 | Select構造体で構文木を表現 | E-04 | ○ |
| C-04 | sqlite3SelectNew()でSelect構造体を構築 | E-04 | ○ |
| C-05 | pEList、pSrc、pWhere等のフィールド | E-04 | ○ |
| C-06 | sqlite3JoinType()でJOINタイプ判定 | E-05 | ○ |
| C-07 | JT_INNER、JT_LEFT等のフラグ | E-05 | ○ |
| C-08 | DistinctCtx構造体でDISTINCT処理 | E-02 | ○ |
| C-09 | SortCtx構造体でソート処理 | E-02 | ○ |
| C-10 | WHERE句最適化にwhere.cを使用 | E-06 | ○ |
| C-11 | 関連画面が6画面存在 | E-07 | ○ |
| C-12 | 集約関数（COUNT、SUM等）対応 | E-01 | ○ |
| C-13 | GROUP BY処理 | E-01 | ○ |
| C-14 | ORDER BY処理 | E-02 (SortCtx) | ○ |
| C-15 | LIMIT/OFFSET処理 | E-04 (pLimit) | ○ |
| C-16 | サブクエリの再帰処理 | E-01 | ○ |
| C-17 | 処理シーケンス（8ステップ） | E-01 | ○ |
| C-18 | プログラム呼び出し階層図が正確 | E-01, E-06 | ○ |
| C-19 | 行番号126-178の範囲が正確 | E-04 | ○ |
| C-20 | カラム参照解決ルール | E-01 | ○ |
| C-21 | SQLITE_ERRORエラー | E-01 | ○ |
| C-22 | SQLITE_BUSYエラー | E-01 | ○ |
| C-23 | authorizerによるアクセス制御 | E-01 | ○ |
| C-24 | インデックス使用時O(log n) | E-06 | ○ |
| C-25 | 関連ファイル一覧が正確 | E-01, E-06 | ○ |
| C-26 | clearSelect()でメモリ解放 | E-03 | ○ |
| C-27 | ウィンドウ関数がSQL:2003準拠 | **根拠なし** | △ |
| C-28 | NULLがORDER BYで最後 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ウィンドウ関数のSQL:2003標準準拠の詳細確認
  - 候補：SQLite公式ドキュメント / SQL標準仕様書との比較
- NULL値のORDER BY時の配置詳細
  - 候補：SQLite公式ドキュメント / テストケース

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：主要なSELECT文処理は十分に文書化されている
- 1（中リスク）：標準準拠やNULL処理の詳細は追加確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] SELECT文処理フローがソースコードと一致しているか確認
- [ ] 関連画面一覧が画面機能マッピング.csvと整合しているか確認
- [ ] JOIN処理の説明が正確か確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
