---
generated_at: 2026-01-21 22:05:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：7-INSERT文処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（単一行挿入は数ミリ秒以内）**：具体的な実測値の根拠なし
  2. **UPSERT（ON CONFLICT DO UPDATE）の詳細**：詳細実装の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/insert.c` 全体 - INSERT文処理の実装
- E-02: `src/insert.c` 26-53行目 - sqlite3OpenTable()
- E-03: `src/insert.c` 75-114行目 - sqlite3IndexAffinityStr()
- E-04: `src/insert.c` 179-224行目 - sqlite3TableAffinity()
- E-05: `src/fkey.c` - 外部キー制約処理
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | INSERT文によるデータ挿入処理 | E-01, E-07 | ○ |
| C-02 | insert.cに実装されている | E-01, E-07 | ○ |
| C-03 | sqlite3OpenTable()でテーブルオープン | E-02 | ○ |
| C-04 | テーブルロックとカーソルオープン | E-02 | ○ |
| C-05 | sqlite3TableAffinity()でアフィニティ適用 | E-04 | ○ |
| C-06 | STRICTテーブルでOP_TypeCheck | E-04 (179-203行目) | ○ |
| C-07 | 通常テーブルでOP_Affinity | E-04 (204-224行目) | ○ |
| C-08 | 関連画面が6画面存在 | E-06 | ○ |
| C-09 | ON CONFLICT処理（ABORT等） | E-01 | ○ |
| C-10 | 外部キー制約処理 | E-05 | ○ |
| C-11 | ROWID自動生成 | E-01 | ○ |
| C-12 | デフォルト値適用 | E-01 | ○ |
| C-13 | autoincrement処理 | E-01 | ○ |
| C-14 | 処理シーケンス（9ステップ） | E-01 | ○ |
| C-15 | プログラム呼び出し階層図が正確 | E-01, E-02, E-04 | ○ |
| C-16 | 行番号26-53、179-224の範囲が正確 | E-02, E-04 | ○ |
| C-17 | SQLITE_CONSTRAINTエラー | E-01 | ○ |
| C-18 | SQLITE_CONSTRAINT_FOREIGNKEY | E-05 | ○ |
| C-19 | SQLITE_MISMATCHエラー | E-04 | ○ |
| C-20 | SQLITE_FULLエラー | E-01 | ○ |
| C-21 | REPLACEはINSERT OR REPLACEの省略形 | E-01 | ○ |
| C-22 | RETURNING句対応 | E-01 | ○ |
| C-23 | 生成列（GENERATED COLUMNS）対応 | E-01 | ○ |
| C-24 | OP_Insert、OP_IdxInsertの使用 | E-01 | ○ |
| C-25 | 関連ファイル一覧が正確 | E-01, E-05 | ○ |
| C-26 | authorizerによる許可制御 | E-01 | ○ |
| C-27 | 単一行挿入は数ミリ秒以内 | **根拠なし** | △ |
| C-28 | UPSERTの詳細動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件「単一行挿入は数ミリ秒以内」の具体的な実測データ
  - 候補：ベンチマーク結果 / SQLite公式ドキュメント
- UPSERTの詳細実装確認
  - 候補：insert.cのON CONFLICT DO UPDATE処理部分

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：主要なINSERT処理は十分に文書化されている
- 1（中リスク）：パフォーマンス要件は環境依存のため実測確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] INSERT文処理フローがソースコードと一致しているか確認
- [ ] 関連画面一覧が画面機能マッピング.csvと整合しているか確認
- [ ] ON CONFLICT処理の説明が正確か確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
