---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 21
  claims_with_evidence: 21
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：21 / 21、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/wasm/index.html` - WASMテストページインデックス
- E-02: `ext/wasm/index-dist.html` - 配布用インデックス（Globで検出）
- E-03: `ext/wasm/demo-123.html` - 基本デモ（UIスレッド版）
- E-04: `ext/wasm/demo-123-worker.html` - 基本デモ（Worker版）
- E-05: `ext/wasm/demo-jsstorage.html` - JS Storageデモ
- E-06: `ext/wasm/demo-worker1.html` - Worker1 APIデモ
- E-07: `ext/wasm/demo-worker1-promiser.c-pp.html` - Worker1 Promiserデモ
- E-08: `ext/wasm/fiddle/index.c-pp.html` - SQLite3 Fiddle
- E-09: `ext/wasm/speedtest1.html` - Speedtest1（メインスレッド版）
- E-10: `ext/wasm/speedtest1-worker.html` - Speedtest1（Worker版）
- E-11: `ext/wasm/speedtest1-wasmfs.html` - Speedtest1（WASMFS版）
- E-12: `ext/wasm/tester1.c-pp.html` - Tester1（メインスレッド版）
- E-13: `ext/wasm/tester1-worker.c-pp.html` - Tester1（Worker版）
- E-14: `ext/wasm/test-opfs-vfs.html` - OPFS VFSテスト
- E-15: `ext/wasm/tests/opfs/concurrency/index.html` - OPFS並行性テスト
- E-16: `ext/wasm/tests/opfs/sahpool/index.html` - OPFS SAHPoolテスト
- E-17: `ext/wasm/tests/opfs/sahpool/digest.html` - OPFS SAHPool Digest（Globで検出）
- E-18: `ext/wasm/SQLTester/index.html` - SQLTester
- E-19: `ext/wasm/module-symbols.html` - モジュールシンボル一覧
- E-20: `ext/wasm/scratchpad-wasmfs.html` - WASMFS Scratchpad
- E-21: `doc/lemon.html` - Lemonパーサージェネレータドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WASMテストページインデックスが存在する | E-01 | ○ |
| C-02 | 配布用インデックスが存在する | E-02 | ○ |
| C-03 | 基本デモ（UIスレッド版）はsqlite3をWebページのUIスレッドで動作させる | E-03 | ○ |
| C-04 | 基本デモ（Worker版）はsqlite3をWorkerスレッドで動作させる | E-04 | ○ |
| C-05 | JS Storageデモはlocalstorageを使用したkvvfs VFSのデモ | E-05 | ○ |
| C-06 | Worker1 APIデモはWorker-based wrapperのテスト | E-06 | ○ |
| C-07 | Worker1 PromiserデモはPromiseベースラッパーのデモ | E-07 | ○ |
| C-08 | SQLite3 FiddleはWebAssembly版SQLite CLIシェルのフロントエンド | E-08 | ○ |
| C-09 | Speedtest1（メインスレッド版）はベンチマークツール | E-09 | ○ |
| C-10 | Speedtest1（Worker版）は対話的実行可能なベンチマークツール | E-10 | ○ |
| C-11 | Speedtest1（WASMFS版）はWASMFS/OPFS永続化対応 | E-11 | ○ |
| C-12 | Tester1はAPIの単体・回帰テストを実行 | E-12 | ○ |
| C-13 | Tester1（Worker版）はWorkerスレッドでテスト実行 | E-13 | ○ |
| C-14 | OPFS VFSテストはsqlite3_vfsのサニティテスト | E-14 | ○ |
| C-15 | OPFS並行性テストは複数Workerを使用 | E-15 | ○ |
| C-16 | OPFS SAHPoolテストはpause機能のデモ | E-16 | ○ |
| C-17 | OPFS SAHPool Digestが存在する | E-17 | ○ |
| C-18 | SQLTesterはテストスクリプト実行ページ | E-18 | ○ |
| C-19 | モジュールシンボル一覧はAPIシンボルを動的生成で表示 | E-19 | ○ |
| C-20 | WASMFS Scratchpadは実験・スクラッチパッドページ | E-20 | ○ |
| C-21 | Lemonパーサージェネレータのドキュメントが存在する | E-21 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- index.htmlの記載に基づいて画面一覧を作成しているため、網羅性は高い

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての画面情報はソースコードから直接抽出

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧のカテゴリ分類が適切か確認
- [ ] 各画面の説明が正確か、HTMLファイルの内容と照合
- [ ] 画面遷移図のリンク関係がindex.htmlの記載と一致しているか確認
- [ ] 32-bit/64-bit版、ESM版などのバリエーションが適切に記載されているか確認
