# 画面遷移図

本ドキュメントはSQLite WASMプロジェクトの画面遷移を示します。

## 全体構成

```mermaid
flowchart TB
    subgraph Index["インデックス"]
        INDEX[WASM テストページインデックス<br/>index.html]
        INDEX_DIST[WASM 配布用インデックス<br/>index-dist.html]
    end

    subgraph Demo["デモ"]
        DEMO123[基本デモ UIスレッド版<br/>demo-123.html]
        DEMO123W[基本デモ Worker版<br/>demo-123-worker.html]
        DEMOSTORAGE[JS Storage デモ<br/>demo-jsstorage.html]
        DEMOWORKER1[Worker1 API デモ<br/>demo-worker1.html]
        DEMOPROMISER[Worker1 Promiser デモ<br/>demo-worker1-promiser.html]
    end

    subgraph App["アプリケーション"]
        FIDDLE[SQLite3 Fiddle<br/>fiddle/index.html]
    end

    subgraph Benchmark["ベンチマーク"]
        SPEED1[Speedtest1 メインスレッド版<br/>speedtest1.html]
        SPEED1W[Speedtest1 Worker版<br/>speedtest1-worker.html]
        SPEED1WASMFS[Speedtest1 WASMFS版<br/>speedtest1-wasmfs.html]
    end

    subgraph Test["テスト"]
        TESTER1[Tester1 メインスレッド版<br/>tester1.html]
        TESTER1W[Tester1 Worker版<br/>tester1-worker.html]
        OPFSTEST[OPFS VFS テスト<br/>test-opfs-vfs.html]
        OPFSCONCUR[OPFS 並行性テスト<br/>tests/opfs/concurrency/]
        OPFSSAHPOOL[OPFS SAHPool テスト<br/>tests/opfs/sahpool/]
        SQLTESTER[SQLTester<br/>SQLTester/index.html]
    end

    subgraph Utility["ユーティリティ"]
        SYMBOLS[モジュールシンボル一覧<br/>module-symbols.html]
    end

    subgraph Experiment["実験"]
        SCRATCHPAD[WASMFS Scratchpad<br/>scratchpad-wasmfs.html]
    end

    INDEX --> DEMO123
    INDEX --> DEMO123W
    INDEX --> DEMOSTORAGE
    INDEX --> DEMOWORKER1
    INDEX --> DEMOPROMISER
    INDEX --> FIDDLE
    INDEX --> SPEED1
    INDEX --> SPEED1W
    INDEX --> TESTER1
    INDEX --> TESTER1W
    INDEX --> OPFSTEST
    INDEX --> OPFSCONCUR
    INDEX --> OPFSSAHPOOL
    INDEX --> SQLTESTER
    INDEX --> SYMBOLS
    INDEX --> SCRATCHPAD
    INDEX --> SPEED1WASMFS

    SPEED1 <--> SPEED1W
    TESTER1 <--> TESTER1W
```

## インデックスページからの遷移

```mermaid
flowchart LR
    INDEX[index.html] --> |Core tests| TESTER1[tester1.html]
    INDEX --> |Core tests ESM| TESTER1ESM[tester1-esm.html]
    INDEX --> |Core tests Worker| TESTER1W[tester1-worker.html]
    INDEX --> |High-level app| FIDDLE[fiddle/index.html]
    INDEX --> |Demo| DEMO123[demo-123.html]
    INDEX --> |Demo Worker| DEMO123W[demo-123-worker.html]
    INDEX --> |JS Storage| DEMOSTORAGE[demo-jsstorage.html]
    INDEX --> |Worker1 API| DEMOWORKER1[demo-worker1.html]
    INDEX --> |Worker1 Promiser| DEMOPROMISER[demo-worker1-promiser.html]
    INDEX --> |Benchmark| SPEED1[speedtest1.html]
    INDEX --> |Benchmark Worker| SPEED1W[speedtest1-worker.html]
    INDEX --> |Symbols| SYMBOLS[module-symbols.html]
    INDEX --> |OPFS Test| OPFSTEST[test-opfs-vfs.html]
    INDEX --> |OPFS Concurrency| OPFSCONCUR[tests/opfs/concurrency/]
    INDEX --> |SAHPool| OPFSSAHPOOL[tests/opfs/sahpool/]
    INDEX --> |SQLTester| SQLTESTER[SQLTester/index.html]
    INDEX --> |WASMFS| SCRATCHPAD[scratchpad-wasmfs.html]
```

## ベンチマーク間の遷移

```mermaid
flowchart LR
    SPEED1[speedtest1.html<br/>メインスレッド版] <--> |切り替え| SPEED1W[speedtest1-worker.html<br/>Worker版]
    SPEED1W --> |リンク| SPEED1MAIN[speedtest1.html<br/>選択フラグ付き]
    SPEED1W --> |リンク| SPEED1KVVFS[speedtest1.html?vfs=kvvfs<br/>KVVFS版]
```

## テスター間の遷移

```mermaid
flowchart TB
    subgraph Tester1Variants["Tester1 バリエーション"]
        T1_32[tester1.html<br/>32-bit]
        T1_64[tester1-64bit.html<br/>64-bit]
        T1_ESM_32[tester1-esm.html<br/>ESM 32-bit]
        T1_ESM_64[tester1-esm-64bit.html<br/>ESM 64-bit]
        T1_W_32[tester1-worker.html<br/>Worker 32-bit]
        T1_W_64[tester1-worker-64bit.html<br/>Worker 64-bit]
        T1_W_ESM_32[tester1-worker.html?esm<br/>Worker ESM 32-bit]
        T1_W_ESM_64[tester1-worker-64bit.html?esm<br/>Worker ESM 64-bit]
    end

    T1_32 <--> T1_64
    T1_ESM_32 <--> T1_ESM_64
    T1_W_32 <--> T1_W_64
    T1_W_ESM_32 <--> T1_W_ESM_64
    T1_32 <--> T1_ESM_32
    T1_32 <--> T1_W_32
    T1_32 <--> T1_W_ESM_32
```

## SQLite3 Fiddle 画面構成

```mermaid
flowchart TB
    subgraph FiddleApp["SQLite3 Fiddle"]
        HEADER[ヘッダー<br/>タイトルバー]
        INPUT[入力エリア<br/>SQL入力テキストエリア]
        OUTPUT[出力エリア<br/>実行結果表示]
        OPTIONS[オプション<br/>Load DB / Download DB / Reset DB]
        ABOUT[About画面<br/>アプリケーション説明]
    end

    HEADER --> INPUT
    INPUT --> |Run| OUTPUT
    OPTIONS --> |Load DB| INPUT
    OUTPUT --> |Download DB| OPTIONS
    OPTIONS --> |About| ABOUT
    ABOUT --> |close| OPTIONS
```

## 備考

- 多くのページはHTTPサーバー経由でのアクセスが必要（WASMファイルのロードにfile://は使用不可）
- OPFS関連のテストはCOOP/COEPヘッダーを出力するサーバーが必要
- 32-bit版と64-bit版のWASMビルドが存在し、ページ間で切り替え可能
- ESMモジュール版とconventional版の両方が提供されている
