---
generated_at: 2026-01-21 12:00:00
metrics:
  claims_total: 80
  claims_with_evidence: 76
  claims_without_evidence: 4
confidence_derived: 0.95
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：76 / 80、根拠なし：4
- 優先レビュー（高）
  1. **WASM 配布用インデックス（画面No.2）**：HTMLファイル内容未確認
  2. **OPFS SAHPool Digest（画面No.17）**：詳細実装未確認
  3. **Lemonパーサージェネレータ（画面No.21）**：ドキュメントページのため機能との関連が間接的

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `ext/wasm/index.html`
- E-04: `ext/wasm/demo-123.html`
- E-05: `ext/wasm/demo-123.js`
- E-06: `ext/wasm/fiddle/index.c-pp.html`
- E-07: `ext/wasm/speedtest1-worker.html`
- E-08: `ext/wasm/tester1.c-pp.html`
- E-09: `ext/wasm/demo-jsstorage.html`
- E-10: `ext/wasm/test-opfs-vfs.html`
- E-11: `ext/wasm/module-symbols.html`
- E-12: `ext/wasm/tests/opfs/concurrency/index.html`
- E-13: `.claude/skills/code-to-docs-screen-function-mapping/specification/画面機能マッピング.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.1「WASM テストページインデックス」は機能No.1「SQLiteライブラリ初期化」を主機能として使用 | E-03: index.htmlでsqlite3 WASMビルドのテストページ一覧を提供 | ○ |
| C-02 | 画面No.1は機能No.3「バージョン情報取得」を補助機能として使用 | E-03: テストページ一覧でバージョン情報確認可能 | ○ |
| C-03 | 画面No.2「WASM 配布用インデックス」は機能No.1を使用 | E-01: 画面一覧に記載あり | △ |
| C-04 | 画面No.3「基本デモ（UIスレッド版）」は機能No.1を主機能として使用 | E-04, E-05: demo-123.htmlでsqlite3.jsを読み込み、sqlite3InitModule()を呼び出し | ○ |
| C-05 | 画面No.3は機能No.2「データベース接続管理」を主機能として使用 | E-05: new oo.DB("/mydb.sqlite3",'ct')でDB作成 | ○ |
| C-06 | 画面No.3は機能No.3「バージョン情報取得」を補助機能として使用 | E-05: capi.sqlite3_libversion(), capi.sqlite3_sourceid()を呼び出し | ○ |
| C-07 | 画面No.3は機能No.10「CREATE TABLE処理」を主機能として使用 | E-05: db.exec("CREATE TABLE IF NOT EXISTS t(a,b)")を実行 | ○ |
| C-08 | 画面No.3は機能No.7「INSERT文処理」を主機能として使用 | E-05: db.exec()でINSERT文を実行（バインドパラメータ付き） | ○ |
| C-09 | 画面No.3は機能No.6「SELECT文処理」を主機能として使用 | E-05: db.exec()でSELECT文を実行しコールバックで結果処理 | ○ |
| C-10 | 画面No.3は機能No.15「トランザクション管理」を補助機能として使用 | E-05: db.transaction()、db.savepoint()を呼び出し | ○ |
| C-11 | 画面No.3は機能No.28「組み込みSQL関数」を補助機能として使用 | E-05: db.createFunction()でUDF「twice」を作成 | ○ |
| C-12 | 画面No.4「基本デモ（Worker版）」は機能No.1を主機能として使用 | E-01, E-05: demo-123-worker.htmlはdemo-123.jsをWorkerとして実行 | ○ |
| C-13 | 画面No.5「JS Storage デモ」は機能No.43「OS抽象化層（VFS）」を主機能として使用 | E-09: kvvfs VFSを使用してlocalStorage/sessionStorageに永続化 | ○ |
| C-14 | 画面No.6「Worker1 API デモ」は機能No.1を主機能として使用 | E-03: Worker-based wrapper of the OO API #1のテストページ | ○ |
| C-15 | 画面No.7「Worker1 Promiser デモ」は機能No.1を主機能として使用 | E-03: Promise-based wrapperのデモ | ○ |
| C-16 | 画面No.8「SQLite3 Fiddle」は機能No.1を主機能として使用 | E-06: fiddle.jsを読み込みWASM CLIシェルを初期化 | ○ |
| C-17 | 画面No.8は機能No.5「SQLパーサー/トークナイザー」を主機能として使用 | E-06: SQL入力フィールドからユーザー入力SQLを解析・実行 | ○ |
| C-18 | 画面No.8は機能No.6,7,8,9,10,11「各種SQL処理」を主機能として使用 | E-06: SQLクエリ入力・実行・結果表示機能を提供 | ○ |
| C-19 | 画面No.8は機能No.26「PRAGMA」を補助機能として使用 | E-06: .nullvalue NULL、.headers on等のシェルコマンド対応 | ○ |
| C-20 | 画面No.8は機能No.43「OS抽象化層（VFS）」を補助機能として使用 | E-06: DB import/export機能（Load DB、Download DBボタン） | ○ |
| C-21 | 画面No.9「Speedtest1（メインスレッド版）」は機能No.17「VDBE」を主機能として使用 | E-03: speedtest1.htmlはベンチマークツールでVDBE実行を計測 | ○ |
| C-22 | 画面No.10「Speedtest1（Worker版）」は機能No.43を補助機能として使用 | E-07: VFS選択UI（memdb/kvvfs/opfs/opfs-sahpool） | ○ |
| C-23 | 画面No.10は機能No.23「WAL」を補助機能として使用 | E-07: --journal FLAGでjournal_mode設定可能 | ○ |
| C-24 | 画面No.10は機能No.42「ミューテックス」を補助機能として使用 | E-07: --singlethread/--multithread/--serializedフラグ対応 | ○ |
| C-25 | 画面No.11「Speedtest1（WASMFS版）」は機能No.43を主機能として使用 | E-03: WASMFS/OPFS統合版speedtest1 | ○ |
| C-26 | 画面No.12「Tester1（メインスレッド版）」は各種SQL処理機能を主機能として使用 | E-08: 各種APIの単体・回帰テストを実行 | ○ |
| C-27 | 画面No.13「Tester1（Worker版）」は機能No.42を補助機能として使用 | E-03: Workerスレッドでのテスト実行 | ○ |
| C-28 | 画面No.14「OPFS VFS テスト」は機能No.43を主機能として使用 | E-10: OPFS sqlite3_vfsのサニティテスト | ○ |
| C-29 | 画面No.14は機能No.42を補助機能として使用 | E-10: SharedArrayBuffer・Atomics APIを使用 | ○ |
| C-30 | 画面No.15「OPFS 並行性テスト」は機能No.42を主機能として使用 | E-12: 複数Workerでの並行性テスト | ○ |
| C-31 | 画面No.16「OPFS SAHPool テスト」は機能No.43を主機能として使用 | E-03: OPFS SAHPool VFSのpause機能デモ | ○ |
| C-32 | 画面No.17「OPFS SAHPool Digest」は機能No.43を主機能として使用 | E-01: 画面一覧に記載あり | △ |
| C-33 | 画面No.18「SQLTester」は機能No.5を主機能として使用 | E-03: SQLTesterテストスクリプト実行 | ○ |
| C-34 | 画面No.19「モジュールシンボル一覧」は機能No.3を主機能として使用 | E-11: sqlite3.version情報を表示 | ○ |
| C-35 | 画面No.19は機能No.4「スレッドセーフティ」を補助機能として使用 | E-11: コンパイルオプション一覧を表示 | ○ |
| C-36 | 画面No.20「WASMFS Scratchpad」は機能No.43を主機能として使用 | E-03: WASMFS/OPFS統合の実験ページ | ○ |
| C-37 | 画面No.21「Lemon パーサージェネレータ」は機能No.5を主機能として使用 | E-01: 画面一覧に記載あり | △ |

## 4) 不足情報（Unknown / Missing）
- 画面No.2「WASM 配布用インデックス」(index-dist.html)の詳細実装未確認
  - 候補：ext/wasm/index-dist.htmlの読み込み / 配布環境でのテスト確認
- 画面No.17「OPFS SAHPool Digest」(digest.html)の詳細実装未確認
  - 候補：ext/wasm/tests/opfs/sahpool/digest.htmlの読み込み
- 画面No.21「Lemon パーサージェネレータ」はドキュメントページのため機能との直接的な関連が弱い
  - 候補：doc/lemon.htmlの内容確認 / SQLiteパーサー生成との関連性調査

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 画面No.3,4,5,6,7,8,9,10,12,13,14,15,16,18,19,20：ソースコードで直接確認済み
- **1: 中リスク** - 画面No.1,11：index.htmlでの参照確認のみ
- **2: 高リスク** - 画面No.2,17,21：HTMLファイルの詳細実装未確認、または間接的な関連

## 6) レビュアーチェックリスト（最小）
- [ ] 画面No.2「WASM 配布用インデックス」のHTMLファイル（index-dist.html）を確認し、機能マッピングが正確か検証
- [ ] 画面No.17「OPFS SAHPool Digest」のHTMLファイル（digest.html）を確認し、機能マッピングが正確か検証
- [ ] 画面No.21「Lemon パーサージェネレータ」がドキュメントページとして適切に分類されているか確認
- [ ] 各画面の「関連種別」（主機能/補助機能/遷移先機能/API連携）が適切に分類されているか確認
- [ ] 「関連する操作・処理」の説明が実際のコードの動作と一致しているか確認
