# 画面設計書 1-WASMテストページインデックス

## 概要

本ドキュメントは、SQLite WASMビルドのテストページ一覧を表示するメインインデックスページ（index.html）の画面設計書です。

### 本画面の処理概要

この画面は、SQLite WASMプロジェクトのテスト・デモページへのナビゲーションハブとして機能します。

**業務上の目的・背景**：SQLite WASMプロジェクトには多数のテストページ、デモページ、ベンチマークツールが存在します。開発者やテスターがこれらのページに効率的にアクセスできるよう、すべてのテストページへのリンクを一元管理するインデックスページが必要です。このページにより、各機能のテストや動作確認を体系的に行うことができます。

**画面へのアクセス方法**：HTTPサーバー経由で `index.html` にアクセスします。推奨されるコマンドは `althttpd -enable-sab -page index.html` です。WASMファイルのロードに `file://` URLは使用できないため、必ずHTTPサーバー経由でアクセスする必要があります。

**主要な操作・処理内容**：
1. テストページ一覧の表示 - Core tests、High-level apps、speedtest1、Miscカテゴリごとにリンクを分類表示
2. 各テストページへのナビゲーション - リンクをクリックすると新しいタブで対象ページが開く
3. 32-bit/64-bit版の切り替え - 多くのテストページに32-bit版と64-bit版の両方へのリンクを提供
4. VFS選択オプション付きリンク - kvvfs、opfs、opfs-sahpool等のVFSを指定したリンクを提供

**画面遷移**：
- 遷移先画面：tester1.html、fiddle/index.html、demo-123.html、demo-123-worker.html、demo-jsstorage.html、demo-worker1.html、demo-worker1-promiser.html、speedtest1.html、speedtest1-worker.html、module-symbols.html、test-opfs-vfs.html、tests/opfs/concurrency/index.html、tests/opfs/sahpool/index.html、SQLTester/index.html、scratchpad-wasmfs.html
- 遷移元画面：なし（トップページ）

**権限による表示制御**：なし。すべてのユーザーが全リンクにアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | SQLiteライブラリ初期化 | 主機能 | WASM sqlite3モジュールの初期化処理 |
| 3 | バージョン情報取得 | 補助機能 | テストページ一覧でのバージョン確認 |

## 画面種別

一覧（ナビゲーション）

## URL/ルーティング

`ext/wasm/index.html`

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| なし | - | - | 本画面は静的なリンク一覧を表示するのみ |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| タイトルバー | ヘッダー | "sqlite3 WASM test pages" |
| 使用方法説明 | ヘッダー下 | althttpdコマンドによる起動方法 |
| 警告事項 | 説明セクション | HTTPサーバー必須、OPFS要件の説明 |
| Core tests リンク群 | テストリスト | tester1（32/64-bit）、tester1-esm、tester1-worker |
| High-level apps リンク群 | テストリスト | fiddle、demo-123、demo-jsstorage等 |
| speedtest1 リンク群 | テストリスト | 各種VFS設定付きリンク |
| Misc リンク群 | テストリスト | module-symbols、OPFS関連テスト |
| WASMFS テスト群 | テストリスト | scratchpad-wasmfs |

## イベント仕様

### 1-リンククリック

**トリガー**: 任意のテストページリンクをクリック

**処理内容**:
1. JavaScriptによりリンクの `target` 属性が動的に設定される（行179-182）
2. 各リンクはURLパスに基づいた一意のタブ名で新しいタブに開く
3. `e.target = e.href.replace(/^http*:\/\/[^/]+\//, '')` により重複タブを防止

**画面遷移**: クリックしたリンク先のテストページが新しいタブで開く

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | 本画面はデータベース操作を行わない |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| なし | - | - | 本画面はメッセージを表示しない |

## 例外処理

| 例外状況 | 対応処理 |
|---------|----------|
| HTTPサーバー未使用 | ブラウザがWASMファイルをロードできず、リンク先ページでエラーが発生する |
| COOP/COEPヘッダー未設定 | OPFS関連テストが正常に動作しない |

## 備考

- すべてのテストページはHTTPサーバー経由でのアクセスが必要
- althttpdの `-enable-sab` フラグはCOOP/COEPヘッダーの出力に必要
- 32-bit版と64-bit版のWASMビルドが存在し、ページごとに選択可能
- ESMモジュール版とconventional版の両方が提供されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面は静的HTMLページのため、特別なデータ構造は使用しない。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | index.html | `ext/wasm/index.html` | HTML構造とリンク一覧の定義 |

**読解のコツ**: HTMLの `<ul id='test-list'>` 要素内にすべてのテストページへのリンクが階層的に定義されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `ext/wasm/index.html` | ページロード時のJavaScript処理 |

**主要処理フロー**:
1. **行179-183**: `document.querySelectorAll('a')` で全リンクを取得
2. **行180-182**: 各リンクに対してtarget属性を動的設定、URLからホスト部分を除去した値をtargetに設定

#### Step 3: スタイル定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | testing.css | `ext/wasm/common/testing.css` | 共通テストページスタイル |
| 3-2 | index.html | `ext/wasm/index.html` | インラインスタイル定義（行11-17、176-178） |

**主要処理フロー**:
- **行11-17**: header要素のスタイル（背景色#044a64、白文字）
- **行176-178**: テストリストのフォントサイズ120%

### プログラム呼び出し階層図

```
index.html (ページロード)
    │
    └─ <script> (行179-183)
           └─ document.querySelectorAll('a')
                  └─ forEach: e.target = URL path
```

### データフロー図

```
[入力]               [処理]                    [出力]

ページロード ───▶ querySelectorAll('a') ───▶ 各リンクのtarget属性設定
                        │
                        └───▶ URL正規表現変換 ───▶ タブ名生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `ext/wasm/index.html` | テンプレート | メインインデックスページ |
| testing.css | `ext/wasm/common/testing.css` | スタイル | 共通テストページスタイル |
