# 画面設計書 11-Speedtest1（WASMFS版）

## 概要

本ドキュメントは、SQLite WASMプロジェクトにおけるSpeedtest1（WASMFS版）画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、SQLiteのベンチマークツール「speedtest1」をWASMFS/OPFS永続ストレージを使用してブラウザ上で実行するためのテストページである。

**業務上の目的・背景**：SQLite WASMビルドの性能評価において、WASMFS（WebAssembly File System）とOPFS（Origin Private File System）を組み合わせた永続ストレージでのベンチマーク実行が必要である。本画面は、従来のメモリ内実行やWorker版とは異なり、WASMFS/OPFS統合環境でのI/O性能を測定することを目的とする。開発者はこの画面を通じて、永続ストレージを使用した場合のSQLite操作のパフォーマンス特性を把握できる。

**画面へのアクセス方法**：インデックスページ（index.html）からリンクをクリックしてアクセスするか、直接 `speedtest1-wasmfs.html` にアクセスする。HTTPサーバー経由でのアクセスが必須であり、COOP/COEPヘッダーが必要。

**主要な操作・処理内容**：
1. ページ読み込み時にWorkerスレッドを起動し、speedtest1-wasmfs.mjsをロード
2. WASMFS/OPFS環境を初期化し、永続ストレージディレクトリをマウント
3. URLパラメータからベンチマークフラグを取得（デフォルト: --singlethread, --nomutex, --nomemstat, --size 10）
4. speedtest1ベンチマークを実行し、結果をUIに出力
5. ベンチマーク完了後、テスト用データベースファイルを削除

**画面遷移**：
- 遷移元: WASM テストページインデックス（index.html）
- 関連画面: Speedtest1（Worker版）へのリンクあり

**権限による表示制御**：特になし（開発者向けテストページ）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | SQLiteライブラリ初期化 | 主機能 | WASMFS対応版sqlite3モジュールの初期化 |
| 43 | OS抽象化層（VFS） | 主機能 | WASMFS/OPFS VFSでの永続化ベンチマーク |

## 画面種別

実行画面（ベンチマーク結果表示）

## URL/ルーティング

```
/ext/wasm/speedtest1-wasmfs.html
```

URLパラメータ:
- `flags`: カンマ区切りのspeedtest1フラグ（例: `--size,20,--singlethread`）

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| flags | 入力 | string | 任意 | URLパラメータ経由でベンチマークフラグを指定 |
| ログ出力 | 出力 | text | - | ベンチマーク実行状況と結果を画面に表示 |

## 表示項目

| 項目名 | 説明 | 表示条件 |
|--------|------|----------|
| タイトルバー | "speedtest1-wasmfs.wasm" | 常時表示 |
| 警告メッセージ | 開発者ツールを開くと速度低下する旨の警告 | 常時表示 |
| リンク | speedtest1-worker.htmlへのリンク | 常時表示 |
| テスト出力エリア | ベンチマーク実行ログと結果 | 実行中・完了後表示 |

## イベント仕様

### 1-ページ読み込み

1. DOMContentLoaded後、Worker生成を実行
2. Worker内でsqlite3-wasmfs.mjsをES6モジュールとしてロード
3. WASMFS/OPFSの初期化を試行
4. ベンチマーク実行を開始

### 2-Workerメッセージ受信

Worker→メインスレッドへのメッセージ:
- `type: 'log'`: 通常ログを画面に出力
- `type: 'logErr'`: エラーログを画面に出力（errorクラス付与）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ベンチマーク実行 | 各種テスト用テーブル | INSERT/SELECT/UPDATE/DELETE | speedtest1によるベンチマークデータ操作 |

### テーブル別更新項目詳細

#### speedtest1テスト用テーブル

speedtest1は内部でベンチマーク用のテーブルを動的に作成・操作・削除する。具体的なテーブル構造はspeedtest1の実装に依存。

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | 各種カラム | ベンチマークテストデータ | テスト410, 510で大量データ挿入 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 情報 | "speedtest1-wasmfs starting..." | Worker起動時 |
| MSG002 | 情報 | "Persistent storage: {dirName}" | OPFS利用可能時 |
| MSG003 | エラー | "Expecting persistent storage in this build." | OPFS利用不可時 |
| MSG004 | 警告 | "WARNING: --memdb flag trumps db filename." | --memdbフラグ指定時 |
| MSG005 | 情報 | "Starting native app: {argv}" | ベンチマーク開始時 |
| MSG006 | 情報 | "Done running native main()" | ベンチマーク完了時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| OPFS非対応環境 | エラーメッセージを表示し、ベンチマーク実行を中止 |
| WASMモジュールロード失敗 | コンソールにエラー出力 |
| メモリ不足 | ブラウザがWasmMemory割り当て失敗警告を表示する可能性 |

## 備考

- 本画面はWASMFSサポート付きでビルドされたsqlite3モジュールが必要
- 開発者ツールを開いた状態での実行は大幅な速度低下を招く
- `--big-transactions`フラグはテスト410と510のために重要

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Workerメッセージの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | speedtest1-wasmfs.mjs | `ext/wasm/speedtest1-wasmfs.mjs` | wMsg関数でメッセージ型（type, args）を定義 |

**読解のコツ**: ES6モジュール形式のWorkerファイル。`postMessage`でメインスレッドと通信。

#### Step 2: エントリーポイントを理解する

HTMLファイルのスクリプト部分が処理の起点。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | speedtest1-wasmfs.html | `ext/wasm/speedtest1-wasmfs.html` | Worker生成とメッセージハンドリング |

**主要処理フロー**:
1. **行39-42**: Worker生成（type: 'module'でES6モジュールとして起動）
2. **行44-51**: onmessageハンドラでログ出力を画面に反映

#### Step 3: Worker処理を理解する

Workerスレッド内でのベンチマーク実行ロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | speedtest1-wasmfs.mjs | `ext/wasm/speedtest1-wasmfs.mjs` | WASMFS初期化とベンチマーク実行 |

**主要処理フロー**:
- **行1**: sqlite3-wasmfs.mjsをインポート
- **行11-30**: wasmfsDir関数でOPFSディレクトリをマウント
- **行36-85**: runTests関数でベンチマーク設定と実行
- **行49-63**: URLパラメータからフラグを解析
- **行77-84**: setTimeout内でwasm_mainを呼び出しベンチマーク実行

### プログラム呼び出し階層図

```
speedtest1-wasmfs.html
    │
    └─ new Worker('speedtest1-wasmfs.mjs')
           │
           ├─ import sqlite3InitModule from './jswasm/sqlite3-wasmfs.mjs'
           │
           ├─ wasmfsDir() ... OPFS初期化
           │      └─ wasmUtil.xCallWrapped('sqlite3__wasm_init_wasmfs')
           │
           └─ runTests(sqlite3)
                  ├─ wasm.xWrap("sqlite3__wasm_vfs_unlink") ... ファイル削除準備
                  └─ wasm.xCall('wasm_main', argv) ... speedtest1実行
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ─────▶ Worker (speedtest1-wasmfs.mjs) ─────▶ 画面表示
(flags)               │                                    (#test-output)
                      ├─ WASMFS/OPFS初期化
                      ├─ speedtest1実行
                      └─ postMessage({type, args})
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| speedtest1-wasmfs.html | `ext/wasm/speedtest1-wasmfs.html` | テンプレート | メイン画面HTML |
| speedtest1-wasmfs.mjs | `ext/wasm/speedtest1-wasmfs.mjs` | ソース | Workerスクリプト（ベンチマーク実行） |
| sqlite3-wasmfs.mjs | `ext/wasm/jswasm/sqlite3-wasmfs.mjs` | ソース | WASMFS対応sqlite3モジュール |
| emscripten.css | `ext/wasm/common/emscripten.css` | スタイル | 共通スタイルシート |
| testing.css | `ext/wasm/common/testing.css` | スタイル | テストページ用スタイル |
