# 画面設計書 12-Tester1（メインスレッド版）

## 概要

本ドキュメントは、SQLite WASMプロジェクトにおけるTester1（メインスレッド版）画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、SQLite WASM APIの各種機能を単体テスト・回帰テストとしてUIスレッド（メインスレッド）で実行するためのテストページである。

**業務上の目的・背景**：SQLite WASMビルドの品質保証において、APIの動作検証と回帰テストの実行が不可欠である。本画面は、開発者がブラウザのUIスレッド上でsqlite3 APIの各種機能（データベース接続、SQL実行、組み込み関数など）が正常に動作することを確認するために使用する。Worker版やESM版との動作比較も可能であり、実行環境による差異の検出に役立つ。

**画面へのアクセス方法**：インデックスページ（index.html）の「Core tests」リンクからアクセスするか、直接 `tester1.html`（32-bit版）または `tester1-64bit.html`（64-bit版）にアクセスする。

**主要な操作・処理内容**：
1. ページ読み込み時にsqlite3.jsをロードし、sqlite3InitModuleで初期化
2. TestUtilフレームワークを使用してテストグループを順次実行
3. 各テストの成功/失敗をリアルタイムで画面に出力
4. テスト完了後、全体の成否をタイトルとヘッダーの色で表示（緑=PASS、赤=FAIL）
5. ログ表示順序を逆転するチェックボックスで表示をカスタマイズ可能

**画面遷移**：
- 遷移元: WASM テストページインデックス（index.html）
- 関連画面: 32-bit/64-bit版、Worker版、ESM版の各バリエーションへの相互リンク

**権限による表示制御**：特になし（開発者向けテストページ）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | SQLiteライブラリ初期化 | 主機能 | テストスイート用sqlite3モジュール初期化 |
| 2 | データベース接続管理 | 主機能 | テスト用DB接続・切断処理 |
| 3 | バージョン情報取得 | 補助機能 | テスト実行時のバージョン確認 |
| 6 | SELECT文処理 | 主機能 | 各種SELECT文の単体・回帰テスト |
| 7 | INSERT文処理 | 主機能 | 各種INSERT文の単体・回帰テスト |
| 28 | 組み込みSQL関数 | 補助機能 | 組み込み関数のテスト |

## 画面種別

テスト実行・結果表示画面

## URL/ルーティング

```
/ext/wasm/tester1.html          # 32-bit版
/ext/wasm/tester1-64bit.html    # 64-bit版
/ext/wasm/tester1-esm.html      # ESM 32-bit版
/ext/wasm/tester1-esm-64bit.html # ESM 64-bit版
```

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| cb-log-reverse | 入力 | checkbox | 任意 | ログ表示順序を逆転 |
| テスト結果 | 出力 | text/HTML | - | テスト実行ログと成否 |

## 表示項目

| 項目名 | 説明 | 表示条件 |
|--------|------|----------|
| タイトル（h1） | "sqlite3 tester #1: {title} ({bitness}-bit WASM)" | 常時表示 |
| バリエーションリンク | 32-bit/64-bit、Worker/ESM各版へのリンク | 常時表示 |
| ログ逆順チェックボックス | "Reverse log order?" | 常時表示 |
| テスト出力エリア | グループごとのテスト実行ログ | テスト実行中・完了後 |

## イベント仕様

### 1-ページ読み込み

1. sqlite3.jsとtester1.jsをロード
2. sqlite3InitModule()でモジュール初期化
3. TestUtilフレームワークがテストキューを処理開始
4. 各テストグループを順次実行

### 2-チェックボックス操作

- チェック時: ログ出力エリアに`reverse`クラスを追加（CSS flex-direction: column-reverse）
- localStorageに設定を保存し、次回訪問時に復元

### 3-テスト完了

1. reportFinalTestStatus()が呼び出される
2. 成功時: h1に`tests-pass`クラス、タイトルに「PASS:」プレフィックス
3. 失敗時: h1に`tests-fail`クラス、タイトルに「FAIL:」プレフィックス

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テスト実行 | テスト用テーブル | INSERT/SELECT/UPDATE/DELETE | 各テストケースでのDB操作検証 |

### テーブル別更新項目詳細

#### テスト用一時テーブル

テストごとに動的に作成・削除されるインメモリテーブル。

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| 各種操作 | テストデータ | テストケースにより異なる | インメモリDB使用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 情報 | "Running in the UI thread." | UIスレッド実行時 |
| MSG002 | 情報 | "Group #N: {groupName}" | テストグループ開始時 |
| MSG003 | 警告 | "SKIPPING group: {reason}" | テストグループスキップ時 |
| MSG004 | 情報 | "N.M: {testName}" | 個別テスト実行時 |
| MSG005 | 警告 | "SKIPPING: {reason}" | 個別テストスキップ時 |
| MSG006 | 成功 | "PASS: sqlite3 tester #1..." | 全テスト成功時 |
| MSG007 | エラー | "FAIL: sqlite3 tester #1..." | テスト失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| アサーション失敗 | Errorをスロー、テスト中断、FAILステータス表示 |
| モジュールロード失敗 | コンソールにエラー出力、画面に反映 |
| 期待例外の不発生 | mustThrow/mustThrowMatchingでエラー |

## 備考

- C preprocessor（c-pp）でES6モジュール版と通常版を生成
- 32-bitと64-bit両方のWASMビルドに対応
- OPFSなどオプション機能は hasOpfs() などの述語関数でテスト有無を制御

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テストフレームワークの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tester1.c-pp.js | `ext/wasm/tester1.c-pp.js` | TestUtilオブジェクトとTestGroupクラス |

**読解のコツ**: TestUtil.assert()、mustThrow()、mustThrowMatching()がアサーション関数。TestGroupは名前と述語関数を持ち、テストの配列を管理。

#### Step 2: エントリーポイントを理解する

HTMLファイルとスクリプトロードの流れ。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tester1.c-pp.html | `ext/wasm/tester1.c-pp.html` | スクリプトタグによるsqlite3.jsとtester1.jsのロード |

**主要処理フロー**:
1. **行40-42**: sqlite3.jsとtester1.jsを順次ロード（通常版）
2. **行38**: ES6モジュール版の場合はmoduleタイプで単一ロード

#### Step 3: テストフレームワークを理解する

テスト実行のコアロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tester1.c-pp.js | `ext/wasm/tester1.c-pp.js` | isUIThread/isWorker述語、logClass関数 |

**主要処理フロー**:
- **行61-63**: isUIThread()とisWorker()でスレッド種別を判定
- **行79-131**: ログ出力の設定（UIスレッドはDOM操作、WorkerはpostMessage）
- **行132-142**: reportFinalTestStatus()で最終結果を表示
- **行175-253**: TestUtilのアサーション関数群
- **行255-300+**: TestGroupクラスとrun()メソッド

### プログラム呼び出し階層図

```
tester1.c-pp.html
    │
    ├─ <script src="sqlite3.js">
    │      └─ sqlite3InitModule() ... WASMモジュール初期化
    │
    └─ <script src="tester1.js">
           │
           ├─ isUIThread() / isWorker() ... 実行環境判定
           │
           ├─ logClass() ... ログ出力設定
           │
           └─ TestUtil
                  ├─ assert() / mustThrow() / mustThrowMatching()
                  │
                  └─ TestGroup
                         ├─ addTest()
                         └─ run(sqlite3)
                                └─ reportFinalTestStatus(pass)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

sqlite3.js ─────────▶ sqlite3InitModule() ────────▶ sqlite3オブジェクト
                              │
                              ▼
                      TestGroup.run(sqlite3)
                              │
                              ├─ 各テスト実行
                              │      └─ TestUtil.assert()
                              │
                              ▼
localStorageの設定 ◀──▶ チェックボックス状態 ─────▶ ログ表示順序
                              │
                              ▼
                      reportFinalTestStatus()
                              │
                              ▼
                      DOM更新（#test-output, h1, title）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tester1.c-pp.html | `ext/wasm/tester1.c-pp.html` | テンプレート | メイン画面HTMLテンプレート |
| tester1.c-pp.js | `ext/wasm/tester1.c-pp.js` | ソース | テストフレームワークとテストケース |
| sqlite3.js | `ext/wasm/jswasm/sqlite3.js` | ソース | sqlite3 WASMモジュール |
| emscripten.css | `ext/wasm/common/emscripten.css` | スタイル | 共通スタイルシート |
| testing.css | `ext/wasm/common/testing.css` | スタイル | テストページ用スタイル |
