# 画面設計書 13-Tester1（Worker版）

## 概要

本ドキュメントは、SQLite WASMプロジェクトにおけるTester1（Worker版）画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、SQLite WASM APIの各種機能を単体テスト・回帰テストとしてWorkerスレッドで実行するためのテストページである。

**業務上の目的・背景**：SQLite WASMビルドの品質保証において、Workerスレッド環境での動作検証が不可欠である。本画面は、UIスレッドをブロックせずにテストを実行し、メインスレッド版との動作比較を可能にする。Worker環境特有の制約（DOM非アクセス、postMessage通信など）下でのAPI動作確認を行い、マルチスレッド対応の検証に使用する。ESMモジュール版Workerのテストにも対応している。

**画面へのアクセス方法**：インデックスページ（index.html）の「Core tests Worker」リンクからアクセスするか、直接 `tester1-worker.html`（32-bit版）または `tester1-worker-64bit.html`（64-bit版）にアクセスする。URLに`?esm`を付与するとESMモジュール版で実行。

**主要な操作・処理内容**：
1. ページ読み込み時にWorkerスレッドを起動
2. Workerがsqlite3.jsをロードし、sqlite3InitModuleで初期化
3. Worker内でTestUtilフレームワークがテストを実行
4. 結果をpostMessageでメインスレッドに送信
5. メインスレッドがDOMを更新してログと最終結果を表示

**画面遷移**：
- 遷移元: WASM テストページインデックス（index.html）
- 関連画面: 32-bit/64-bit版、メインスレッド版、ESM版の各バリエーションへの相互リンク

**権限による表示制御**：特になし（開発者向けテストページ）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | SQLiteライブラリ初期化 | 主機能 | Worker内でのテストスイート初期化 |
| 2 | データベース接続管理 | 主機能 | Worker内でのテスト用DB管理 |
| 42 | ミューテックス | 補助機能 | Workerスレッドでの同期テスト |

## 画面種別

テスト実行・結果表示画面

## URL/ルーティング

```
/ext/wasm/tester1-worker.html           # 32-bit版
/ext/wasm/tester1-worker-64bit.html     # 64-bit版
/ext/wasm/tester1-worker.html?esm       # ESM Worker 32-bit版
/ext/wasm/tester1-worker-64bit.html?esm # ESM Worker 64-bit版
```

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| esm | 入力 | URLパラメータ | 任意 | 存在時はESMモジュールWorkerで実行 |
| cb-log-reverse | 入力 | checkbox | 任意 | ログ表示順序を逆転 |
| テスト結果 | 出力 | text/HTML | - | テスト実行ログと成否 |

## 表示項目

| 項目名 | 説明 | 表示条件 |
|--------|------|----------|
| タイトル（h1） | "sqlite3 tester #1: Worker thread ({bitness}-bit WASM)" | 常時表示 |
| ESM警告 | ESMモジュールワーカーは全ブラウザ対応ではない旨の警告 | ?esm指定時 |
| バリエーションリンク | 各版へのリンク | 常時表示 |
| ログ逆順チェックボックス | "Reverse log order?" | 常時表示 |
| テスト出力エリア | テスト実行ログ | テスト実行中・完了後 |

## イベント仕様

### 1-ページ読み込み

1. URLパラメータから`esm`の有無を確認
2. Workerを起動（ESMの場合は`{type:"module"}`オプション付き）
3. Worker内でテスト実行が開始される

### 2-Workerメッセージ受信（onmessage）

Worker→メインスレッドへのメッセージ:
- `type: 'log'`: 通常ログ（cssClassとargsを含む）
- `type: 'error'`: エラーログ
- `type: 'test-result'`: テスト完了（pass: true/falseを含む）

### 3-チェックボックス操作

- チェック時: ログ出力エリアに`reverse`クラスを追加
- localStorageに設定を保存し、次回訪問時に復元

### 4-テスト結果受信

1. `test-result`メッセージ受信時にreportFinalTestStatus相当の処理
2. 成功時: h1に`tests-pass`クラス、タイトルに「PASS:」プレフィックス
3. 失敗時: h1に`tests-fail`クラス、タイトルに「FAIL:」プレフィックス

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テスト実行 | テスト用テーブル | INSERT/SELECT/UPDATE/DELETE | 各テストケースでのDB操作検証 |

### テーブル別更新項目詳細

#### テスト用一時テーブル

Worker内で作成・操作されるインメモリテーブル。

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| 各種操作 | テストデータ | テストケースにより異なる | Workerスレッド内で実行 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 警告 | "Attempting to run an ES6 Worker Module, which is not supported by all browsers!" | ESMモード時 |
| MSG002 | 情報 | "Running in a Worker thread." | Worker実行時（コンソール） |
| MSG003 | 情報 | "Group #N: {groupName}" | テストグループ開始時 |
| MSG004 | 成功 | "PASS: sqlite3 tester #1..." | 全テスト成功時 |
| MSG005 | エラー | "FAIL: sqlite3 tester #1..." | テスト失敗時 |
| MSG006 | エラー | "Unhandled message: {type}" | 未知のメッセージタイプ受信時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| Worker起動失敗 | ブラウザのコンソールにエラー出力 |
| ESMモジュール非対応ブラウザ | 警告メッセージ表示後、失敗 |
| テストアサーション失敗 | errorメッセージをpostMessage |

## 備考

- ESMモジュール版Workerは全ブラウザで対応していない点に注意
- Worker内ではDOMアクセス不可のため、すべての表示はpostMessage経由
- 32-bit/64-bit版は別ファイル（tester1.js / tester1-64bit.js）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Worker-メインスレッド間のメッセージ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tester1-worker.c-pp.html | `ext/wasm/tester1-worker.c-pp.html` | onmessageハンドラでのメッセージ構造 |
| 1-2 | tester1.c-pp.js | `ext/wasm/tester1.c-pp.js` | Worker側のpostMessage構造 |

**読解のコツ**: メッセージは`{type, payload}`形式。payloadにはcssClassやargs、passなどが含まれる。

#### Step 2: エントリーポイントを理解する

HTMLファイルでのWorker起動処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tester1-worker.c-pp.html | `ext/wasm/tester1-worker.c-pp.html` | Worker生成とパラメータ処理 |

**主要処理フロー**:
1. **行57-70**: URLパラメータから`esm`を確認し、Workerの起動方法を決定
2. **行59-67**: ESMの場合は`{type:"module"}`でtester1.mjsを起動
3. **行69**: 通常版はtester1.js?sqlite3.dir=jswasmを起動
4. **行71**: new Worker()でWorker生成
5. **行72-93**: onmessageハンドラで各メッセージタイプを処理

#### Step 3: Worker側の処理を理解する

Worker内でのテスト実行ロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tester1.c-pp.js | `ext/wasm/tester1.c-pp.js` | isWorker()判定とpostMessage |

**主要処理フロー**:
- **行63**: isWorker() = !isUIThread() でWorker判定
- **行122-130**: Worker用のlogClass実装（postMessageで送信）
- **行139**: postMessage({type:'test-result', payload:{pass}})で最終結果送信

### プログラム呼び出し階層図

```
tester1-worker.c-pp.html
    │
    ├─ URLパラメータ解析（?esm）
    │
    └─ new Worker('tester1.js' or 'tester1.mjs')
           │
           ├─ importScripts/import sqlite3.js
           │      └─ sqlite3InitModule()
           │
           ├─ isWorker() → true
           │
           └─ TestGroup.run(sqlite3)
                  │
                  ├─ 各テスト実行
                  │
                  └─ postMessage({type:'log/error/test-result'})
                         │
                         ▼
           ┌─────────────────────────────┐
           │  メインスレッド (HTML)        │
           │  onmessage → logHtml()       │
           │            → DOM更新         │
           └─────────────────────────────┘
```

### データフロー図

```
[Worker]                              [メインスレッド]

sqlite3InitModule() ─────────────────▶ (なし)
        │
        ▼
TestGroup.run(sqlite3)
        │
        ├─ postMessage({type:'log'}) ─────▶ logHtml() → #test-output
        │
        ├─ postMessage({type:'error'}) ───▶ logHtml('error') → #test-output
        │
        └─ postMessage({type:'test-result'}) ▶ h1クラス変更, titleプレフィックス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tester1-worker.c-pp.html | `ext/wasm/tester1-worker.c-pp.html` | テンプレート | メイン画面HTMLテンプレート |
| tester1.c-pp.js | `ext/wasm/tester1.c-pp.js` | ソース | テストフレームワーク（Worker/メイン共用） |
| sqlite3.js | `ext/wasm/jswasm/sqlite3.js` | ソース | sqlite3 WASMモジュール |
| tester1.mjs | `ext/wasm/tester1.mjs` | ソース | ESMモジュール版テストスクリプト |
| emscripten.css | `ext/wasm/common/emscripten.css` | スタイル | 共通スタイルシート |
| testing.css | `ext/wasm/common/testing.css` | スタイル | テストページ用スタイル |
