# 画面設計書 18-SQLTester

## 概要

本ドキュメントは、SQLite WASMプロジェクトにおけるSQLTester画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、SQLTesterテストスクリプトを読み込み、SQLiteの動作検証を行うためのテスト実行ページである。

**業務上の目的・背景**：SQLite WASMビルドの品質保証において、外部テストスクリプトを使用した体系的なテスト実行が必要である。本画面は、ビルド時に定義されたSQLTesterテストスクリプト群を読み込み、SQLTesterクラスを通じてSQL文の実行と結果検証を自動化する。これにより、開発者はSQLiteの動作が仕様通りであることを効率的に確認できる。

**画面へのアクセス方法**：インデックスページ（index.html）の「SQLTester」リンクからアクセスするか、直接 `SQLTester/index.html` にアクセスする。

**主要な操作・処理内容**：
1. ページ読み込み時にWorker（SQLTester.run.mjs）を起動
2. Workerが'is-ready'を送信したらテストを自動実行
3. テストスクリプトを順次処理し、SQL文実行と結果検証
4. 結果を画面にリアルタイム表示
5. テスト完了後、メトリクスを表示

**画面遷移**：
- 遷移元: WASM テストページインデックス（index.html）

**権限による表示制御**：特になし（開発者向けテストページ）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | SQLiteライブラリ初期化 | 主機能 | SQLTester用sqlite3モジュール初期化 |
| 5 | SQLパーサー/トークナイザー | 主機能 | 外部テストスクリプトの解析・実行 |
| 6 | SELECT文処理 | 主機能 | テストスクリプト内SELECT文実行 |
| 7 | INSERT文処理 | 主機能 | テストスクリプト内INSERT文実行 |

## 画面種別

テスト実行・結果表示画面

## URL/ルーティング

```
/ext/wasm/SQLTester/index.html
```

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| cb-log-reverse | 入力 | checkbox | 任意 | ログ順序逆転（デフォルトチェック済み） |
| btn-run-tests | 入力 | button | - | テスト再実行ボタン |
| テスト結果 | 出力 | text/HTML | - | テスト実行ログと結果 |

## 表示項目

| 項目名 | 説明 | 表示条件 |
|--------|------|----------|
| タイトル（h1） | "SQLTester for JS/WASM" | 常時表示 |
| 説明文 | ビルド時定義のテストスクリプトを実行する旨 | 常時表示 |
| Optionsフィールドセット | ログ逆順チェックボックスとRun testsボタン | 常時表示 |
| テスト出力エリア | "Test output will go here."（初期状態） | 常時表示 |

## イベント仕様

### 1-ページ読み込み

1. Worker（SQLTester.run.mjs）をES6モジュールとして起動
2. タイムアウト（3秒）を設定し、ロード遅延時に警告表示
3. Worker初期化完了（'is-ready'）を待機

### 2-Worker初期化完了（is-ready）

1. タイムアウトをクリア
2. runTests()を呼び出してテスト自動実行
3. "Run tests"ボタンを無効化

### 3-Run testsボタンクリック

1. ボタンを無効化
2. wPost('run-tests')でWorkerにテスト実行を指示
3. テスト出力エリアを"Running tests..."に更新

### 4-Workerメッセージ受信

- `type: 'stdout'`: 標準出力を画面に表示
- `type: 'tests-end'`: テスト終了、メトリクス表示、ボタン再有効化
- その他: "unhandled onmessage"としてログ出力

### 5-テスト完了（tests-end）

1. "Run tests"ボタンを再有効化
2. sqt.metricsからnTestを除いたメトリクスを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テスト実行 | テストスクリプト定義テーブル | CREATE/INSERT/SELECT/DELETE等 | 各テストケースのSQL実行 |

### テーブル別更新項目詳細

テストスクリプトごとに動的に作成・操作されるテーブル。詳細は各テストスクリプトの定義に依存。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 情報 | "Test output will go here." | 初期状態 |
| MSG002 | 情報 | "Running tests..." | テスト開始時 |
| MSG003 | 警告 | "The SQLTester module is taking an unusually long time to load..." | 3秒以上ロード時 |
| MSG004 | 情報 | "index.html: test results: {metrics}" | テスト完了時 |
| MSG005 | 情報 | "index.html: unhandled onmessage {data}" | 未知メッセージ受信時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| モジュールロード遅延 | 3秒後に警告メッセージ表示、開発者コンソール確認を促す |
| Worker内エラー | ログに出力（エラーハンドリングはWorker側で実施） |

## 備考

- テストスクリプトはビルド時にtest-list.mjsに定義される
- SQLTesterクラスは--verbosityや--nullなどのディレクティブをサポート
- サニティチェック用のインラインテストスクリプトも含まれる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Worker通信メッセージとSQLTesterクラス。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | index.html | `ext/wasm/SQLTester/index.html` | wPost関数とonmessageハンドラ |
| 1-2 | SQLTester.run.mjs | `ext/wasm/SQLTester/SQLTester.run.mjs` | SQLTesterクラスとTestScriptクラス |

**読解のコツ**: wPost(type, payload)でWorkerにメッセージ送信。Worker側はsqt（SQLTesterインスタンス）でテスト実行。

#### Step 2: エントリーポイントを理解する

HTMLファイルのスクリプト部分。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `ext/wasm/SQLTester/index.html` | Worker生成とイベントハンドラ設定 |

**主要処理フロー**:
- **行39-42**: Worker生成（ES6モジュール）
- **行43**: wPost関数定義
- **行74-82**: チェックボックスイベント設定
- **行84-89**: ボタンクリックハンドラ（runTests）
- **行100-120**: Worker onmessageハンドラ

#### Step 3: テスト実行ロジックを理解する

Worker内でのSQLTester実行。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SQLTester.run.mjs | `ext/wasm/SQLTester/SQLTester.run.mjs` | runTests関数とsqt.runTests() |

**主要処理フロー**:
- **行15-16**: SQLTester.mjsとtest-list.mjsをインポート
- **行37-99**: サニティチェック用インラインテストスクリプト
- **行101-104**: SQLTesterインスタンス設定
- **行107-128**: runTests関数（テストスクリプト追加と実行）
- **行130-151**: Worker環境でのonmessageハンドラ

### プログラム呼び出し階層図

```
index.html
    │
    └─ new Worker('SQLTester.run.mjs', {type:'module'})
           │
           ├─ import SQLTester from './SQLTester.mjs'
           ├─ import allTests from './test-list.mjs'
           │
           ├─ postMessage({type:'is-ready'})
           │      ↓
           │  [メイン] runTests()
           │      └─ wPost('run-tests')
           │             ↓
           │         [Worker] onmessage
           │
           └─ sqt.runTests()
                  │
                  ├─ TestScript解析
                  ├─ SQL実行
                  ├─ 結果検証
                  │
                  └─ postMessage({type:'tests-end', payload: metrics})
```

### データフロー図

```
[入力]                    [処理]                         [出力]

test-list.mjs ─────▶ SQLTester.run.mjs (Worker)    ─────▶ #test-output
(テストスクリプト)         │
                          ├─ SQLTesterインスタンス
                          │      ├─ setLogger()
                          │      └─ verbosity()
                          │
                          ├─ TestScript追加
                          │      └─ new TestScript(file)
                          │
                          └─ sqt.runTests()
                                 │
                                 ├─ postMessage({type:'stdout'})
                                 │      ↓
                                 │  [メイン] log2()
                                 │
                                 └─ postMessage({type:'tests-end'})
                                        ↓
                                    [メイン] metrics表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `ext/wasm/SQLTester/index.html` | テンプレート | メイン画面HTML |
| SQLTester.run.mjs | `ext/wasm/SQLTester/SQLTester.run.mjs` | ソース | テスト実行Workerスクリプト |
| SQLTester.mjs | `ext/wasm/SQLTester/SQLTester.mjs` | ソース | SQLTesterクラス定義 |
| test-list.mjs | `ext/wasm/SQLTester/test-list.mjs` | ソース | テストスクリプト一覧 |
| testing.css | `ext/wasm/common/testing.css` | スタイル | テストページ用スタイル |
