# 画面設計書 19-モジュールシンボル一覧

## 概要

本ドキュメントは、SQLite WASMプロジェクトにおけるモジュールシンボル一覧画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、sqlite3.wasmが公開するAPIシンボル（関数、定数、名前空間など）の一覧を動的に生成・表示するユーティリティページである。

**業務上の目的・背景**：SQLite WASMビルドを使用する開発者にとって、利用可能なAPIの把握は重要である。本画面は、JS/WASMモジュールを実際にロードしてイントロスペクション（内省）を行い、公開されているすべてのシンボルをカテゴリ別に一覧表示する。これにより、開発者はドキュメントに頼らずとも利用可能なAPIを確認でき、また、ビルド構成によって含まれる/含まれないAPIの差異も把握できる。

**画面へのアクセス方法**：インデックスページ（index.html）の「Symbols」リンクからアクセスするか、直接 `module-symbols.html` にアクセスする。

**主要な操作・処理内容**：
1. ページ読み込み時にsqlite3.jsをロード
2. sqlite3InitModule()でモジュールを初期化
3. sqlite3オブジェクトのプロパティを走査し、カテゴリ別に分類
4. 関数にはAPIドキュメントへのリンクを付与
5. コンパイルオプションも一覧表示

**画面遷移**：
- 遷移元: WASM テストページインデックス（index.html）

**権限による表示制御**：特になし（開発者向けユーティリティページ）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | SQLiteライブラリ初期化 | 主機能 | シンボル取得のためのモジュール初期化 |
| 3 | バージョン情報取得 | 主機能 | sqlite3.version情報の表示 |
| 4 | スレッドセーフティ | 補助機能 | コンパイルオプションの確認表示 |

## 画面種別

情報表示画面（一覧形式）

## URL/ルーティング

```
/ext/wasm/module-symbols.html
```

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| （なし） | - | - | - | 入力項目なし |
| シンボル一覧 | 出力 | HTML | - | カテゴリ別のシンボル一覧 |

## 表示項目

| 項目名 | 説明 | 表示条件 |
|--------|------|----------|
| ローディングメッセージ | "Loading WASM module..." | モジュールロード中 |
| 説明文 | APIシンボル一覧の説明と注意事項 | ロード完了後 |
| 目次（Jump to...） | 各セクションへのリンク | ロード完了後 |
| sqlite3名前空間 | sqlite3オブジェクト直下のプロパティ | ロード完了後 |
| sqlite3.version | バージョン情報オブジェクト | ロード完了後 |
| sqlite3_...()関数一覧 | C APIに対応する関数 | ロード完了後 |
| SQLITE_...定数一覧 | SQLite定数 | ロード完了後 |
| sqlite3.oo1名前空間 | オブジェクト指向API | ロード完了後 |
| sqlite3.wasm名前空間 | WASMユーティリティ | ロード完了後 |
| sqlite3.wasm.pstack | スタック操作API | ロード完了後 |
| sqlite3.wasm.ptr | ポインタ操作API | ロード完了後 |
| コンパイルオプション | SQLITE_...コンパイルフラグ | ロード完了後 |

## イベント仕様

### 1-ページ読み込み

1. sqlite3.jsをロード
2. sqlite3InitModule(myModule)でモジュール初期化
3. myModule.setStatus()でロード進捗を表示
4. 初期化完了後、renderIt()で一覧を描画

### 2-モジュール初期化完了

1. sqlite3オブジェクトをグローバル（self.sqlite3）に設定
2. 各カテゴリのシンボルを収集・ソート
3. apiLinksマップを使用して関数にドキュメントリンクを付与
4. renderX()で各セクションを描画
5. ローディングメッセージを非表示、コンテンツを表示

## データベース更新仕様

本画面はデータベースへの更新を行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 情報 | "Loading WASM module..." | ロード中 |
| MSG002 | 情報 | "If this takes 'a long time' it may have failed..." | ロード遅延時 |
| MSG003 | コンソール | "sqlite3 installed as global symbol self.sqlite3." | 初期化完了時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| モジュールロード失敗 | ローディングメッセージが残り続ける、開発者コンソールにエラー出力 |

## 備考

- UIスレッドで実行されるため、Worker専用機能は表示されない
- `func-wasm`クラスで「WASM」バッジ付きの関数をマーク
- 内部使用関数（scriptInfo、StructBinder）は除外
- fossil-docタグで囲まれた部分はwasmドキュメントリポジトリで再利用可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

APIリンクマッピングとシンボルカテゴリ分類。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | module-symbols.html | `ext/wasm/module-symbols.html` | apiLinksオブジェクト |

**読解のコツ**: apiLinksは関数名→ドキュメントURLのマッピング。`www:`は公式サイト、`wasm:`はWASM固有ドキュメントへのプレフィックス。

#### Step 2: エントリーポイントを理解する

モジュール初期化とレンダリング開始。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | module-symbols.html | `ext/wasm/module-symbols.html` | sqlite3InitModule(myModule)呼び出し |

**主要処理フロー**:
- **行198**: sqlite3.jsをロード
- **行538**: sqlite3InitModule(myModule).then(renderIt)で初期化と描画開始
- **行508-537**: myModuleオブジェクト（print, printErr, setStatus）

#### Step 3: レンダリングロジックを理解する

各カテゴリのシンボル描画。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | module-symbols.html | `ext/wasm/module-symbols.html` | renderIt関数とrenderX関数 |

**主要処理フロー**:
- **行435-502**: renderIt関数
- **行436**: self.sqlite3にグローバル設定
- **行440-444**: renderX関数（汎用レンダラー）
- **行457-479**: capi内のシンボル分類（SQLITE_定数、sqlite3_関数）
- **行478-479**: 定数と関数を描画
- **行482-501**: oo1、wasm、pstack、ptr、compileOptionUsedを描画

### プログラム呼び出し階層図

```
module-symbols.html
    │
    └─ <script src="jswasm/sqlite3.js">
           │
           └─ sqlite3InitModule(myModule)
                  │
                  ├─ myModule.setStatus() ... ロード進捗表示
                  │
                  └─ .then(renderIt)
                         │
                         ├─ self.sqlite3 = sqlite3 ... グローバル設定
                         │
                         ├─ renderX(#list-namespace, sqlite3, keys)
                         ├─ renderX(#list-version, sqlite3.version, keys)
                         │
                         ├─ capi走査
                         │      ├─ SQLITE_... → lists.c
                         │      └─ sqlite3_... → lists.f
                         │
                         ├─ lists.c.forEach(renderConst)
                         ├─ lists.f.forEach(renderFunc)
                         │
                         ├─ renderX(#list-oo1, sqlite3.oo1, keys)
                         ├─ renderX(#list-wasm, wasm, keys)
                         ├─ renderX(#list-wasm-pstack, wasm.pstack, keys)
                         ├─ renderX(#list-wasm-ptr, wasm.ptr, keys)
                         └─ renderX(#list-compile-options, cou, keys)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

sqlite3.js ─────────▶ sqlite3InitModule()        ─────▶ sqlite3オブジェクト
                              │
                              ▼
                      renderIt(sqlite3)
                              │
                              ├─ sqlite3.capi走査
                              │      ├─ SQLITE_xxx → #list-constants
                              │      └─ sqlite3_xxx → #list-functions
                              │
                              ├─ sqlite3.oo1走査 → #list-oo1
                              ├─ sqlite3.wasm走査 → #list-wasm
                              └─ compileOptionUsed() → #list-compile-options
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| module-symbols.html | `ext/wasm/module-symbols.html` | テンプレート | メイン画面HTML（インラインスクリプト含む） |
| sqlite3.js | `ext/wasm/jswasm/sqlite3.js` | ソース | sqlite3 WASMモジュール |
