# 画面設計書 2-WASM配布用インデックス

## 概要

本ドキュメントは、SQLite WASM配布用のテストページインデックス（index-dist.html）の画面設計書です。

### 本画面の処理概要

この画面は、配布版SQLite WASMのデモページへのナビゲーションを提供する簡易版インデックスページです。

**業務上の目的・背景**：開発版インデックス（index.html）と比較して、配布用として公開するデモページのみに絞り込んだリンク一覧を提供します。エンドユーザーやライブラリ利用者が、SQLite WASMの主要機能を試すための入口として機能します。開発者向けの詳細なテストページは除外し、より実用的なデモページへのアクセスを提供します。

**画面へのアクセス方法**：HTTPサーバー経由で `index-dist.html` にアクセスします。推奨されるコマンドは `althttpd -enable-sab -page index.html` です。

**主要な操作・処理内容**：
1. デモページ一覧の表示 - Core tests、Higher-level appsカテゴリごとにリンクを分類表示
2. 各デモページへのナビゲーション - リンクをクリックすると対象ページが開く
3. ESMモジュール版とWorker版の選択 - 複数の実行モードへのリンクを提供

**画面遷移**：
- 遷移先画面：tester1.html、tester1-worker.html、tester1-esm.html、demo-123.html、demo-123-worker.html、demo-jsstorage.html、demo-worker1.html、demo-worker1-promiser.html、module-symbols.html
- 遷移元画面：なし（トップページ）

**権限による表示制御**：なし。すべてのユーザーが全リンクにアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | SQLiteライブラリ初期化 | 主機能 | 配布用WASMモジュールの初期化処理 |

## 画面種別

一覧（ナビゲーション）

## URL/ルーティング

`ext/wasm/index-dist.html`

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| なし | - | - | 本画面は静的なリンク一覧を表示するのみ |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| タイトルバー | ヘッダー | "sqlite3 WASM demo pages" |
| 使用方法説明 | ヘッダー下 | althttpdコマンドによる起動方法 |
| 警告事項 | 説明セクション | HTTPサーバー必須、OPFS要件の説明 |
| Core tests リンク群 | テストリスト | tester1、tester1-worker、tester1-esm |
| Higher-level apps リンク群 | テストリスト | demo-123、demo-jsstorage、demo-worker1等 |

## イベント仕様

### 1-リンククリック

**トリガー**: 任意のデモページリンクをクリック

**処理内容**:
1. JavaScriptによりリンクの `target` 属性が動的に設定される（行110-113）
2. 各リンクは `e.href` の値をそのまま `target` に設定
3. これにより同じリンクを再クリックすると同じタブが再利用される

**画面遷移**: クリックしたリンク先のデモページが開く

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | 本画面はデータベース操作を行わない |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| なし | - | - | 本画面はメッセージを表示しない |

## 例外処理

| 例外状況 | 対応処理 |
|---------|----------|
| HTTPサーバー未使用 | ブラウザがWASMファイルをロードできず、リンク先ページでエラーが発生する |
| COOP/COEPヘッダー未設定 | OPFS関連テストが正常に動作しない |

## 備考

- index.htmlの簡易版で、配布用として公開するデモページのみを掲載
- 32-bit/64-bit版の切り替えリンクは含まれていない（index.htmlとの違い）
- speedtest1やOPFS詳細テストへのリンクは除外されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面は静的HTMLページのため、特別なデータ構造は使用しない。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | index-dist.html | `ext/wasm/index-dist.html` | HTML構造とリンク一覧の定義 |

**読解のコツ**: index.htmlと比較して、どのリンクが除外されているかを確認すると、配布版の意図が理解しやすい。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index-dist.html | `ext/wasm/index-dist.html` | ページロード時のJavaScript処理 |

**主要処理フロー**:
1. **行110-113**: `document.querySelectorAll('a')` で全リンクを取得
2. **行111-112**: 各リンクに対してtarget属性を `e.href` に設定

#### Step 3: index.htmlとの比較

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html | `ext/wasm/index.html` | 開発版インデックスとの差分確認 |

**主要な違い**:
- index.htmlは `e.target = e.href.replace(/^http*:\/\/[^/]+\//, '')` でURLパスのみをtargetに設定
- index-dist.htmlは `e.target = e.href` でフルURLをtargetに設定
- index-dist.htmlには32-bit/64-bit版の切り替えリンクがない
- index-dist.htmlにはspeedtest1関連のリンクがない

### プログラム呼び出し階層図

```
index-dist.html (ページロード)
    │
    └─ <script> (行110-113)
           └─ document.querySelectorAll('a')
                  └─ forEach: e.target = e.href
```

### データフロー図

```
[入力]               [処理]                    [出力]

ページロード ───▶ querySelectorAll('a') ───▶ 各リンクのtarget属性設定
                        │
                        └───▶ e.href値取得 ───▶ タブ名設定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index-dist.html | `ext/wasm/index-dist.html` | テンプレート | 配布用インデックスページ |
| index.html | `ext/wasm/index.html` | テンプレート | 開発用インデックスページ（比較参照用） |
