# 画面設計書 21-Lemon パーサージェネレータ

## 概要

本ドキュメントは、SQLiteプロジェクトで使用されるLemonパーサージェネレータのHTMLドキュメントページ（`doc/lemon.html`）の画面設計書です。このページは静的なHTMLドキュメントとして、Lemonパーサージェネレータの使用方法、文法仕様、APIリファレンスを提供します。

### 本画面の処理概要

このドキュメントページは、Lemon LALR(1)パーサージェネレータの包括的なリファレンスマニュアルとして機能します。

**業務上の目的・背景**：Lemonはyaccやbisonの代替として開発されたLALR(1)パーサージェネレータです。SQLiteのSQLパーサーはLemonを使用して生成されており、SQLiteの開発者や、Lemonを利用して独自のパーサーを開発したい外部開発者にとって、このドキュメントは必須のリファレンスとなります。Lemonはyacc/bisonと比較して、より安全でリエントラントなパーサーを生成でき、リソースリーク防止機能も備えているため、GUIアプリケーションや組み込みシステムでの長時間稼働に適しています。

**画面へのアクセス方法**：このドキュメントは以下の方法でアクセスできます。
- SQLiteソースツリーの`doc/lemon.html`ファイルを直接ブラウザで開く
- SQLite公式サイトのドキュメントセクションからリンクを辿る
- WASMテストページインデックスからはリンクされていない独立したドキュメント

**主要な操作・処理内容**：
1. ドキュメントの閲覧 - 目次からセクションへジャンプし、各トピックを読む
2. アンカーリンクによるセクション間ナビゲーション - 目次や本文中のリンクをクリックして特定のセクションへ移動
3. 外部リンクへのアクセス - SQLite公式サイトやソースコードリポジトリへのリンクを辿る
4. コード例の参照 - 各セクションに含まれるサンプルコードを確認・コピーする

**画面遷移**：
- 遷移元：なし（独立したドキュメントページ）
- 遷移先：
  - SQLite公式サイト（`https://sqlite.org/`）
  - SQLiteソースリポジトリ（`https://sqlite.org/src/`）
  - lemon.cソースファイル（`https://sqlite.org/src/file/tool/lemon.c`）
  - lempar.cテンプレートファイル（`https://sqlite.org/src/file/tool/lempar.c`）

**権限による表示制御**：なし。このドキュメントは公開されたHTMLファイルであり、認証や権限による表示制御は存在しません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | SQLパーサー/トークナイザー | 主機能 | Lemonパーサージェネレータによって生成されるパーサーのドキュメント表示。SQLiteのparse.yファイルからparse.cが生成される仕組みの解説 |

## 画面種別

ドキュメント参照（静的HTML）

## URL/ルーティング

- ローカルパス: `doc/lemon.html`
- 公開URL: `https://sqlite.org/src/file/doc/lemon.html`

## 入出力項目

本画面は静的HTMLドキュメントのため、入出力項目はありません。

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| （なし） | - | - | - | 静的コンテンツのため入出力項目なし |

## 表示項目

### セクション構成

| セクションNo | セクション名（アンカーID） | 表示内容 |
|-------------|--------------------------|---------|
| 1 | Introduction（main） | Lemonの概要、yaccやbisonとの違い、特徴の説明 |
| 1.0 | Table of Contents（toc） | ドキュメント全体の目次 |
| 2.0 | Security Note（secnot） | セキュリティに関する注意事項 |
| 3.0 | Theory of Operation（optheory） | 動作原理の説明 |
| 3.1 | Command Line Options（options） | コマンドラインオプション一覧（-b, -c, -d, -D, -E, -g, -l, -m, -p, -q, -r, -s, -T, -x） |
| 3.2 | The Parser Interface（interface） | パーサーインターフェース（ParseAlloc, ParseFree, Parse, ParseTrace） |
| 3.2.1 | Allocating The Parse Object On Stack（onstack） | スタック上でのパーサー割り当て方法 |
| 3.2.2 | Interface Summary（ifsum） | インターフェース一覧のサマリー |
| 3.3 | Differences With YACC and BISON（yaccdiff） | yaccとbisonとの違い |
| 3.4 | Building The "lemon" Executable（build） | lemon実行ファイルのビルド方法 |
| 4.0 | Input File Syntax（syntax） | 入力ファイルの文法 |
| 4.1 | Terminals and Nonterminals（tnt） | 終端記号と非終端記号の説明 |
| 4.2 | Grammar Rules（rules） | 文法規則の記述方法 |
| 4.3 | Precedence Rules（precrules） | 優先順位規則の設定方法 |
| 4.4 | Special Directives（special） | 特別ディレクティブ一覧（%code, %destructor, %include等） |
| 5.0 | Error Processing（errors） | エラー処理の仕組み |
| 6.0 | History of Lemon（history） | Lemonの歴史 |
| 7.0 | Copyright（copyright） | 著作権情報（パブリックドメイン） |

### 特別ディレクティブ一覧（セクション4.4）

| ディレクティブ | アンカーID | 説明 |
|---------------|-----------|------|
| %code | pcode | 出力ファイル末尾に追加するCコード |
| %default_destructor | default_destructor | デフォルトデストラクタ |
| %default_type | default_type | デフォルトの非終端記号データ型 |
| %destructor | destructor | 非終端記号のデストラクタ |
| %else, %endif | pifdef | 条件分岐終了 |
| %extra_argument | extraarg | Parse()関数の追加引数 |
| %extra_context | extractx | ParseAlloc()/ParseInit()の追加引数 |
| %fallback | pfallback | トークンのフォールバック定義 |
| %free | reallc | メモリ解放関数の指定 |
| %if, %ifdef, %ifndef | pifdef | 条件分岐 |
| %include | pinclude | ヘッダーインクルード |
| %left | pleft | 左結合演算子の優先順位 |
| %name | pname | 生成関数のプレフィックス変更 |
| %nonassoc | pnonassoc | 非結合演算子の優先順位 |
| %parse_accept | parse_accept | パース成功時のコールバック |
| %parse_failure | parse_failure | パース失敗時のコールバック |
| %right | pright | 右結合演算子の優先順位 |
| %realloc | reallc | メモリ再割り当て関数の指定 |
| %stack_overflow | stack_overflow | スタックオーバーフロー時のコールバック |
| %stack_size | stack_size | パーサースタックサイズ |
| %stack_size_limit | reallc | スタックサイズ上限関数 |
| %start_symbol | start_symbol | 開始記号の指定 |
| %syntax_error | syntax_error | 構文エラー時のコールバック |
| %token | token | トークンの事前宣言 |
| %token_class | token_class | トークンクラス（MULTITERMINAL） |
| %token_destructor | token_destructor | トークンのデストラクタ |
| %token_prefix | token_prefix | トークン定数のプレフィックス |
| %token_type | token_type | トークンのデータ型 |
| %type | ptype | 非終端記号のデータ型 |
| %wildcard | pwildcard | ワイルドカードトークン |

## イベント仕様

### 1-目次リンククリック

ユーザーが目次（Table of Contents）のリンクをクリックすると、対応するセクションへページ内スクロールが発生します。

- **トリガー**: `<a href="#...">` リンクのクリック
- **動作**: ブラウザ標準のアンカーリンク動作により、指定されたセクションへスクロール
- **結果**: URL末尾にアンカーが追加される（例: `lemon.html#options`）

### 2-外部リンククリック

SQLite公式サイトやソースコードリポジトリへのリンクをクリックすると、外部サイトへ遷移します。

- **トリガー**: 外部リンク（`https://sqlite.org/...`）のクリック
- **動作**: 新しいタブまたは同一タブで外部サイトを開く
- **主要な外部リンク先**:
  - `https://sqlite.org/` - SQLite公式サイト
  - `https://sqlite.org/src/file/tool/lemon.c` - lemon.cソースコード
  - `https://sqlite.org/src/file/tool/lempar.c` - lempar.cテンプレート

## データベース更新仕様

### 操作別データベース影響一覧

本画面は静的HTMLドキュメントのため、データベース操作は発生しません。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| （なし） | - | - | 静的コンテンツのためDB操作なし |

## メッセージ仕様

静的HTMLドキュメントのため、動的なメッセージ表示はありません。

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| （なし） | - | - | - |

## 例外処理

| 例外状況 | 表示内容/動作 |
|---------|-------------|
| ファイルが見つからない | ブラウザ標準の404エラー表示 |
| アンカーが存在しない | ページ先頭を表示（ブラウザ標準動作） |

## 備考

- このドキュメントは純粋な静的HTMLであり、JavaScript等の動的処理は含まれていません
- HTMLは基本的なタグ（`<h1>`, `<h2>`, `<h3>`, `<h4>`, `<p>`, `<pre>`, `<ul>`, `<li>`, `<blockquote>`, `<a>`, `<b>`, `<tt>`, `<i>`等）のみを使用したシンプルな構成です
- スタイルシートは使用されておらず、ブラウザのデフォルトスタイルで表示されます
- Lemonの著作権はパブリックドメインであり、自由に使用できます
- ドキュメントの最終更新は2016年2月16日付けの記載があります（bisonのリエントラント対応についての追記）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ドキュメント構造を理解する

まず、ドキュメントページ自体のHTML構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lemon.html | `doc/lemon.html` | HTMLドキュメントの構造、セクション構成、アンカーIDの命名規則を確認 |

**読解のコツ**: HTMLはシンプルなタグ構成で、目次は`<ul>`リストで構成され、各セクションは`<a id="..."></a>`でアンカーが設定されています。

#### Step 2: Lemonパーサージェネレータ本体を理解する

ドキュメントが説明している対象であるLemonのソースコードを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lemon.c | `tool/lemon.c` | Lemonパーサージェネレータのメイン実装（約6,075行）。データ構造、パーサー生成ロジック、出力生成を含む |

**主要処理フロー**:
1. **行65-70**: `MemChunk`構造体 - メモリ管理のためのチャンクリスト
2. **行240-242**: `struct rule`, `struct lemon`, `struct action` - パーサーの主要データ構造
3. **行330-358**: `struct symbol` - 文法記号の定義
4. **行359-392**: `struct rule` - 文法規則の定義
5. **行393以降**: `struct config` - パーサー状態の設定

#### Step 3: パーサーテンプレートを理解する

Lemonが生成するパーサーのテンプレートファイルを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lempar.c | `tool/lempar.c` | パーサーテンプレートファイル。`%%`マーカーでLemonが生成コードを挿入する箇所を確認 |

**主要処理フロー**:
- **行26**: `%%` - %include指令の挿入位置
- **行30**: `%%` - トークン定義の挿入位置
- **行93**: `%%` - 制御定数の挿入位置
- **行49-61**: ParseTOKENTYPE、YYMINORTYPE等の重要なマクロ定義

#### Step 4: テストケースを理解する

Lemonの使用例としてテストケースを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lemon-test01.y | `test/lemon-test01.y` | Lemon文法ファイルの実例。%token_prefix, %include, %syntax_error等のディレクティブの使用方法 |

**主要処理フロー**:
- **行10-11**: `%token_prefix`, `%token_type` - トークン設定
- **行13-17**: `%include` - インクルードコード
- **行19-20**: 文法規則の定義
- **行22-30**: `%syntax_error`, `%parse_accept`, `%parse_failure` - コールバック定義
- **行31-80**: `%code` - テストドライバのmain関数

### プログラム呼び出し階層図

Lemonの処理フローとドキュメントの関係を示します。

```
[ユーザー入力]
    │
    ├─ grammar.y（文法定義ファイル）
    │      │
    │      └─ lemon.c が処理
    │             │
    │             ├─ lempar.c（テンプレート）を読み込み
    │             │
    │             ├─ grammar.c（パーサー実装）を生成
    │             ├─ grammar.h（トークン定義）を生成
    │             └─ grammar.out（状態レポート）を生成
    │
    └─ lemon.html（本ドキュメント）
           │
           └─ 上記の使用方法を解説
```

### データフロー図

Lemonパーサージェネレータのデータフローを示します。

```
[入力]                    [処理]                         [出力]

grammar.y ─────────────▶ lemon.c ─────────────────────▶ grammar.c
（文法定義）               │                              （パーサー実装）
                          │
lempar.c ─────────────────┘                            grammar.h
（テンプレート）                                          （トークン定義）

                                                        grammar.out
                                                        （状態レポート）

[ドキュメント]
lemon.html ────────────▶ 開発者 ──────────────────────▶ grammar.y作成
（本ドキュメント）         （参照）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lemon.html | `doc/lemon.html` | ドキュメント | Lemonパーサージェネレータのリファレンスマニュアル（本画面） |
| lemon.c | `tool/lemon.c` | ソース | Lemonパーサージェネレータ本体の実装（約6,075行のC言語ソースコード） |
| lempar.c | `tool/lempar.c` | テンプレート | 生成されるパーサーのテンプレートファイル |
| lemon-test01.y | `test/lemon-test01.y` | テスト | Lemonのテストケース文法ファイル |
| parse.y | `src/parse.y` | ソース | SQLiteのSQL文法定義ファイル（Lemonで処理される） |
