# 画面設計書 3-基本デモ（UIスレッド版）

## 概要

本ドキュメントは、SQLite WASMをWebページのUIスレッドで動作させる基本デモ（demo-123.html）の画面設計書です。

### 本画面の処理概要

この画面は、SQLite3 WASMライブラリをUIスレッドで直接使用する最もシンプルなデモンストレーションを提供します。

**業務上の目的・背景**：開発者がSQLite WASMをWebアプリケーションに組み込む際の基本的な実装パターンを理解するためのリファレンス実装です。UIスレッドでの実行により、Workerを使用しない最もシンプルな統合方法を示します。ただし、UIスレッドでの実行はデータベース操作中にUIがブロックされる可能性があるため、大規模なデータベース操作には適していません。

**画面へのアクセス方法**：HTTPサーバー経由で `demo-123.html` にアクセスします。jswasm/sqlite3.jsとdemo-123.jsを読み込むため、makeを実行してビルドが完了している必要があります。

**主要な操作・処理内容**：
1. SQLite3 WASMモジュールの初期化 - `sqlite3InitModule()` によるWASMロードと初期化
2. インメモリデータベースの作成 - `new oo.DB("/mydb.sqlite3",'ct')` でトランジェントDB作成
3. テーブル作成 - CREATE TABLE文の実行
4. データ挿入 - INSERT文によるパラメータバインドを使用したデータ挿入
5. データ検索 - SELECT文の実行と各種rowModeでの結果取得
6. UDF（ユーザー定義関数）作成 - `db.createFunction()` によるスカラー関数の実装
7. トランザクション制御 - `db.transaction()` と `db.savepoint()` によるロールバックデモ

**画面遷移**：
- 遷移先画面：なし
- 遷移元画面：index.html、index-dist.html

**権限による表示制御**：なし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | SQLiteライブラリ初期化 | 主機能 | sqlite3InitModule()によるWASMモジュール初期化 |
| 2 | データベース接続管理 | 主機能 | new oo.DB()によるインメモリDB作成・接続 |
| 3 | バージョン情報取得 | 補助機能 | capi.sqlite3_libversion()でのバージョン表示 |
| 10 | CREATE TABLE処理 | 主機能 | db.exec("CREATE TABLE IF NOT EXISTS t(a,b)")でテーブル作成 |
| 7 | INSERT文処理 | 主機能 | db.exec()でのINSERT文実行 |
| 6 | SELECT文処理 | 主機能 | db.exec()でのSELECT文実行とコールバック処理 |
| 15 | トランザクション管理 | 補助機能 | db.transaction()によるトランザクション制御 |
| 28 | 組み込みSQL関数 | 補助機能 | UDF作成（db.createFunction）でのスカラー関数実装 |

## 画面種別

デモ（実行結果表示）

## URL/ルーティング

`ext/wasm/demo-123.html`

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| なし | - | - | 本画面はユーザー入力を受け付けない自動実行デモ |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| タイトル | h1 | "1-2-sqlite3 demo" |
| ログ出力 | body | 各処理ステップの実行結果をdiv要素として追加表示 |
| SQLiteバージョン | ログ | "sqlite3 version X.X.X" |
| DB filename | ログ | "transient db = /mydb.sqlite3" |
| 各操作結果 | ログ | INSERT、SELECT、UDF等の実行結果 |

## イベント仕様

### 1-ページロード（自動実行）

**トリガー**: ページロード完了時

**処理内容**:
1. **行252**: sqlite3InitModule()を呼び出してWASMモジュールをロード
2. **行275-288**: Promise解決後にdemo1()関数を実行
3. **行44-250**: demo1()内でDB作成、テーブル作成、INSERT、SELECT、UDF作成、トランザクションデモを順次実行
4. **行227-228**: 最後にdb.close()でDB接続をクローズ

**画面遷移**: なし

### 2-テーブル作成

**トリガー**: demo1()関数実行時（行59-65）

**処理内容**:
```javascript
db.exec("CREATE TABLE IF NOT EXISTS t(a,b)");
// または
db.exec({sql:"CREATE TABLE IF NOT EXISTS t(a,b)"});
```

**データベース操作**: CREATE TABLE（存在しない場合のみ）

### 3-データ挿入

**トリガー**: demo1()関数実行時（行71-104）

**処理内容**:
1. パラメータインデックスによるバインド: `bind: [i, i*2]`
2. パラメータ名によるバインド: `bind: {$a: i * 10, $b: i * 20}`
3. Prepared Statementを使用した挿入: `q.bind([i, i*2]).step()`

### 4-データ検索

**トリガー**: demo1()関数実行時（行106-158）

**処理内容**:
- rowMode 'array': 結果を配列として取得
- rowMode 'object': 結果をオブジェクトとして取得
- rowMode 'stmt': Statement objectを直接操作
- rowMode INTEGER: 指定インデックスの列値を取得
- rowMode '$COLNAME': 指定列名の値を取得

### 5-UDF作成と実行

**トリガー**: demo1()関数実行時（行160-186）

**処理内容**:
```javascript
db.createFunction({
  name: 'twice',
  xFunc: function(pCx, arg){
    return arg + arg;
  }
});
```

### 6-トランザクションロールバックデモ

**トリガー**: demo1()関数実行時（行188-226）

**処理内容**:
1. `db.transaction()` 内で例外をスローしてロールバック
2. `db.savepoint()` でネストしたセーブポイントのロールバック

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テーブル作成 | t | CREATE | CREATE TABLE IF NOT EXISTS t(a,b) |
| データ挿入 | t | INSERT | 複数のINSERT文でテストデータ投入 |
| データ検索 | t | SELECT | 各種rowModeでのSELECT実行 |
| トランザクションテスト | t | DELETE/INSERT | トランザクション内でDELETE/INSERT後ロールバック |

### テーブル別更新項目詳細

#### テーブル t

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | a, b | i, i*2 (i=20-25) | パラメータインデックスバインド |
| INSERT | a, b | i*10, i*20 (i=20-25) | パラメータ名バインド |
| INSERT | a, b | i, i*2 (i=100-105) | Prepared Statement使用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| LOG-001 | 情報 | "Loading and initializing sqlite3 module..." | ページロード時 |
| LOG-002 | 情報 | "sqlite3 version X.X.X" | 初期化完了時 |
| LOG-003 | 情報 | "transient db = /mydb.sqlite3" | DB作成完了時 |
| LOG-004 | 警告 | "Got expected exception: ..." | UDF引数エラー時 |
| LOG-005 | 情報 | "That's all, folks!" | 全処理完了時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|----------|
| WASMロード失敗 | error()関数でエラーメッセージを赤色表示 |
| UDF引数不正 | 例外をキャッチしてwarn()で警告表示（デモの一部） |
| トランザクション内例外 | SQLite3Errorをキャッチしてログ表示後、正常にロールバック |

## 備考

- UIスレッドで実行されるため、大規模なDB操作時はUIがブロックされる
- Worker版（demo-123-worker.html）との比較参照を推奨
- demo-123.jsはUIスレッドとWorkerスレッドの両方で動作するよう設計されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | demo-123.js | `ext/wasm/demo-123.js` | sqlite3オブジェクトの構造（capi, oo1） |

**読解のコツ**:
- `sqlite3.capi` はC-style API
- `sqlite3.oo1` は高レベルOO API
- `oo.DB` クラスがデータベース接続を表現

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | demo-123.html | `ext/wasm/demo-123.html` | HTML構造とスクリプト読み込み順序 |
| 2-2 | demo-123.js | `ext/wasm/demo-123.js` | 即時関数による初期化処理 |

**主要処理フロー**:
1. **行21**: jswasm/sqlite3.js読み込み
2. **行22**: demo-123.js読み込み
3. **行252-289**: sqlite3InitModule()でWASM初期化、完了後demo1()実行

#### Step 3: UIスレッド/Workerスレッド判定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | demo-123.js | `ext/wasm/demo-123.js` | 行23-39のスレッド判定とlogHtml設定 |

**主要処理フロー**:
- **行23**: `globalThis.window === globalThis` でUIスレッドを判定
- **行25-30**: UIスレッド時はDOM要素を直接追加
- **行32-38**: Workerスレッド時はpostMessage()で親に通知

#### Step 4: データベース操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | demo-123.js | `ext/wasm/demo-123.js` | demo1()関数の詳細（行44-250） |

**主要処理フロー**:
- **行48**: DB作成 `new oo.DB("/mydb.sqlite3",'ct')`
- **行59-65**: CREATE TABLE実行
- **行71-84**: パラメータバインドによるINSERT
- **行87-104**: Prepared StatementによるINSERT
- **行106-158**: 各種rowModeでのSELECT
- **行160-178**: UDF作成と使用
- **行188-226**: トランザクション/セーブポイントデモ

### プログラム呼び出し階層図

```
demo-123.html (ページロード)
    │
    ├─ sqlite3.js (WASMローダー)
    │
    └─ demo-123.js
           │
           ├─ sqlite3InitModule()
           │      └─ Promise.then() → demo1()
           │
           └─ demo1(sqlite3)
                  ├─ new oo.DB() → DB作成
                  ├─ db.exec() → CREATE TABLE
                  ├─ db.exec() → INSERT (パラメータバインド)
                  ├─ db.prepare() → Prepared Statement
                  │      └─ q.bind().step() → INSERT
                  ├─ db.exec() → SELECT (callback)
                  ├─ db.createFunction() → UDF作成
                  ├─ db.transaction() → ロールバックデモ
                  ├─ db.savepoint() → ネストセーブポイント
                  └─ db.close() → DB切断
```

### データフロー図

```
[入力]               [処理]                    [出力]

ページロード ───▶ sqlite3InitModule() ───▶ sqlite3オブジェクト
                        │
                        └───▶ demo1(sqlite3)
                                    │
                        ┌───────────┴───────────┐
                        │                       │
                   new oo.DB()            logHtml()
                        │                       │
                        ▼                       ▼
                   DBオブジェクト ─────▶ 実行結果表示
                        │
            ┌───────────┼───────────┐
            │           │           │
        exec()     prepare()   createFunction()
            │           │           │
            ▼           ▼           ▼
       SQL実行     バインド/実行   UDF登録
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| demo-123.html | `ext/wasm/demo-123.html` | テンプレート | デモページHTML |
| demo-123.js | `ext/wasm/demo-123.js` | ソース | デモロジック実装 |
| sqlite3.js | `ext/wasm/jswasm/sqlite3.js` | ソース | WASM初期化ローダー |
| sqlite3.wasm | `ext/wasm/jswasm/sqlite3.wasm` | バイナリ | SQLite WASMモジュール |
