# 画面設計書 7-Worker1Promiserデモ

## 概要

本ドキュメントは、Worker1 APIのPromiseベースラッパーのデモ（demo-worker1-promiser.c-pp.html）の画面設計書です。

### 本画面の処理概要

この画面は、Worker1 APIをPromiseでラップしたsqlite3-worker1-promiser.jsのデモンストレーションを提供します。

**業務上の目的・背景**：Worker1 API（demo-worker1.html）は低レベルのメッセージパッシングを直接扱う必要があり、非同期処理の管理が複雑です。Promiserラッパーを使用することで、async/await構文やPromiseチェーンによる直感的な非同期DB操作が可能になります。これは実際のアプリケーション開発において推奨されるアプローチです。

**画面へのアクセス方法**：HTTPサーバー経由で `demo-worker1-promiser.html` にアクセスします。開発者コンソールで詳細な出力を確認します。C preprocessorテンプレート（.c-pp.html）からビルド時に生成されます。

**主要な操作・処理内容**：
1. Promiser初期化 - sqlite3Worker1Promiser()でPromise対応Workerを作成
2. DBオープン - promiser('open', {...})でDB接続
3. SQL実行 - promiser('exec', {...})でPromiseベースのSQL実行
4. 設定取得 - promiser('config-get')でWorker設定を取得
5. DBクローズ - promiser('close', {...})でDB切断

**画面遷移**：
- 遷移先画面：なし
- 遷移元画面：index.html、index-dist.html

**権限による表示制御**：なし

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | SQLiteライブラリ初期化 | 主機能 | Promiser APIでのモジュール初期化 |
| 2 | データベース接続管理 | 主機能 | Promise経由でのDB接続管理 |

## 画面種別

テスト（開発者向け）

## URL/ルーティング

`ext/wasm/demo-worker1-promiser.c-pp.html`（ソース）
`ext/wasm/demo-worker1-promiser.html`（ビルド後）

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| なし | - | - | 本画面はユーザー入力を受け付けない自動テスト |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| タイトルバー | ヘッダー | "worker-promise tests" |
| 説明文 | 中央 | "Most stuff on this page happens in the dev console." |
| テスト出力 | 下部 | テスト結果のログ表示 |
| 初期化スピナー | 中央 | WASM初期化中に表示 |

## イベント仕様

### 1-ページロード（Promiser初期化とテスト実行）

**トリガー**: ページロード完了時

**処理内容**:
1. sqlite3-worker1-promiser.jsを読み込み
2. `sqlite3Worker1Promiser()` でPromiser初期化
3. 'onready'イベント受信後にテスト実行

**HTMLソース（行38-40）**:
```html
<script src="jswasm/sqlite3-worker1-promiser.js"></script>
<script src="demo-worker1-promiser.js"></script>
```

### 2-Promiser初期化

**トリガー**: ページロード時

**処理内容**:
```javascript
const promiser = sqlite3Worker1Promiser({
  onready: function(){
    // Worker準備完了
  },
  onerror: function(e){
    // エラー処理
  }
});
```

### 3-DBオープン

**トリガー**: onready後のテスト実行時

**処理内容**:
```javascript
await promiser('open', {
  filename: ':memory:'
});
```

### 4-SQL実行

**トリガー**: DBオープン後

**処理内容**:
```javascript
await promiser('exec', {
  sql: 'CREATE TABLE t(a,b)',
  resultRows: [],
  columnNames: []
});
```

### 5-設定取得

**トリガー**: テスト中

**処理内容**:
```javascript
await promiser('config-get');
```

### 6-DBクローズ

**トリガー**: テスト終了時

**処理内容**:
```javascript
await promiser('close');
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| open | - | CONNECT | インメモリDBを開く |
| exec (create) | t | CREATE | CREATE TABLE t(a,b) |
| exec (insert) | t | INSERT | テストデータ挿入 |
| exec (select) | t | SELECT | データ取得 |
| close | - | DISCONNECT | DB接続終了 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| LOG-001 | 情報 | "Promiser is ready." | Worker準備完了時 |
| LOG-002 | 情報 | テスト結果 | 各テスト完了時 |
| ERR-001 | エラー | "Promiser error: {message}" | Promiserエラー時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|----------|
| Promiser初期化失敗 | onerrorコールバックでエラーログ出力 |
| Promise rejection | catch()でエラーハンドリング |

## 備考

- ESMモジュール版（demo-worker1-promiser-esm.html）も存在
- C preprocessorテンプレート（#if/#endif）でESM/conventional版を切り替え
- async/await構文が使用可能な環境が必要

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | demo-worker1-promiser.c-pp.html | `ext/wasm/demo-worker1-promiser.c-pp.html` | Promiser APIの呼び出し形式 |

**読解のコツ**:
- `sqlite3Worker1Promiser()` がPromiser factoryファンクション
- 返り値の `promiser` はasync function（Promiseを返す）
- Worker1 APIと同じメッセージタイプ（'open', 'exec', 'close'等）を使用

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | demo-worker1-promiser.c-pp.html | `ext/wasm/demo-worker1-promiser.c-pp.html` | HTML構造とC preprocessorディレクティブ |

**主要処理フロー**:
1. **行9-13**: C preprocessor条件分岐（ESM版/conventional版）
2. **行35-40**: スクリプト読み込み（条件分岐あり）
3. **行38-39**: conventional版: promiser.jsとdemo-worker1-promiser.js読み込み
4. **行36**: ESM版: demo-worker1-promiser.mjs読み込み（type="module"）

#### Step 3: Promiserの使い方を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | sqlite3-worker1-promiser.js | `ext/wasm/jswasm/sqlite3-worker1-promiser.js` | Promiser実装 |

**主要API**:
- `sqlite3Worker1Promiser({onready, onerror})` - Promiser初期化
- `promiser(type, args)` - Promiseを返すAPI呼び出し
- typeは 'open', 'exec', 'close', 'config-get' 等

#### Step 4: Worker1 APIとの比較

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | demo-worker1.js | `ext/wasm/demo-worker1.js` | Worker1 API（比較用） |

**主要な違い**:
- Worker1 API: コールバックベース、MsgHandlerQueueで管理
- Promiser: Promiseベース、async/await使用可能
- Promiserはメッセージパッシングの詳細を隠蔽

### プログラム呼び出し階層図

```
demo-worker1-promiser.html (ページロード)
    │
    ├─ SqliteTestUtil.js (テストユーティリティ)
    │
    ├─ sqlite3-worker1-promiser.js
    │      │
    │      └─ sqlite3Worker1Promiser({onready, onerror})
    │             │
    │             └─ 内部でnew Worker("sqlite3-worker1.js")
    │
    └─ demo-worker1-promiser.js
           │
           └─ onready()
                  │
                  └─ async function runTests()
                         │
                         ├─ await promiser('open',...)
                         ├─ await promiser('exec',...)
                         ├─ await promiser('config-get')
                         └─ await promiser('close')
```

### データフロー図

```
[クライアントコード]          [Promiser]           [Worker]

promiser('open',...) ──────▶ Promise生成
                                 │
                                 └──▶ postMessage()
                                            │
                                            ▼
                                      Worker処理
                                            │
                        resolve/reject ◀───┘
                             │
await結果 ◀─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| demo-worker1-promiser.c-pp.html | `ext/wasm/demo-worker1-promiser.c-pp.html` | テンプレート | テストページ（C preprocessor） |
| demo-worker1-promiser.html | `ext/wasm/demo-worker1-promiser.html` | テンプレート | ビルド後HTML |
| demo-worker1-promiser.js | `ext/wasm/demo-worker1-promiser.js` | ソース | テストロジック |
| demo-worker1-promiser.mjs | `ext/wasm/demo-worker1-promiser.mjs` | ソース | ESM版テストロジック |
| sqlite3-worker1-promiser.js | `ext/wasm/jswasm/sqlite3-worker1-promiser.js` | ソース | Promiserラッパー実装 |
