---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-WASMテストページインデックス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/wasm/index.html` 行1-185
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行2
- E-03: `docs/code-to-docs/画面遷移図.md` 行49-66
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行2-3

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページタイトルは"sqlite3 WASM Testing Page Index" | E-01 行8 | ○ |
| C-02 | ヘッダーに"sqlite3 WASM test pages"が表示される | E-01 行19 | ○ |
| C-03 | althttpd -enable-sab -page index.htmlで起動 | E-01 行25 | ○ |
| C-04 | HTTPサーバー経由でのアクセスが必要 | E-01 行29-31 | ○ |
| C-05 | OPFS関連ページはCOOP/COEPヘッダーが必要 | E-01 行37-43 | ○ |
| C-06 | Core tests、High-level apps等のカテゴリ分け | E-01 行50-155 | ○ |
| C-07 | 32-bit/64-bit版の両方へのリンク提供 | E-01 行52-53, 96-98 | ○ |
| C-08 | kvvfs、opfs等のVFS指定リンク | E-01 行100-123 | ○ |
| C-09 | リンクのtarget属性が動的に設定される | E-01 行179-182 | ○ |
| C-10 | URLパスからホスト部分を除去してtargetに設定 | E-01 行181 | ○ |
| C-11 | testing.cssが読み込まれる | E-01 行7 | ○ |
| C-12 | headerの背景色は#044a64 | E-01 行13 | ○ |
| C-13 | テストリストのフォントサイズは120% | E-01 行177 | ○ |
| C-14 | 関連機能としてSQLiteライブラリ初期化がある | E-04 行2 | ○ |
| C-15 | 関連機能としてバージョン情報取得がある | E-04 行3 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] index.htmlの実際のリンク一覧と設計書の記載が一致しているか確認
- [ ] testing.cssの実際のスタイル定義を確認
- [ ] 画面遷移図との整合性を確認
